/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive2.block;

import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.BlockItem;
import java.io.IOException;
import java.io.InputStream;

public abstract class ZipBlock
extends BlockItem {
    public ZipBlock(int bytesLength) {
        super(bytesLength);
    }

    public void putBytes(byte[] bytes, int offset, int putOffset, int length) {
        if (length <= 0 || bytes.length == 0) {
            return;
        }
        int size = putOffset + length;
        this.setBytesLength(size, false);
        System.arraycopy(bytes, offset, this.getBytesInternal(), putOffset, length);
    }

    @Override
    public abstract int readBytes(InputStream var1) throws IOException;

    @Override
    public void onReadBytes(BlockReader blockReader) throws IOException {
        this.readBytes((InputStream)blockReader);
    }

    byte[] getBytes(int offset, int length, boolean strict) {
        byte[] bytes = this.getBytesInternal();
        if (strict && (offset < 0 || offset >= bytes.length || offset + length > bytes.length)) {
            return null;
        }
        if (offset < 0) {
            offset = 0;
        }
        int available = bytes.length - offset;
        if (length <= 0 || available <= 0) {
            return new byte[0];
        }
        if (length > available) {
            length = available;
        }
        byte[] result = new byte[length];
        System.arraycopy(this.getBytesInternal(), offset, result, 0, length);
        return result;
    }

    long getLong(int offset) {
        return ZipBlock.getLong(this.getBytesInternal(), offset);
    }

    void putLong(int offset, long value) {
        ZipBlock.putLong(this.getBytesInternal(), offset, value);
    }

    long getIntegerUnsigned(int offset) {
        return (long)this.getInteger(offset) & 0xFFFFFFFFL;
    }

    void putBit(int offset, int bitIndex, boolean bit) {
        ZipBlock.putBit(this.getBytesInternal(), offset, bitIndex, bit);
    }

    boolean getBit(int offset, int bitIndex) {
        return ZipBlock.getBit(this.getBytesInternal(), offset, bitIndex);
    }

    int getByteUnsigned(int offset) {
        return this.getBytesInternal()[offset] & 0xFF;
    }

    int getShortUnsigned(int offset) {
        return ZipBlock.getShort(this.getBytesInternal(), offset) & 0xFFFF;
    }

    int getInteger(int offset) {
        return ZipBlock.getInteger(this.getBytesInternal(), offset);
    }

    void putInteger(int offset, int value) {
        ZipBlock.putInteger(this.getBytesInternal(), offset, value);
    }

    void putInteger(int offset, long value) {
        ZipBlock.putInteger(this.getBytesInternal(), offset, (int)value);
    }

    void putShort(int offset, int value) {
        ZipBlock.putShort(this.getBytesInternal(), offset, (short)value);
    }
}

