/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive2.block;

import com.reandroid.archive2.block.LengthPrefixedBlock;
import com.reandroid.archive2.block.SignatureId;
import com.reandroid.archive2.block.SignatureScheme;
import com.reandroid.archive2.block.UnknownScheme;
import com.reandroid.archive2.block.pad.SchemePadding;
import com.reandroid.archive2.block.stamp.SchemeStampV1;
import com.reandroid.archive2.block.stamp.SchemeStampV2;
import com.reandroid.archive2.block.v2.SchemeV2;
import com.reandroid.archive2.block.v3.SchemeV3;
import com.reandroid.archive2.block.v3.SchemeV31;
import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.container.SingleBlockContainer;
import com.reandroid.arsc.io.BlockLoad;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerItem;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class SignatureInfo
extends LengthPrefixedBlock
implements BlockLoad {
    private final IntegerItem idItem = new IntegerItem();
    private final SingleBlockContainer<SignatureScheme> schemeContainer = new SingleBlockContainer();

    public SignatureInfo() {
        super(2, true);
        this.addChild(this.idItem);
        this.addChild(this.schemeContainer);
        this.idItem.setBlockLoad(this);
    }

    public int getIdValue() {
        return this.idItem.get();
    }

    public SignatureId getId() {
        return SignatureId.valueOf(this.getIdValue());
    }

    public void setId(int id) {
        this.idItem.set(id);
    }

    public void setId(SignatureId signatureId) {
        this.setId(signatureId == null ? 0 : signatureId.getId());
    }

    public SignatureScheme getSignatureScheme() {
        return this.schemeContainer.getItem();
    }

    public void setSignatureScheme(SignatureScheme signatureScheme) {
        this.schemeContainer.setItem(signatureScheme);
    }

    @Override
    public void onBlockLoaded(BlockReader reader, Block sender) throws IOException {
        if (sender == this.idItem) {
            this.onIdLoaded();
        }
    }

    private void onIdLoaded() {
        SignatureId signatureId = this.getId();
        SignatureScheme scheme = signatureId == SignatureId.V2 ? new SchemeV2() : (signatureId == SignatureId.V3 ? new SchemeV3() : (signatureId == SignatureId.V31 ? new SchemeV31() : (signatureId == SignatureId.STAMP_V1 ? new SchemeStampV1() : (signatureId == SignatureId.STAMP_V2 ? new SchemeStampV2() : (signatureId == SignatureId.PADDING ? new SchemePadding() : new UnknownScheme(signatureId))))));
        this.schemeContainer.setItem(scheme);
    }

    public void writeRaw(File file) throws IOException {
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        this.writeBytes(outputStream);
        outputStream.close();
    }

    public File writeRawToDirectory(File dir) throws IOException {
        String name = this.getIndex() + "_" + this.getId().toFileName();
        File file = new File(dir, name);
        this.writeRaw(file);
        return file;
    }

    public void read(File file) throws IOException {
        super.readBytes(new BlockReader(file));
    }

    @Override
    public String toString() {
        return this.getId() + ", scheme: " + this.getSignatureScheme();
    }
}

