/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive2.block;

import com.reandroid.arsc.coder.CoderHex;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.util.HexUtil;
import java.util.Objects;

public class SignatureId
implements Comparable<SignatureId> {
    private final String name;
    private final int id;
    private final int sort;
    public static final SignatureId V2 = new SignatureId("V2", 1896449818, 0);
    public static final SignatureId V3 = new SignatureId("V3", -262969152, 1);
    public static final SignatureId V31 = new SignatureId("V31", 462663009, 2);
    public static final SignatureId STAMP_V1 = new SignatureId("STAMP_V1", 722016414, 3);
    public static final SignatureId STAMP_V2 = new SignatureId("STAMP_V2", 1845461005, 4);
    public static final SignatureId PADDING = new SignatureId("PADDING", 1114793335, 9999);
    public static final SignatureId NULL = new SignatureId("NULL", 0, 999);
    private static final SignatureId[] VALUES = new SignatureId[]{V2, V3, V31, STAMP_V1, STAMP_V2, PADDING, NULL};
    public static final String FILE_EXT_RAW = ".signature.info.bin";

    private SignatureId(String name, int id, int sort) {
        this.name = name;
        this.id = id;
        this.sort = sort;
    }

    public String name() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public String toFileName() {
        if (this.name != null) {
            return this.name + FILE_EXT_RAW;
        }
        return HexUtil.toHex8(this.id) + FILE_EXT_RAW;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SignatureId that = (SignatureId)obj;
        return this.id == that.id;
    }

    @Override
    public int compareTo(SignatureId signatureId) {
        return Integer.compare(this.sort, signatureId.sort);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        String name = this.name;
        if (name != null) {
            return name;
        }
        return "UNKNOWN(" + HexUtil.toHex8(this.id) + ")";
    }

    public static SignatureId valueOf(String name) {
        if (name == null) {
            return null;
        }
        String ext = FILE_EXT_RAW;
        if (name.endsWith(ext)) {
            name = name.substring(0, name.length() - ext.length());
        }
        for (SignatureId signatureId : VALUES) {
            if (!name.equalsIgnoreCase(signatureId.name())) continue;
            return signatureId;
        }
        EncodeResult hex = CoderHex.INS.encode(name);
        if (hex != null) {
            return new SignatureId(null, hex.value, 99);
        }
        return null;
    }

    public static SignatureId valueOf(int id) {
        for (SignatureId signatureId : VALUES) {
            if (id != signatureId.getId()) continue;
            return signatureId;
        }
        return new SignatureId(null, id, 99);
    }

    public static SignatureId[] values() {
        return (SignatureId[])VALUES.clone();
    }
}

