/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive2.block;

import com.reandroid.archive2.ZipSignature;
import com.reandroid.archive2.block.CentralEntryHeader;
import com.reandroid.archive2.block.CommonHeader;
import com.reandroid.archive2.block.DataDescriptor;
import java.io.IOException;
import java.io.InputStream;

public class LocalFileHeader
extends CommonHeader {
    private DataDescriptor dataDescriptor;
    private static final int OFFSET_signature = 0;
    private static final int OFFSET_versionMadeBy = 4;
    private static final int OFFSET_platform = 5;
    private static final int OFFSET_general_purpose = 6;
    private static final int OFFSET_method = 8;
    private static final int OFFSET_dos_time = 10;
    private static final int OFFSET_crc = 14;
    private static final int OFFSET_compressed_size = 18;
    private static final int OFFSET_size = 22;
    private static final int OFFSET_fileNameLength = 26;
    private static final int OFFSET_extraLength = 28;
    private static final int OFFSET_fileName = 30;

    public LocalFileHeader() {
        super(30, ZipSignature.LOCAL_FILE, 6);
    }

    public LocalFileHeader(String name) {
        this();
        this.setFileName(name);
    }

    public void mergeZeroValues(CentralEntryHeader ceh) {
        if (this.getCrc() == 0L) {
            this.setCrc(ceh.getCrc());
        }
        if (this.getSize() == 0L) {
            this.setSize(ceh.getSize());
        }
        if (this.getCompressedSize() == 0L) {
            this.setCompressedSize(ceh.getCompressedSize());
        }
        if (this.getGeneralPurposeFlag().getValue() == 0) {
            this.getGeneralPurposeFlag().setValue(ceh.getGeneralPurposeFlag().getValue());
        }
    }

    public DataDescriptor getDataDescriptor() {
        return this.dataDescriptor;
    }

    public void setDataDescriptor(DataDescriptor dataDescriptor) {
        this.dataDescriptor = dataDescriptor;
        this.getGeneralPurposeFlag().setHasDataDescriptor(dataDescriptor != null);
    }

    public static LocalFileHeader fromCentralEntryHeader(CentralEntryHeader ceh) {
        LocalFileHeader lfh = new LocalFileHeader();
        lfh.setSignature(ZipSignature.LOCAL_FILE);
        lfh.setVersionMadeBy(ceh.getVersionMadeBy());
        lfh.getGeneralPurposeFlag().setValue(ceh.getGeneralPurposeFlag().getValue());
        lfh.setMethod(ceh.getMethod());
        lfh.setDosTime(ceh.getDosTime());
        lfh.setCrc(ceh.getCrc());
        lfh.setCompressedSize(ceh.getCompressedSize());
        lfh.setSize(ceh.getSize());
        lfh.setFileName(ceh.getFileName());
        lfh.setExtra(ceh.getExtra());
        return lfh;
    }

    public static LocalFileHeader read(InputStream inputStream) throws IOException {
        LocalFileHeader localFileHeader = new LocalFileHeader();
        localFileHeader.readBytes(inputStream);
        if (localFileHeader.isValidSignature()) {
            return localFileHeader;
        }
        return null;
    }
}

