/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive2.block;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.container.ExpandableBlockContainer;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.LongItem;
import java.io.IOException;

public class LengthPrefixedBlock
extends ExpandableBlockContainer {
    private final Block numberBlock;

    public LengthPrefixedBlock(int childesCount, boolean is_long) {
        super(1 + childesCount);
        BlockItem numberBlock = is_long ? new LongItem() : new IntegerItem();
        this.numberBlock = numberBlock;
        this.addChild(this.numberBlock);
    }

    public long getDataSize() {
        Block numberBlock = this.numberBlock;
        if (numberBlock instanceof LongItem) {
            return ((LongItem)numberBlock).get();
        }
        return ((IntegerItem)numberBlock).get();
    }

    public void setDataSize(long dataSize) {
        Block numberBlock = this.numberBlock;
        if (numberBlock instanceof LongItem) {
            ((LongItem)numberBlock).set(dataSize);
        } else {
            ((IntegerItem)numberBlock).set((int)dataSize);
        }
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        if (!reader.isAvailable()) {
            return;
        }
        Block numberBlock = this.numberBlock;
        numberBlock.readBytes(reader);
        int dataSize = (int)this.getDataSize();
        if (dataSize <= 0) {
            this.onSizeLoaded(0);
            return;
        }
        this.onSizeLoaded(dataSize);
        BlockReader chunkReader = reader.create(dataSize);
        Block[] childes = this.getChildes();
        for (int i = 0; i < childes.length; ++i) {
            Block child = childes[i];
            if (child == numberBlock) continue;
            child.readBytes(chunkReader);
        }
        reader.offset(dataSize);
    }

    protected void onSizeLoaded(int dataSize) {
    }

    @Override
    protected void onRefreshed() {
        int size = this.countBytes() - this.numberBlock.countBytes();
        this.setDataSize(size);
    }

    public String toString() {
        return "size=" + this.numberBlock;
    }
}

