/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive2.block;

import com.reandroid.archive2.ZipSignature;
import com.reandroid.archive2.block.ZipHeader;
import com.reandroid.arsc.util.HexUtil;

public class EndRecord
extends ZipHeader {
    private static final int OFFSET_numberOfDisk = 4;
    private static final int OFFSET_centralDirectoryStartDisk = 6;
    private static final int OFFSET_numberOfDirectories = 8;
    private static final int OFFSET_totalNumberOfDirectories = 10;
    private static final int OFFSET_lengthOfCentralDirectory = 12;
    private static final int OFFSET_offsetOfCentralDirectory = 16;
    private static final int OFFSET_lastShort = 20;
    public static final int MIN_LENGTH = 22;
    public static final int MAX_LENGTH = 65557;

    public EndRecord() {
        super(22, ZipSignature.END_RECORD);
    }

    public int getNumberOfDisk() {
        return this.getShortUnsigned(4);
    }

    public void setNumberOfDisk(int value) {
        this.putShort(4, value);
    }

    public int getCentralDirectoryStartDisk() {
        return this.getShortUnsigned(6);
    }

    public void setCentralDirectoryStartDisk(int value) {
        this.putShort(6, value);
    }

    public int getNumberOfDirectories() {
        return this.getShortUnsigned(8);
    }

    public void setNumberOfDirectories(int value) {
        this.putShort(8, value);
    }

    public int getTotalNumberOfDirectories() {
        return this.getShortUnsigned(10);
    }

    public void setTotalNumberOfDirectories(int value) {
        this.putShort(10, value);
    }

    public long getLengthOfCentralDirectory() {
        return this.getIntegerUnsigned(12);
    }

    public void setLengthOfCentralDirectory(long value) {
        this.putInteger(12, value);
    }

    public long getOffsetOfCentralDirectory() {
        return this.getIntegerUnsigned(16);
    }

    public void setOffsetOfCentralDirectory(int value) {
        this.putInteger(16, value);
    }

    public int getLastShort() {
        return this.getShortUnsigned(20);
    }

    public void getLastShort(int value) {
        this.putShort(20, value);
    }

    public String toString() {
        if (this.countBytes() < this.getMinByteLength()) {
            return "Invalid";
        }
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.getSignature());
        builder.append(", disks=").append(this.getNumberOfDisk());
        builder.append(", start disk=").append(this.getCentralDirectoryStartDisk());
        builder.append(", dirs=").append(this.getNumberOfDirectories());
        builder.append(", total dirs=").append(this.getTotalNumberOfDirectories());
        builder.append(", length=").append(this.getLengthOfCentralDirectory());
        builder.append(", offset=").append(this.getOffsetOfCentralDirectory());
        builder.append(", last=").append(HexUtil.toHex8(this.getLastShort()));
        return builder.toString();
    }
}

