/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive2.block;

import com.reandroid.archive2.ZipSignature;
import com.reandroid.archive2.block.ZipHeader;
import com.reandroid.arsc.util.HexUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public abstract class CommonHeader
extends ZipHeader {
    private final int offsetFileName;
    private final int offsetGeneralPurpose;
    private final GeneralPurposeFlag generalPurposeFlag;
    private String mFileName;
    private long mFileOffset;
    private static final int OFFSET_versionMadeBy = 4;
    private static final int OFFSET_platform = 5;
    private static final int OFFSET_general_purpose = 6;
    private static final int OFFSET_method = 8;
    private static final int OFFSET_dos_time = 10;
    private static final int OFFSET_crc = 14;
    private static final int OFFSET_compressed_size = 18;
    private static final int OFFSET_size = 22;
    private static final int OFFSET_fileNameLength = 26;
    private static final int OFFSET_extraLength = 28;
    private static final int OFFSET_fileName = 30;

    public CommonHeader(int offsetFileName, ZipSignature expectedSignature, int offsetGeneralPurpose) {
        super(offsetFileName, expectedSignature);
        this.offsetFileName = offsetFileName;
        this.offsetGeneralPurpose = offsetGeneralPurpose;
        this.generalPurposeFlag = new GeneralPurposeFlag(this, offsetGeneralPurpose);
        this.generalPurposeFlag.setUtf8(true, false);
        this.setDosTime(35719201L);
    }

    public long getFileOffset() {
        return this.mFileOffset;
    }

    public void setFileOffset(long fileOffset) {
        this.mFileOffset = fileOffset;
    }

    public long getDataSize() {
        if (this.getMethod() == 0) {
            return this.getSize();
        }
        return this.getCompressedSize();
    }

    public void setDataSize(long size) {
        if (this.getMethod() == 0) {
            this.setSize(size);
        }
        this.setCompressedSize(size);
    }

    @Override
    int readNext(InputStream inputStream) throws IOException {
        int read = 0;
        read += this.readFileName(inputStream);
        read += this.readExtra(inputStream);
        this.mFileName = null;
        return read += this.readComment(inputStream);
    }

    private int readFileName(InputStream inputStream) throws IOException {
        int fileNameLength = this.getFileNameLength();
        if (fileNameLength == 0) {
            this.mFileName = "";
            return 0;
        }
        this.setFileNameLength(fileNameLength);
        byte[] bytes = this.getBytesInternal();
        int read = inputStream.read(bytes, this.offsetFileName, fileNameLength);
        if (read != fileNameLength) {
            throw new IOException("Stream ended before reading file name: read=" + read + ", name length=" + fileNameLength);
        }
        this.mFileName = null;
        return fileNameLength;
    }

    private int readExtra(InputStream inputStream) throws IOException {
        int extraLength = this.getExtraLength();
        if (extraLength == 0) {
            return 0;
        }
        this.setExtraLength(extraLength);
        byte[] bytes = this.getBytesInternal();
        int offset = this.getOffsetExtra();
        int read = inputStream.read(bytes, offset, extraLength);
        if (read != extraLength) {
            throw new IOException("Stream ended before reading extra bytes: read=" + read + ", extra length=" + extraLength);
        }
        return extraLength;
    }

    int readComment(InputStream inputStream) throws IOException {
        return 0;
    }

    public int getVersionMadeBy() {
        return this.getShortUnsigned(4);
    }

    public void setVersionMadeBy(int value) {
        this.putShort(4, value);
    }

    public int getPlatform() {
        return this.getByteUnsigned(5);
    }

    public void setPlatform(int value) {
        this.getBytesInternal()[5] = (byte)value;
    }

    public GeneralPurposeFlag getGeneralPurposeFlag() {
        return this.generalPurposeFlag;
    }

    public int getMethod() {
        return this.getShortUnsigned(this.offsetGeneralPurpose + 2);
    }

    public void setMethod(int value) {
        this.putShort(this.offsetGeneralPurpose + 2, value);
    }

    public long getDosTime() {
        return this.getIntegerUnsigned(this.offsetGeneralPurpose + 4);
    }

    public void setDosTime(long value) {
        this.putInteger(this.offsetGeneralPurpose + 4, value);
    }

    public Date getDate() {
        return CommonHeader.dosToJavaDate(this.getDosTime());
    }

    public void setDate(Date date) {
        this.setDate(date == null ? 0L : date.getTime());
    }

    public void setDate(long date) {
        this.setDosTime(CommonHeader.javaToDosTime(date));
    }

    public long getCrc() {
        return this.getIntegerUnsigned(this.offsetGeneralPurpose + 8);
    }

    public void setCrc(long value) {
        this.putInteger(this.offsetGeneralPurpose + 8, value);
    }

    public long getCompressedSize() {
        return this.getIntegerUnsigned(this.offsetGeneralPurpose + 12);
    }

    public void setCompressedSize(long value) {
        this.putInteger(this.offsetGeneralPurpose + 12, value);
    }

    public long getSize() {
        return this.getIntegerUnsigned(this.offsetGeneralPurpose + 16);
    }

    public void setSize(long value) {
        this.putInteger(this.offsetGeneralPurpose + 16, value);
    }

    public int getFileNameLength() {
        return this.getShortUnsigned(this.offsetGeneralPurpose + 20);
    }

    private void setFileNameLength(int value) {
        int length = this.offsetFileName + value + this.getExtraLength() + this.getCommentLength();
        super.setBytesLength(length, false);
        this.putShort(this.offsetGeneralPurpose + 20, value);
    }

    public int getExtraLength() {
        return this.getShortUnsigned(this.offsetGeneralPurpose + 22);
    }

    public void setExtraLength(int value) {
        int length = this.offsetFileName + this.getFileNameLength() + value + this.getCommentLength();
        super.setBytesLength(length, false);
        this.putShort(this.offsetGeneralPurpose + 22, value);
    }

    public byte[] getExtra() {
        int length = this.getExtraLength();
        byte[] result = new byte[length];
        if (length == 0) {
            return result;
        }
        byte[] bytes = this.getBytesInternal();
        int offset = this.getOffsetExtra();
        System.arraycopy(bytes, offset, result, 0, length);
        return result;
    }

    public void setExtra(byte[] extra) {
        if (extra == null) {
            extra = new byte[]{};
        }
        int length = extra.length;
        this.setExtraLength(length);
        if (length == 0) {
            return;
        }
        this.putBytes(extra, 0, this.getOffsetExtra(), length);
    }

    public int getCommentLength() {
        return 0;
    }

    int getOffsetComment() {
        return this.offsetFileName + this.getFileNameLength() + this.getExtraLength();
    }

    private int getOffsetExtra() {
        return this.offsetFileName + this.getFileNameLength();
    }

    public String getFileName() {
        if (this.mFileName == null) {
            this.mFileName = this.decodeFileName();
        }
        return this.mFileName;
    }

    public void setFileName(String fileName) {
        if (fileName == null) {
            fileName = "";
        }
        byte[] nameBytes = fileName.getBytes(StandardCharsets.UTF_8);
        this.getGeneralPurposeFlag().setUtf8(true, false);
        int length = nameBytes.length;
        this.setFileNameLength(length);
        if (length == 0) {
            this.mFileName = fileName;
            return;
        }
        byte[] bytes = this.getBytesInternal();
        System.arraycopy(nameBytes, 0, bytes, this.offsetFileName, length);
        this.mFileName = fileName;
    }

    public boolean isUtf8() {
        return this.getGeneralPurposeFlag().getUtf8();
    }

    public boolean hasDataDescriptor() {
        return this.getGeneralPurposeFlag().hasDataDescriptor();
    }

    private String decodeFileName() {
        int offset;
        int length = this.getFileNameLength();
        byte[] bytes = this.getBytesInternal();
        int max = bytes.length - (offset = this.offsetFileName);
        if (max <= 0) {
            return "";
        }
        if (length > max) {
            length = max;
        }
        return new String(bytes, offset, length, StandardCharsets.UTF_8);
    }

    public String decodeComment() {
        int offset;
        int length = this.getExtraLength();
        byte[] bytes = this.getBytesInternal();
        int max = bytes.length - (offset = this.getOffsetExtra());
        if (max <= 0) {
            return "";
        }
        if (length > max) {
            length = max;
        }
        return new String(bytes, offset, length, StandardCharsets.UTF_8);
    }

    void onUtf8Changed(boolean oldValue) {
        String str = this.mFileName;
        if (str != null) {
            this.setFileName(str);
        }
    }

    public String toString() {
        if (this.countBytes() < this.getMinByteLength()) {
            return "Invalid";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('[').append(this.getFileOffset()).append("] ");
        String str = this.getFileName();
        boolean appendOnce = false;
        if (str.length() > 0) {
            builder.append("name=").append(str);
            appendOnce = true;
        }
        if (appendOnce) {
            builder.append(", ");
        }
        builder.append("SIG=").append((Object)this.getSignature());
        builder.append(", versionMadeBy=").append(HexUtil.toHex4((short)this.getVersionMadeBy()));
        builder.append(", platform=").append(HexUtil.toHex2((byte)this.getPlatform()));
        builder.append(", GP={").append(this.getGeneralPurposeFlag()).append("}");
        builder.append(", method=").append(this.getMethod());
        builder.append(", date=").append(this.getDate());
        builder.append(", crc=").append(HexUtil.toHex8(this.getCrc()));
        builder.append(", cSize=").append(this.getCompressedSize());
        builder.append(", size=").append(this.getSize());
        builder.append(", fileNameLength=").append(this.getFileNameLength());
        builder.append(", extraLength=").append(this.getExtraLength());
        return builder.toString();
    }

    private static Date dosToJavaDate(long dosTime) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, (int)(dosTime >> 25 & 0x7FL) + 1980);
        cal.set(2, (int)(dosTime >> 21 & 0xFL) - 1);
        cal.set(5, (int)(dosTime >> 16) & 0x1F);
        cal.set(11, (int)(dosTime >> 11) & 0x1F);
        cal.set(12, (int)(dosTime >> 5) & 0x3F);
        cal.set(13, (int)(dosTime << 1) & 0x3E);
        cal.set(14, 0);
        return cal.getTime();
    }

    private static long javaToDosTime(long javaTime) {
        int time;
        int date;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date(javaTime));
        int year = cal.get(1);
        if (year < 1980) {
            date = 33;
            time = 0;
        } else {
            date = cal.get(5);
            date = cal.get(2) + 1 << 5 | date;
            date = cal.get(1) - 1980 << 9 | date;
            time = cal.get(13) >> 1;
            time = cal.get(12) << 5 | time;
            time = cal.get(11) << 11 | time;
        }
        return (long)date << 16 | (long)time;
    }

    public static class GeneralPurposeFlag {
        private final CommonHeader localFileHeader;
        private final int offset;

        public GeneralPurposeFlag(CommonHeader commonHeader, int offset) {
            this.localFileHeader = commonHeader;
            this.offset = offset;
        }

        public boolean getEncryption() {
            return this.localFileHeader.getBit(this.offset, 0);
        }

        public void setEncryption(boolean flag) {
            this.localFileHeader.putBit(this.offset, 0, flag);
        }

        public boolean hasDataDescriptor() {
            return this.localFileHeader.getBit(this.offset, 3);
        }

        public void setHasDataDescriptor(boolean flag) {
            this.localFileHeader.putBit(this.offset, 3, flag);
        }

        public boolean getStrongEncryption() {
            return this.localFileHeader.getBit(this.offset, 6);
        }

        public void setStrongEncryption(boolean flag) {
            this.localFileHeader.putBit(this.offset, 6, flag);
        }

        public boolean getUtf8() {
            return this.localFileHeader.getBit(this.offset + 1, 3);
        }

        public void setUtf8(boolean flag) {
            this.setUtf8(flag, true);
        }

        private void setUtf8(boolean flag, boolean notify) {
            boolean oldUtf8 = this.getUtf8();
            if (oldUtf8 == flag) {
                return;
            }
            this.localFileHeader.putBit(this.offset + 1, 3, flag);
            if (notify) {
                this.localFileHeader.onUtf8Changed(oldUtf8);
            }
        }

        public int getValue() {
            return this.localFileHeader.getShortUnsigned(this.offset);
        }

        public void setValue(int value) {
            if (value == this.getValue()) {
                return;
            }
            boolean oldUtf8 = this.getUtf8();
            this.localFileHeader.putShort(this.offset, value);
            if (oldUtf8 != this.getUtf8()) {
                this.localFileHeader.onUtf8Changed(oldUtf8);
            }
        }

        public void initDefault() {
            this.setUtf8(false, false);
        }

        public String toString() {
            return "Enc=" + this.getEncryption() + ", Descriptor=" + this.hasDataDescriptor() + ", StrongEnc=" + this.getStrongEncryption() + ", UTF8=" + this.getUtf8();
        }
    }
}

