/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive2.block;

import com.reandroid.archive2.block.LengthPrefixedBytes;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class CertificateBlock
extends LengthPrefixedBytes {
    private static CertificateFactory sCertFactory = null;

    public CertificateBlock() {
        super(false);
    }

    public X509Certificate getCertificate() {
        return CertificateBlock.generateCertificate(this.getByteArray().toArray());
    }

    public static X509Certificate generateCertificate(byte[] encodedForm) {
        CertificateFactory factory = CertificateBlock.getCertFactory();
        if (factory == null) {
            return null;
        }
        try {
            return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(encodedForm));
        }
        catch (CertificateException ignored) {
            return null;
        }
    }

    private static CertificateFactory getCertFactory() {
        if (sCertFactory == null) {
            try {
                sCertFactory = CertificateFactory.getInstance("X.509");
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return sCertFactory;
    }
}

