/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive2;

import com.reandroid.archive2.block.CentralEntryHeader;
import com.reandroid.archive2.block.LocalFileHeader;
import com.reandroid.arsc.util.HexUtil;
import java.util.zip.ZipEntry;

public class ArchiveEntry
extends ZipEntry {
    private final CentralEntryHeader centralEntryHeader;
    private final LocalFileHeader localFileHeader;

    public ArchiveEntry(LocalFileHeader lfh, CentralEntryHeader ceh) {
        super(lfh.getFileName());
        this.localFileHeader = lfh;
        this.centralEntryHeader = ceh;
    }

    public ArchiveEntry(String name) {
        this(new LocalFileHeader(name), new CentralEntryHeader(name));
    }

    public ArchiveEntry() {
        this(new LocalFileHeader(), new CentralEntryHeader());
    }

    public long getDataSize() {
        if (this.getMethod() == 0) {
            return this.getSize();
        }
        return this.getCompressedSize();
    }

    @Override
    public int getMethod() {
        return this.localFileHeader.getMethod();
    }

    @Override
    public void setMethod(int method) {
        this.localFileHeader.setMethod(method);
        this.centralEntryHeader.setMethod(method);
    }

    @Override
    public long getSize() {
        return this.centralEntryHeader.getSize();
    }

    @Override
    public void setSize(long size) {
        this.centralEntryHeader.setSize(size);
        this.localFileHeader.setSize(size);
    }

    @Override
    public long getCrc() {
        return this.centralEntryHeader.getCrc();
    }

    @Override
    public void setCrc(long crc) {
        this.centralEntryHeader.setCrc(crc);
        this.localFileHeader.setCrc(crc);
    }

    @Override
    public long getCompressedSize() {
        return this.centralEntryHeader.getCompressedSize();
    }

    @Override
    public void setCompressedSize(long csize) {
        this.centralEntryHeader.setCompressedSize(csize);
        this.localFileHeader.setCompressedSize(csize);
    }

    public long getFileOffset() {
        return this.localFileHeader.getFileOffset();
    }

    @Override
    public String getName() {
        return this.centralEntryHeader.getFileName();
    }

    public void setName(String name) {
        this.centralEntryHeader.setFileName(name);
        this.localFileHeader.setFileName(name);
    }

    @Override
    public String getComment() {
        return this.centralEntryHeader.getComment();
    }

    @Override
    public void setComment(String name) {
        this.centralEntryHeader.setComment(name);
    }

    @Override
    public boolean isDirectory() {
        return this.getName().endsWith("/");
    }

    public CentralEntryHeader getCentralEntryHeader() {
        return this.centralEntryHeader;
    }

    public LocalFileHeader getLocalFileHeader() {
        return this.localFileHeader;
    }

    public boolean matches(CentralEntryHeader centralEntryHeader) {
        if (centralEntryHeader == null) {
            return false;
        }
        return false;
    }

    @Override
    public String toString() {
        return "[" + this.getFileOffset() + "] " + this.getName() + this.getComment() + HexUtil.toHex(" 0x", this.getCrc(), 8);
    }
}

