/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive2;

import com.reandroid.archive.APKArchive;
import com.reandroid.archive.InputSource;
import com.reandroid.archive2.ArchiveEntry;
import com.reandroid.archive2.block.ApkSignatureBlock;
import com.reandroid.archive2.block.CentralEntryHeader;
import com.reandroid.archive2.block.EndRecord;
import com.reandroid.archive2.block.LocalFileHeader;
import com.reandroid.archive2.io.ArchiveEntrySource;
import com.reandroid.archive2.io.ArchiveUtil;
import com.reandroid.archive2.io.ZipFileInput;
import com.reandroid.archive2.io.ZipInput;
import com.reandroid.archive2.model.LocalFileDirectory;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class Archive
implements Closeable {
    private final ZipInput zipInput;
    private final List<ArchiveEntry> entryList;
    private final EndRecord endRecord;
    private final ApkSignatureBlock apkSignatureBlock;

    public Archive(ZipInput zipInput) throws IOException {
        this.zipInput = zipInput;
        LocalFileDirectory lfd = new LocalFileDirectory();
        lfd.visit(zipInput);
        List<LocalFileHeader> localFileHeaderList = lfd.getHeaderList();
        List<CentralEntryHeader> centralEntryHeaderList = lfd.getCentralFileDirectory().getHeaderList();
        ArrayList<ArchiveEntry> entryList = new ArrayList<ArchiveEntry>(localFileHeaderList.size());
        for (int i = 0; i < localFileHeaderList.size(); ++i) {
            CentralEntryHeader ceh;
            LocalFileHeader lfh = localFileHeaderList.get(i);
            ArchiveEntry archiveEntry = new ArchiveEntry(lfh, ceh = centralEntryHeaderList.get(i));
            if (archiveEntry.isDirectory()) continue;
            entryList.add(archiveEntry);
        }
        this.entryList = entryList;
        this.endRecord = lfd.getCentralFileDirectory().getEndRecord();
        this.apkSignatureBlock = lfd.getApkSigBlock();
    }

    public Archive(File file) throws IOException {
        this(new ZipFileInput(file));
    }

    public APKArchive createAPKArchive() {
        return new APKArchive(this.mapEntrySource());
    }

    public Map<String, InputSource> mapEntrySource() {
        LinkedHashMap<String, InputSource> map = new LinkedHashMap<String, InputSource>();
        ZipInput zipInput = this.zipInput;
        List<ArchiveEntry> entryList = this.entryList;
        for (int i = 0; i < entryList.size(); ++i) {
            ArchiveEntry entry = entryList.get(i);
            if (entry.isDirectory()) continue;
            ArchiveEntrySource entrySource = new ArchiveEntrySource(zipInput, entry);
            map.put(entrySource.getAlias(), entrySource);
        }
        return map;
    }

    public InputStream openRawInputStream(ArchiveEntry archiveEntry) throws IOException {
        return this.zipInput.getInputStream(archiveEntry.getFileOffset(), archiveEntry.getDataSize());
    }

    public InputStream openInputStream(ArchiveEntry archiveEntry) throws IOException {
        InputStream rawInputStream = this.openRawInputStream(archiveEntry);
        if (archiveEntry.getMethod() == 0) {
            return rawInputStream;
        }
        return new InflaterInputStream(rawInputStream, new Inflater(true), 1024000);
    }

    public List<ArchiveEntry> getEntryList() {
        return this.entryList;
    }

    public ApkSignatureBlock getApkSignatureBlock() {
        return this.apkSignatureBlock;
    }

    public EndRecord getEndRecord() {
        return this.endRecord;
    }

    public void extractAll(File dir) throws IOException {
        for (ArchiveEntry archiveEntry : this.getEntryList()) {
            if (archiveEntry.isDirectory()) continue;
            this.extract(this.toFile(dir, archiveEntry), archiveEntry);
        }
    }

    public void extract(File file, ArchiveEntry archiveEntry) throws IOException {
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        if (archiveEntry.getMethod() != 0) {
            this.extractCompressed(file, archiveEntry);
        } else {
            this.extractStored(file, archiveEntry);
        }
    }

    private void extractStored(File file, ArchiveEntry archiveEntry) throws IOException {
        if (file.isFile()) {
            file.delete();
        }
        file.createNewFile();
        StandardOpenOption openOption = StandardOpenOption.WRITE;
        FileChannel outputChannel = FileChannel.open(file.toPath(), openOption);
        FileChannel fileChannel = this.zipInput.getFileChannel();
        fileChannel.position(archiveEntry.getFileOffset());
        outputChannel.transferFrom(fileChannel, 0L, archiveEntry.getDataSize());
        outputChannel.close();
    }

    private void extractCompressed(File file, ArchiveEntry archiveEntry) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(file);
        ArchiveUtil.writeAll(this.openInputStream(archiveEntry), outputStream);
        outputStream.close();
    }

    private File toFile(File dir, ArchiveEntry archiveEntry) {
        String name = archiveEntry.getName().replace('/', File.separatorChar);
        return new File(dir, name);
    }

    @Override
    public void close() throws IOException {
        this.zipInput.close();
    }
}

