/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive;

import com.reandroid.archive.InputSource;
import com.reandroid.archive.WriteInterceptor;
import com.reandroid.archive.WriteProgress;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipSerializer {
    private final List<InputSource> mSourceList;
    private WriteProgress writeProgress;
    private WriteInterceptor writeInterceptor;

    public ZipSerializer(List<InputSource> sourceList) {
        this.mSourceList = sourceList;
    }

    public void setWriteInterceptor(WriteInterceptor writeInterceptor) {
        this.writeInterceptor = writeInterceptor;
    }

    public void setWriteProgress(WriteProgress writeProgress) {
        this.writeProgress = writeProgress;
    }

    public long writeZip(File outZip) throws IOException {
        File dir = outZip.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        File tmp = this.toTmpFile(outZip);
        FileOutputStream fileOutputStream = new FileOutputStream(tmp);
        long length = this.writeZip(fileOutputStream);
        fileOutputStream.close();
        outZip.delete();
        tmp.renameTo(outZip);
        return length;
    }

    private File toTmpFile(File file) {
        File dir = file.getParentFile();
        String name = file.getName() + ".tmp";
        return new File(dir, name);
    }

    public long writeZip(OutputStream outputStream) throws IOException {
        long length = 0L;
        WriteProgress progress = this.writeProgress;
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        for (InputSource inputSource : this.mSourceList) {
            if ((inputSource = this.interceptWrite(inputSource)) == null) continue;
            if (progress != null) {
                progress.onCompressFile(inputSource.getAlias(), inputSource.getMethod(), length);
            }
            length += this.write(zipOutputStream, inputSource);
            zipOutputStream.closeEntry();
            inputSource.disposeInputSource();
        }
        zipOutputStream.close();
        return length;
    }

    private long write(ZipOutputStream zipOutputStream, InputSource inputSource) throws IOException {
        ZipEntry zipEntry = this.createZipEntry(inputSource);
        zipOutputStream.putNextEntry(zipEntry);
        return inputSource.write(zipOutputStream);
    }

    private ZipEntry createZipEntry(InputSource inputSource) throws IOException {
        String name = inputSource.getAlias();
        ZipEntry zipEntry = new ZipEntry(name);
        int method = inputSource.getMethod();
        zipEntry.setMethod(method);
        if (method == 0) {
            zipEntry.setCrc(inputSource.getCrc());
            zipEntry.setSize(inputSource.getLength());
        }
        return zipEntry;
    }

    private InputSource interceptWrite(InputSource inputSource) {
        WriteInterceptor interceptor = this.writeInterceptor;
        if (interceptor != null) {
            return interceptor.onWriteArchive(inputSource);
        }
        return inputSource;
    }
}

