/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive;

import com.reandroid.archive.InputSource;
import com.reandroid.archive.InputSourceUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;

public class ZipArchive {
    private final Map<String, InputSource> mEntriesMap;

    public ZipArchive(Map<String, InputSource> entriesMap) {
        this.mEntriesMap = entriesMap;
    }

    public ZipArchive() {
        this(new LinkedHashMap<String, InputSource>());
    }

    public int size() {
        return this.mEntriesMap.size();
    }

    public void extract(File outDir) throws IOException {
        for (InputSource inputSource : this.listInputSources()) {
            this.extract(outDir, inputSource);
        }
    }

    private void extract(File outDir, InputSource inputSource) throws IOException {
        File file = this.toOutFile(outDir, inputSource.getAlias());
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        inputSource.write(outputStream);
        outputStream.close();
        inputSource.disposeInputSource();
    }

    private File toOutFile(File outDir, String path) {
        path = path.replace('/', File.separatorChar);
        return new File(outDir, path);
    }

    public void removeDir(String dirName) {
        if (!dirName.endsWith("/")) {
            dirName = dirName + "/";
        }
        for (InputSource inputSource : this.listInputSources()) {
            if (!inputSource.getName().startsWith(dirName)) continue;
            this.remove(inputSource.getName());
        }
    }

    public void removeAll(Pattern patternAlias) {
        for (InputSource inputSource : this.listInputSources()) {
            Matcher matcher = patternAlias.matcher(inputSource.getAlias());
            if (!matcher.matches()) continue;
            this.mEntriesMap.remove(inputSource.getName());
        }
    }

    public void clear() {
        this.mEntriesMap.clear();
    }

    public int entriesCount() {
        return this.mEntriesMap.size();
    }

    public InputSource remove(String name) {
        InputSource inputSource = this.mEntriesMap.remove(name);
        if (inputSource == null) {
            return null;
        }
        return inputSource;
    }

    public void addArchive(File archiveFile) throws IOException {
        ZipFile zipFile = new ZipFile(archiveFile);
        this.add(zipFile);
    }

    public void addDirectory(File dir) {
        this.addAll(InputSourceUtil.listDirectory(dir));
    }

    public void add(ZipFile zipFile) {
        List<InputSource> sourceList = InputSourceUtil.listZipFileSources(zipFile);
        this.addAll(sourceList);
    }

    public void set(Collection<? extends InputSource> inputSourceList) {
        this.clear();
        this.addAll(inputSourceList);
    }

    public void addAll(Collection<? extends InputSource> inputSourceList) {
        for (InputSource inputSource : inputSourceList) {
            this.add(inputSource);
        }
    }

    public void add(InputSource inputSource) {
        if (inputSource == null) {
            return;
        }
        String name = inputSource.getName();
        Map<String, InputSource> map = this.mEntriesMap;
        map.remove(name);
        map.put(name, inputSource);
    }

    public List<InputSource> listInputSources() {
        return new ArrayList<InputSource>(this.mEntriesMap.values());
    }

    public InputSource getInputSource(String name) {
        return this.mEntriesMap.get(name);
    }
}

