/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipAlign {
    private static final int ZIP_ENTRY_HEADER_LEN = 30;
    private static final int ZIP_ENTRY_VERSION = 20;
    private static final int ZIP_ENTRY_USES_DATA_DESCR = 8;
    private static final int ZIP_ENTRY_DATA_DESCRIPTOR_LEN = 16;
    private static final int ALIGNMENT_4 = 4;
    private static final int ALIGNMENT_PAGE = 4096;
    private File mInputFile;
    private int mAlignment;
    private File mOutputFile;
    private ZipFile mZipFile;
    private RandomAccessFile mRafInput;
    private FilterOutputStreamEx mOutputStream;
    private final List<XEntry> mXEntries = new ArrayList<XEntry>();
    private long mInputFileOffset = 0L;
    private int mTotalPadding = 0;

    public void zipAlign(File input, File output) throws IOException {
        this.zipAlign(input, output, 4);
    }

    public void zipAlign(File input, File output, int alignment) throws IOException {
        this.mInputFile = input;
        this.mAlignment = alignment;
        this.mOutputFile = output;
        this.openFiles();
        this.copyAllEntries();
        this.buildCentralDirectory();
        this.closeFiles();
    }

    private void openFiles() throws IOException {
        this.mZipFile = new ZipFile(this.mInputFile);
        this.mRafInput = new RandomAccessFile(this.mInputFile, "r");
        this.mOutputStream = new FilterOutputStreamEx(new BufferedOutputStream(new FileOutputStream(this.mOutputFile), 32768));
    }

    private void copyAllEntries() throws IOException {
        int entryCount = this.mZipFile.size();
        if (entryCount == 0) {
            return;
        }
        Enumeration<? extends ZipEntry> entries = this.mZipFile.entries();
        while (entries.hasMoreElements()) {
            long sizeToCopy;
            int time;
            int modDate;
            int padding;
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            int flags = entry.getMethod() == 0 ? 0 : 8;
            flags |= 0x800;
            long outputEntryHeaderOffset = this.mOutputStream.totalWritten;
            int inputEntryHeaderSize = 30 + (entry.getExtra() != null ? entry.getExtra().length : 0) + name.getBytes(StandardCharsets.UTF_8).length;
            long inputEntryDataOffset = this.mInputFileOffset + (long)inputEntryHeaderSize;
            if (entry.getMethod() != 0) {
                padding = 0;
            } else {
                int alignment = this.mAlignment;
                if (name.startsWith("lib/") && name.endsWith(".so")) {
                    alignment = 4096;
                }
                long newOffset = inputEntryDataOffset + (long)this.mTotalPadding;
                padding = (int)(((long)alignment - newOffset % (long)alignment) % (long)alignment);
                this.mTotalPadding += padding;
            }
            XEntry xentry = new XEntry(entry, outputEntryHeaderOffset, flags, padding);
            this.mXEntries.add(xentry);
            byte[] extra = entry.getExtra();
            if (extra == null) {
                extra = new byte[padding];
            } else {
                byte[] newExtra = new byte[extra.length + padding];
                System.arraycopy(extra, 0, newExtra, 0, extra.length);
                Arrays.fill(newExtra, extra.length, newExtra.length, (byte)0);
                extra = newExtra;
            }
            entry.setExtra(extra);
            this.mOutputStream.writeInt(67324752L);
            this.mOutputStream.writeShort(20);
            this.mOutputStream.writeShort(flags);
            this.mOutputStream.writeShort(entry.getMethod());
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(new Date(entry.getTime()));
            int year = cal.get(1);
            if (year < 1980) {
                modDate = 33;
                time = 0;
            } else {
                modDate = cal.get(5);
                modDate = cal.get(2) + 1 << 5 | modDate;
                modDate = cal.get(1) - 1980 << 9 | modDate;
                time = cal.get(13) >> 1;
                time = cal.get(12) << 5 | time;
                time = cal.get(11) << 11 | time;
            }
            this.mOutputStream.writeShort(time);
            this.mOutputStream.writeShort(modDate);
            this.mOutputStream.writeInt(entry.getCrc());
            this.mOutputStream.writeInt(entry.getCompressedSize());
            this.mOutputStream.writeInt(entry.getSize());
            this.mOutputStream.writeShort(entry.getName().getBytes(StandardCharsets.UTF_8).length);
            this.mOutputStream.writeShort(entry.getExtra().length);
            this.mOutputStream.write(entry.getName().getBytes(StandardCharsets.UTF_8));
            this.mOutputStream.write(entry.getExtra(), 0, entry.getExtra().length);
            this.mInputFileOffset += (long)inputEntryHeaderSize;
            if ((flags & 8) != 0) {
                sizeToCopy = (entry.isDirectory() ? 0L : entry.getCompressedSize()) + 16L;
            } else {
                long l = sizeToCopy = entry.isDirectory() ? 0L : entry.getCompressedSize();
            }
            if (sizeToCopy > 0L) {
                int read;
                this.mRafInput.seek(this.mInputFileOffset);
                byte[] buf = new byte[32768];
                for (long totalSizeCopied = 0L; totalSizeCopied < sizeToCopy && (read = this.mRafInput.read(buf, 0, (int)Math.min(32768L, sizeToCopy - totalSizeCopied))) > 0; totalSizeCopied += (long)read) {
                    this.mOutputStream.write(buf, 0, read);
                }
            }
            this.mInputFileOffset += sizeToCopy;
        }
    }

    private void buildCentralDirectory() throws IOException {
        long centralDirOffset = this.mOutputStream.totalWritten;
        int entryCount = this.mXEntries.size();
        for (int i = 0; i < entryCount; ++i) {
            byte[] commentBytes;
            int time;
            int modDate;
            XEntry xentry = this.mXEntries.get(i);
            ZipEntry entry = xentry.entry;
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(new Date(entry.getTime()));
            int year = cal.get(1);
            if (year < 1980) {
                modDate = 33;
                time = 0;
            } else {
                modDate = cal.get(5);
                modDate = cal.get(2) + 1 << 5 | modDate;
                modDate = cal.get(1) - 1980 << 9 | modDate;
                time = cal.get(13) >> 1;
                time = cal.get(12) << 5 | time;
                time = cal.get(11) << 11 | time;
            }
            this.mOutputStream.writeInt(33639248L);
            this.mOutputStream.writeShort(20);
            this.mOutputStream.writeShort(20);
            this.mOutputStream.writeShort(xentry.flags);
            this.mOutputStream.writeShort(entry.getMethod());
            this.mOutputStream.writeShort(time);
            this.mOutputStream.writeShort(modDate);
            this.mOutputStream.writeInt(entry.getCrc());
            this.mOutputStream.writeInt(entry.getCompressedSize());
            this.mOutputStream.writeInt(entry.getSize());
            byte[] nameBytes = entry.getName().getBytes(StandardCharsets.UTF_8);
            this.mOutputStream.writeShort(nameBytes.length);
            this.mOutputStream.writeShort(entry.getExtra() != null ? entry.getExtra().length - xentry.padding : 0);
            if (entry.getComment() != null) {
                commentBytes = entry.getComment().getBytes(StandardCharsets.UTF_8);
                this.mOutputStream.writeShort(Math.min(commentBytes.length, 65535));
            } else {
                commentBytes = null;
                this.mOutputStream.writeShort(0);
            }
            this.mOutputStream.writeShort(0);
            this.mOutputStream.writeShort(0);
            this.mOutputStream.writeInt(0L);
            this.mOutputStream.writeInt(xentry.headerOffset);
            this.mOutputStream.write(nameBytes);
            if (entry.getExtra() != null) {
                this.mOutputStream.write(entry.getExtra(), 0, entry.getExtra().length - xentry.padding);
            }
            if (commentBytes == null) continue;
            this.mOutputStream.write(commentBytes, 0, Math.min(commentBytes.length, 65535));
        }
        long centralDirSize = this.mOutputStream.totalWritten - centralDirOffset;
        this.mOutputStream.writeInt(101010256L);
        this.mOutputStream.writeShort(0);
        this.mOutputStream.writeShort(0);
        this.mOutputStream.writeShort(entryCount);
        this.mOutputStream.writeShort(entryCount);
        this.mOutputStream.writeInt(centralDirSize);
        this.mOutputStream.writeInt(centralDirOffset);
        this.mOutputStream.writeShort(0);
        this.mOutputStream.flush();
    }

    private void closeFiles() throws IOException {
        try {
            this.mZipFile.close();
        }
        finally {
            try {
                this.mRafInput.close();
            }
            finally {
                this.mOutputStream.close();
            }
        }
    }

    public static void align4(File inFile) throws IOException {
        ZipAlign.align(inFile, 4);
    }

    public static void align4(File inFile, File outFile) throws IOException {
        ZipAlign.align(inFile, outFile, 4);
    }

    public static void align(File inFile, int alignment) throws IOException {
        File tmp = ZipAlign.toTmpFile(inFile);
        tmp.delete();
        ZipAlign.align(inFile, tmp, alignment);
        inFile.delete();
        tmp.renameTo(inFile);
    }

    public static void align(File inFile, File outFile, int alignment) throws IOException {
        ZipAlign zipAlign = new ZipAlign();
        File dir = outFile.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        zipAlign.zipAlign(inFile, outFile, alignment);
    }

    private static File toTmpFile(File file) {
        String name = file.getName() + ".align.tmp";
        File dir = file.getParentFile();
        if (dir == null) {
            return new File(name);
        }
        return new File(dir, name);
    }

    private static class FilterOutputStreamEx
    extends FilterOutputStream {
        private long totalWritten = 0L;

        public FilterOutputStreamEx(OutputStream out) {
            super(out);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b);
            this.totalWritten += (long)b.length;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.totalWritten += (long)len;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.totalWritten;
        }

        @Override
        public void close() throws IOException {
            super.close();
        }

        public void writeInt(long v) throws IOException {
            this.write((int)(v & 0xFFL));
            this.write((int)(v >>> 8 & 0xFFL));
            this.write((int)(v >>> 16 & 0xFFL));
            this.write((int)(v >>> 24 & 0xFFL));
        }

        public void writeShort(int v) throws IOException {
            this.write(v & 0xFF);
            this.write(v >>> 8 & 0xFF);
        }
    }

    private static class XEntry {
        public final ZipEntry entry;
        public final long headerOffset;
        public final int flags;
        public final int padding;

        public XEntry(ZipEntry entry, long headerOffset, int flags, int padding) {
            this.entry = entry;
            this.headerOffset = headerOffset;
            this.flags = flags;
            this.padding = padding;
        }
    }
}

