/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive;

import com.reandroid.archive.ByteInputSource;
import com.reandroid.archive.FileInputSource;
import com.reandroid.archive.InputSource;
import com.reandroid.archive.ZipEntrySource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class InputSourceUtil {
    public static String toRelative(File rootDir, File file) {
        int len = rootDir.getAbsolutePath().length();
        String path = file.getAbsolutePath();
        path = path.substring(len);
        path = InputSourceUtil.sanitize(path);
        return path;
    }

    public static String sanitize(String path) {
        path = path.replace('\\', '/');
        while (path.startsWith("./")) {
            path = path.substring(2);
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    public static Map<String, InputSource> mapZipFileSources(ZipFile zipFile) {
        LinkedHashMap<String, InputSource> results = new LinkedHashMap<String, InputSource>();
        Enumeration<? extends ZipEntry> entriesEnum = zipFile.entries();
        int i = 0;
        while (entriesEnum.hasMoreElements()) {
            ZipEntry zipEntry = entriesEnum.nextElement();
            if (zipEntry.isDirectory()) continue;
            ZipEntrySource source = new ZipEntrySource(zipFile, zipEntry);
            source.setSort(i);
            source.setMethod(zipEntry.getMethod());
            results.put(source.getName(), source);
            ++i;
        }
        return results;
    }

    public static Map<String, ByteInputSource> mapInputStreamAsBuffer(InputStream inputStream) throws IOException {
        ZipEntry zipEntry;
        LinkedHashMap<String, ByteInputSource> results = new LinkedHashMap<String, ByteInputSource>();
        ZipInputStream zin = new ZipInputStream(inputStream);
        int i = 0;
        while ((zipEntry = zin.getNextEntry()) != null) {
            if (zipEntry.isDirectory()) continue;
            byte[] buffer = InputSourceUtil.loadBuffer(zin);
            String name = InputSourceUtil.sanitize(zipEntry.getName());
            ByteInputSource source = new ByteInputSource(buffer, name);
            source.setSort(i);
            source.setMethod(zipEntry.getMethod());
            results.put(name, source);
            ++i;
        }
        zin.close();
        return results;
    }

    private static byte[] loadBuffer(InputStream in) throws IOException {
        int len;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buff = new byte[40960];
        while ((len = in.read(buff)) > 0) {
            outputStream.write(buff, 0, len);
        }
        outputStream.close();
        return outputStream.toByteArray();
    }

    public static List<InputSource> listZipFileSources(ZipFile zipFile) {
        ArrayList<InputSource> results = new ArrayList<InputSource>();
        Enumeration<? extends ZipEntry> entriesEnum = zipFile.entries();
        int i = 0;
        while (entriesEnum.hasMoreElements()) {
            ZipEntry zipEntry = entriesEnum.nextElement();
            if (zipEntry.isDirectory()) continue;
            ZipEntrySource source = new ZipEntrySource(zipFile, zipEntry);
            source.setSort(i);
            results.add(source);
        }
        return results;
    }

    public static List<InputSource> listDirectory(File dir) {
        ArrayList<InputSource> results = new ArrayList<InputSource>();
        InputSourceUtil.recursiveDirectory(results, dir, dir);
        return results;
    }

    private static void recursiveDirectory(List<InputSource> results, File rootDir, File dir) {
        if (dir.isFile()) {
            String name = rootDir.equals(dir) ? dir.getName() : InputSourceUtil.toRelative(rootDir, dir);
            results.add(new FileInputSource(dir, name));
            return;
        }
        File[] childFiles = dir.listFiles();
        if (childFiles == null) {
            return;
        }
        for (File file : childFiles) {
            InputSourceUtil.recursiveDirectory(results, rootDir, file);
        }
    }

    public static List<String> sortString(List<String> stringList) {
        Comparator<String> cmp = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareTo(s2);
            }
        };
        stringList.sort(cmp);
        return stringList;
    }

    public static List<InputSource> sort(List<InputSource> sourceList) {
        Comparator<InputSource> cmp = new Comparator<InputSource>(){

            @Override
            public int compare(InputSource in1, InputSource in2) {
                return Integer.compare(in1.getSort(), in2.getSort());
            }
        };
        sourceList.sort(cmp);
        return sourceList;
    }
}

