/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive;

import com.reandroid.archive.InputSourceUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;

public abstract class InputSource {
    private final String name;
    private String alias;
    private long mCrc;
    private long mLength;
    private int method = 8;
    private int sort;

    public InputSource(String name) {
        this.name = name;
        this.alias = InputSourceUtil.sanitize(name);
    }

    public byte[] getBytes(int length) throws IOException {
        InputStream inputStream = this.openStream();
        byte[] bytes = new byte[length];
        inputStream.read(bytes, 0, length);
        this.close(inputStream);
        return bytes;
    }

    public void disposeInputSource() {
    }

    public int getSort() {
        return this.sort;
    }

    public void setSort(int sort) {
        this.sort = sort;
    }

    public int getMethod() {
        return this.method;
    }

    public void setMethod(int method) {
        this.method = method;
    }

    public String getAlias() {
        if (this.alias != null) {
            return this.alias;
        }
        return this.getName();
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void close(InputStream inputStream) throws IOException {
        inputStream.close();
    }

    public File toFile(File dir) {
        String path = this.getAlias();
        path = path.replace('/', File.separatorChar);
        return new File(dir, path);
    }

    public void write(File file) throws IOException {
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        this.write(outputStream);
        outputStream.close();
    }

    public long write(OutputStream outputStream) throws IOException {
        return this.write(outputStream, this.openStream());
    }

    private long write(OutputStream outputStream, InputStream inputStream) throws IOException {
        int len;
        long result = 0L;
        byte[] buffer = new byte[1024000];
        while ((len = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, len);
            result += (long)len;
        }
        this.close(inputStream);
        return result;
    }

    public String getName() {
        return this.name;
    }

    public long getLength() throws IOException {
        if (this.mLength == 0L) {
            this.calculateCrc();
        }
        return this.mLength;
    }

    public long getCrc() throws IOException {
        if (this.mCrc == 0L) {
            this.calculateCrc();
        }
        return this.mCrc;
    }

    public abstract InputStream openStream() throws IOException;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InputSource)) {
            return false;
        }
        InputSource that = (InputSource)o;
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.getName();
    }

    private void calculateCrc() throws IOException {
        int bytesRead;
        InputStream inputStream = this.openStream();
        long length = 0L;
        CRC32 crc = new CRC32();
        byte[] buffer = new byte[65536];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            crc.update(buffer, 0, bytesRead);
            length += (long)bytesRead;
        }
        this.close(inputStream);
        this.mCrc = crc.getValue();
        this.mLength = length;
    }
}

