/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive;

import com.reandroid.archive.InputSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteInputSource
extends InputSource {
    private byte[] inBytes;

    public ByteInputSource(byte[] inBytes, String name) {
        super(name);
        this.inBytes = inBytes;
    }

    @Override
    public long write(OutputStream outputStream) throws IOException {
        byte[] bts = this.getBytes();
        outputStream.write(bts);
        return bts.length;
    }

    @Override
    public InputStream openStream() throws IOException {
        return new ByteArrayInputStream(this.getBytes());
    }

    public byte[] getBytes() {
        return this.inBytes;
    }

    @Override
    public void disposeInputSource() {
        this.inBytes = new byte[0];
    }
}

