/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive;

import com.reandroid.archive.InputSource;
import com.reandroid.archive.InputSourceUtil;
import com.reandroid.archive.ZipArchive;
import com.reandroid.archive.ZipSerializer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipFile;

public class APKArchive
extends ZipArchive {
    public APKArchive(Map<String, InputSource> entriesMap) {
        super(entriesMap);
    }

    public APKArchive() {
    }

    public void refresh() {
        List<InputSource> inputSourceList = this.listInputSources();
        APKArchive.applySort(inputSourceList);
        this.set(inputSourceList);
    }

    public void autoSortApkFiles() {
        List<InputSource> inputSourceList = this.listInputSources();
        APKArchive.autoSortApkFiles(inputSourceList);
        this.set(inputSourceList);
    }

    public long writeApk(File outApk) throws IOException {
        ZipSerializer serializer = new ZipSerializer(this.listInputSources());
        return serializer.writeZip(outApk);
    }

    public long writeApk(OutputStream outputStream) throws IOException {
        ZipSerializer serializer = new ZipSerializer(this.listInputSources());
        return serializer.writeZip(outputStream);
    }

    public static APKArchive loadZippedApk(File zipFile) throws IOException {
        return APKArchive.loadZippedApk(new ZipFile(zipFile));
    }

    public static APKArchive loadZippedApk(ZipFile zipFile) {
        Map<String, InputSource> entriesMap = InputSourceUtil.mapZipFileSources(zipFile);
        return new APKArchive(entriesMap);
    }

    public static void repackApk(File apkFile) throws IOException {
        APKArchive apkArchive = APKArchive.loadZippedApk(apkFile);
        apkArchive.writeApk(apkFile);
    }

    public static void applySort(List<InputSource> sourceList) {
        Comparator<InputSource> cmp = new Comparator<InputSource>(){

            @Override
            public int compare(InputSource in1, InputSource in2) {
                return Integer.compare(in1.getSort(), in2.getSort());
            }
        };
        sourceList.sort(cmp);
    }

    public static void autoSortApkFiles(List<InputSource> sourceList) {
        Comparator<InputSource> cmp = new Comparator<InputSource>(){

            @Override
            public int compare(InputSource in1, InputSource in2) {
                return APKArchive.getSortName(in1).compareTo(APKArchive.getSortName(in2));
            }
        };
        sourceList.sort(cmp);
        int i = 0;
        for (InputSource inputSource : sourceList) {
            inputSource.setSort(i);
            ++i;
        }
    }

    private static String getSortName(InputSource inputSource) {
        String name = inputSource.getAlias();
        StringBuilder builder = new StringBuilder();
        if (name.equals("AndroidManifest.xml")) {
            builder.append("0 ");
        } else if (name.startsWith("META-INF/")) {
            builder.append("1 ");
        } else if (name.equals("resources.arsc")) {
            builder.append("2 ");
        } else if (name.startsWith("classes")) {
            builder.append("3 ");
        } else if (name.startsWith("res/")) {
            builder.append("4 ");
        } else if (name.startsWith("lib/")) {
            builder.append("5 ");
        } else if (name.startsWith("assets/")) {
            builder.append("6 ");
        } else {
            builder.append("7 ");
        }
        builder.append(name.toLowerCase());
        return builder.toString();
    }
}

