/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.refactor;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.AndroidFrameworks;
import com.reandroid.apk.ApkModule;
import com.reandroid.apk.FrameworkApk;
import com.reandroid.apk.ResFile;
import com.reandroid.apkeditor.refactor.TypeNameMap;
import com.reandroid.arsc.array.ResValueMapArray;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.xml.AndroidManifestBlock;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.group.EntryGroup;
import com.reandroid.arsc.item.TypeString;
import com.reandroid.arsc.util.FrameworkTable;
import com.reandroid.arsc.value.AttributeDataFormat;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResTableMapEntry;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.arsc.value.array.ArrayBag;
import com.reandroid.arsc.value.attribute.AttributeBag;
import com.reandroid.arsc.value.plurals.PluralsBag;
import com.reandroid.xml.XMLDocument;
import com.reandroid.xml.XMLElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TypeNameRefactor {
    private final ApkModule apkModule;
    private Map<Integer, TypeString> mTypeStrings;
    private APKLogger apkLogger;
    private final TypeNameMap refactoredTypeMap;

    public TypeNameRefactor(ApkModule apkModule) {
        this.apkModule = apkModule;
        this.refactoredTypeMap = new TypeNameMap();
    }

    public void setApkLogger(APKLogger apkLogger) {
        this.apkLogger = apkLogger;
    }

    public void refactor() throws IOException {
        this.logMessage("Refactoring types ...");
        this.loadTypeStrings(this.apkModule.getTableBlock());
        this.logMessage("Refactoring from AndroidManifest ...");
        AndroidManifestBlock manifestBlock = this.apkModule.getAndroidManifestBlock();
        this.scanXml(manifestBlock, 0);
        this.scanResFiles();
        if (!this.isFinished()) {
            this.scanTableEntries(this.apkModule.getTableBlock());
        }
        this.logFinished();
    }

    private void logFinished() {
        StringBuilder log = new StringBuilder();
        log.append("Finished type rename=");
        log.append(this.refactoredTypeMap.count());
        if (this.refactoredTypeMap.count() > 0) {
            log.append("\n");
            XMLElement element = this.refactoredTypeMap.toXMLDocument().getDocumentElement();
            element.setTagName("renamed");
            element.setAttribute("count", this.refactoredTypeMap.count());
            log.append(element.toText(2, false));
        }
        TypeNameMap remain = new TypeNameMap();
        for (Map.Entry<Integer, TypeString> entry : this.mTypeStrings.entrySet()) {
            remain.add(entry.getKey(), entry.getValue().get());
        }
        if (remain.count() > 0) {
            log.append("\n");
            XMLDocument xmlDocument = remain.toXMLDocument();
            XMLElement element = xmlDocument.getDocumentElement();
            element.setTagName("remain");
            log.append(xmlDocument.toText(2, false));
        }
        this.logMessage(log.toString());
    }

    private void scanTableEntries(TableBlock tableBlock) {
        this.logMessage("Refactoring from TableBlock ...");
        for (PackageBlock packageBlock : tableBlock.listPackages()) {
            if (this.isFinished()) break;
            this.scanPackageEntries(packageBlock);
        }
    }

    private void scanPackageEntries(PackageBlock packageBlock) {
        for (EntryGroup entryGroup : packageBlock.listEntryGroup()) {
            if (this.isFinished()) break;
            this.checkEntryGroup(entryGroup);
        }
    }

    private void checkEntryGroup(EntryGroup entryGroup) {
        int resourceId = entryGroup.getResourceId();
        if (this.hasRefactoredId(resourceId)) {
            return;
        }
        boolean renameOk = this.checkBag(entryGroup);
        if (renameOk) {
            return;
        }
    }

    private boolean checkBag(EntryGroup entryGroup) {
        if (!this.hasRefactoredName("style") || !this.hasRefactoredName("attr")) {
            return false;
        }
        boolean hasBagEntry = false;
        Iterator itr = entryGroup.iterator(true);
        while (itr.hasNext()) {
            Entry entryBlock = (Entry)itr.next();
            if (!entryBlock.isComplex()) {
                return false;
            }
            hasBagEntry = true;
            ResTableMapEntry resValueBag = (ResTableMapEntry)entryBlock.getTableEntry();
            if (this.checkPlurals(resValueBag)) {
                return true;
            }
            if (!this.checkArray(resValueBag)) continue;
            return true;
        }
        return hasBagEntry;
    }

    private boolean checkArray(ResTableMapEntry resValueBag) {
        String name = "array";
        if (this.hasRefactoredName(name)) {
            return false;
        }
        if (((ResValueMapArray)resValueBag.getValue()).childesCount() < 2) {
            return false;
        }
        if (!ArrayBag.isArray(resValueBag.getParentEntry())) {
            return false;
        }
        int resourceId = resValueBag.getParentEntry().getResourceId();
        this.rename(resourceId, name);
        return true;
    }

    private boolean checkPlurals(ResTableMapEntry resValueBag) {
        String name = "plurals";
        if (this.hasRefactoredName(name)) {
            return false;
        }
        if (((ResValueMapArray)resValueBag.getValue()).childesCount() < 2) {
            return false;
        }
        if (!PluralsBag.isPlurals(resValueBag.getParentEntry())) {
            return false;
        }
        int resourceId = resValueBag.getParentEntry().getResourceId();
        this.rename(resourceId, name);
        return true;
    }

    private void scanResFiles() throws IOException {
        this.logMessage("Refactoring from resource files ...");
        for (ResFile resFile : this.apkModule.listResFiles()) {
            if (this.isFinished()) break;
            if (!resFile.isBinaryXml()) continue;
            ResXmlDocument resXmlDocument = new ResXmlDocument();
            resXmlDocument.readBytes(resFile.getInputSource().openStream());
            this.scanXml(resXmlDocument, resFile.pickOne().getResourceId());
        }
    }

    private void loadTypeStrings(TableBlock tableBlock) {
        this.mTypeStrings = new HashMap<Integer, TypeString>();
        for (PackageBlock packageBlock : tableBlock.listPackages()) {
            int pkgId = packageBlock.getId();
            for (TypeString typeString : packageBlock.getTypeStringPool().listStrings()) {
                int pkgTypeId = pkgId << 24 | (0xFF & typeString.getId()) << 16;
                this.mTypeStrings.put(pkgTypeId, typeString);
            }
        }
    }

    private void scanXml(ResXmlDocument xmlBlock, int resourceId) {
        boolean isManifest = xmlBlock instanceof AndroidManifestBlock;
        if (!isManifest && resourceId != 0 && !this.hasRefactoredId(resourceId)) {
            boolean renameOk = this.checkLayout(xmlBlock, resourceId);
            if (renameOk) {
                return;
            }
            renameOk = this.checkDrawable(xmlBlock, resourceId);
            if (renameOk) {
                return;
            }
            renameOk = this.checkAnimator(xmlBlock, resourceId);
            if (renameOk) {
                return;
            }
            renameOk = this.checkMenu(xmlBlock, resourceId);
            if (renameOk) {
                return;
            }
            renameOk = this.checkXml(xmlBlock, resourceId);
            if (renameOk) {
                return;
            }
            renameOk = this.checkAnim(xmlBlock, resourceId);
            if (renameOk) {
                return;
            }
            renameOk = this.checkInterpolator(xmlBlock, resourceId);
            if (renameOk) {
                return;
            }
        }
        List<ResXmlAttribute> attributeList = this.listAttributes(xmlBlock.getResXmlElement());
        for (ResXmlAttribute attribute : attributeList) {
            this.scanAttribute(attribute, isManifest);
        }
    }

    private void scanAttribute(ResXmlAttribute attribute, boolean isManifest) {
        if (isManifest) {
            boolean renameOk = this.checkString(attribute);
            if (!renameOk) {
                renameOk = this.checkStyle(attribute);
            }
            return;
        }
        boolean renameOk = this.checkAttr(attribute);
        if (this.hasRefactoredId(attribute.getData())) {
            return;
        }
        if (!renameOk) {
            renameOk = this.checkId(attribute);
        }
        if (!renameOk) {
            renameOk = this.checkDimen(attribute);
        }
        if (!renameOk) {
            renameOk = this.checkInteger(attribute);
        }
        if (!renameOk) {
            renameOk = this.checkColor(attribute);
        }
        if (!renameOk) {
            renameOk = this.checkBool(attribute);
        }
    }

    private boolean checkInterpolator(ResXmlDocument resXmlDocument, int resourceId) {
        String name = "interpolator";
        if (this.hasRefactoredName(name)) {
            return false;
        }
        ResXmlElement root = resXmlDocument.getResXmlElement();
        if (root == null) {
            return false;
        }
        String tag = root.getTag();
        if (!"pathInterpolator".equals(tag) && !"linearInterpolator".equals(tag)) {
            return false;
        }
        return this.rename(resourceId, name);
    }

    private boolean checkAnim(ResXmlDocument resXmlDocument, int resourceId) {
        String name = "anim";
        if (this.hasRefactoredName(name)) {
            return false;
        }
        if (!this.hasRefactoredName("animator")) {
            return false;
        }
        ResXmlElement root = resXmlDocument.getResXmlElement();
        if (root == null) {
            return false;
        }
        if (!"alpha".equals(root.getTag())) {
            return false;
        }
        int fromAlpha = 16843210;
        if (root.searchAttributeByResourceId(fromAlpha) == null) {
            return false;
        }
        return this.rename(resourceId, name);
    }

    private boolean checkXml(ResXmlDocument resXmlDocument, int resourceId) {
        String name = "xml";
        if (this.hasRefactoredName(name)) {
            return false;
        }
        ResXmlElement root = resXmlDocument.getResXmlElement();
        if (root == null) {
            return false;
        }
        if (!this.isXml(root)) {
            return false;
        }
        return this.rename(resourceId, name);
    }

    private boolean checkMenu(ResXmlDocument resXmlDocument, int resourceId) {
        String name = "menu";
        if (this.hasRefactoredName(name)) {
            return false;
        }
        ResXmlElement root = resXmlDocument.getResXmlElement();
        if (root == null) {
            return false;
        }
        if (!"menu".equals(root.getTag())) {
            return false;
        }
        if (root.listElements("item").size() == 0) {
            return false;
        }
        return this.rename(resourceId, name);
    }

    private boolean checkAnimator(ResXmlDocument resXmlDocument, int resourceId) {
        String name = "animator";
        if (this.hasRefactoredName(name)) {
            return false;
        }
        ResXmlElement root = resXmlDocument.getResXmlElement();
        if (root == null) {
            return false;
        }
        if (!"selector".equals(root.getTag())) {
            return false;
        }
        int state_enabled = 16842910;
        boolean hasObjectAnimator = false;
        for (ResXmlElement itemElement : root.listElements("item")) {
            if (itemElement.searchAttributeByResourceId(state_enabled) != null && (hasObjectAnimator = itemElement.listElements("objectAnimator").size() > 0)) break;
        }
        if (!hasObjectAnimator) {
            return false;
        }
        return this.rename(resourceId, name);
    }

    private boolean checkDrawable(ResXmlDocument resXmlDocument, int resourceId) {
        String name = "drawable";
        if (this.hasRefactoredName(name)) {
            return false;
        }
        ResXmlElement root = resXmlDocument.getResXmlElement();
        if (root == null) {
            return false;
        }
        if (!"vector".equals(root.getTag())) {
            return false;
        }
        int pathData = 16843781;
        boolean hasPathData = false;
        for (ResXmlElement element : root.listElements("path")) {
            if (element.searchAttributeByResourceId(pathData) == null) continue;
            hasPathData = true;
        }
        if (!hasPathData) {
            return false;
        }
        return this.rename(resourceId, name);
    }

    private boolean checkLayout(ResXmlDocument resXmlDocument, int resourceId) {
        String name = "layout";
        if (this.hasRefactoredName(name)) {
            return false;
        }
        ResXmlElement root = resXmlDocument.getResXmlElement();
        if (root == null) {
            return false;
        }
        if (!"LinearLayout".equals(root.getTag())) {
            return false;
        }
        return this.rename(resourceId, name);
    }

    private boolean checkAttr(ResXmlAttribute attribute) {
        String name = "attr";
        if (this.hasRefactoredName(name)) {
            return false;
        }
        return this.rename(attribute.getNameResourceID(), name);
    }

    private boolean checkColor(ResXmlAttribute attribute) {
        String name = "color";
        if (this.hasRefactoredName(name)) {
            return false;
        }
        if (!this.hasRefactoredName("drawable")) {
            return false;
        }
        int textColor = 16842904;
        int nameId = attribute.getNameResourceID();
        if (nameId != textColor) {
            return false;
        }
        if (attribute.getValueType() != ValueType.REFERENCE) {
            return true;
        }
        this.rename(attribute.getData(), name);
        return true;
    }

    private boolean checkBool(ResXmlAttribute attribute) {
        return this.checkWithAndroidAttribute("bool", attribute, AttributeDataFormat.BOOL);
    }

    private boolean checkInteger(ResXmlAttribute attribute) {
        return this.checkWithAndroidAttribute("integer", attribute, AttributeDataFormat.INTEGER);
    }

    private boolean checkWithAndroidAttribute(String name, ResXmlAttribute attribute, AttributeDataFormat attributeValueType) {
        if (this.hasRefactoredName(name)) {
            return false;
        }
        int nameId = attribute.getNameResourceID();
        if (nameId == 0) {
            return false;
        }
        if (attribute.getValueType() != ValueType.REFERENCE) {
            return true;
        }
        if (!this.isEqualAndroidAttributeType(nameId, attributeValueType)) {
            return false;
        }
        this.rename(attribute.getData(), name);
        return true;
    }

    private boolean checkDimen(ResXmlAttribute attribute) {
        String name = "dimen";
        if (this.hasRefactoredName(name)) {
            return false;
        }
        int layout_width = 16842996;
        int layout_height = 16842997;
        int nameId = attribute.getNameResourceID();
        if (nameId != layout_width && nameId != layout_height) {
            return false;
        }
        if (attribute.getValueType() != ValueType.REFERENCE) {
            return true;
        }
        this.rename(attribute.getData(), name);
        return true;
    }

    private boolean checkId(ResXmlAttribute attribute) {
        String name = "id";
        if (this.hasRefactoredName(name)) {
            return false;
        }
        if (attribute.getNameResourceID() != 0x10100D0) {
            return false;
        }
        if (attribute.getValueType() != ValueType.REFERENCE) {
            return true;
        }
        this.rename(attribute.getData(), name);
        return true;
    }

    private boolean checkStyle(ResXmlAttribute attribute) {
        String name = "style";
        if (this.hasRefactoredName(name)) {
            return false;
        }
        if (attribute.getNameResourceID() != 0x1010000) {
            return false;
        }
        if (attribute.getValueType() != ValueType.REFERENCE) {
            return true;
        }
        this.rename(attribute.getData(), name);
        return true;
    }

    private boolean checkString(ResXmlAttribute attribute) {
        String name = "string";
        if (this.hasRefactoredName(name)) {
            return false;
        }
        if (attribute.getNameResourceID() != 0x1010001) {
            return false;
        }
        if (attribute.getValueType() != ValueType.REFERENCE) {
            return true;
        }
        this.rename(attribute.getData(), name);
        return true;
    }

    private boolean isXml(ResXmlElement root) {
        if (this.isPaths(root)) {
            return true;
        }
        return this.isPreferenceScreen(root);
    }

    private boolean isPreferenceScreen(ResXmlElement root) {
        if (!"PreferenceScreen".equals(root.getTag())) {
            return false;
        }
        for (ResXmlElement element : root.listElements()) {
            String tag = element.getTag();
            if ("PreferenceCategory".equals(tag)) {
                return true;
            }
            if (!"CheckBoxPreference".equals(tag)) continue;
            return true;
        }
        return false;
    }

    private boolean isPaths(ResXmlElement root) {
        if (!"paths".equals(root.getTag())) {
            return false;
        }
        for (ResXmlElement element : root.listElements()) {
            String tag = element.getTag();
            if ("files-path".equals(tag) || "cache-path".equals(tag)) {
                return true;
            }
            if ("external-path".equals(tag) || "root-path".equals(tag)) {
                return true;
            }
            if (!"external-files-path".equals(tag) && !"external-cache-path".equals(tag)) continue;
            return true;
        }
        return false;
    }

    private boolean rename(int resourceId, String name) {
        TypeString typeString = this.getTypeString(resourceId);
        if (typeString == null) {
            return false;
        }
        this.removeTypeString(resourceId);
        this.addRefactored(resourceId, name);
        if (name.equals(typeString.get())) {
            return true;
        }
        this.logMessage("Renamed: '" + typeString.get() + "' --> '" + name + "'");
        typeString.set(name);
        return true;
    }

    private boolean isEqualAndroidAttributeType(int attributeResourceId, AttributeDataFormat attributeValueType) {
        FrameworkApk frameworkApk = AndroidFrameworks.getCurrent();
        if (frameworkApk == null) {
            return false;
        }
        FrameworkTable frameworkTable = frameworkApk.getTableBlock();
        if (frameworkTable == null) {
            return false;
        }
        EntryGroup entryGroup = frameworkTable.search(attributeResourceId);
        if (entryGroup == null) {
            return false;
        }
        Entry entryBlock = entryGroup.pickOne();
        if (entryBlock == null || !entryBlock.isComplex()) {
            return false;
        }
        AttributeBag attributeBag = AttributeBag.create((ResValueMapArray)((ResTableMapEntry)entryBlock.getTableEntry()).getValue());
        if (attributeBag == null) {
            return false;
        }
        if (attributeBag.isFlag() || attributeBag.isEnum()) {
            return false;
        }
        return attributeBag.getFormat().isEqualType(attributeValueType);
    }

    private void addRefactored(int id, String name) {
        this.refactoredTypeMap.add(id, name);
    }

    private boolean isFinished() {
        return this.mTypeStrings.size() == 0;
    }

    private boolean hasRefactoredName(String name) {
        return this.refactoredTypeMap.contains(name);
    }

    private boolean hasRefactoredId(int resourceId) {
        return this.refactoredTypeMap.contains(resourceId);
    }

    private TypeString getTypeString(int resourceId) {
        return this.mTypeStrings.get(resourceId & 0xFFFF0000);
    }

    private void removeTypeString(int resourceId) {
        this.mTypeStrings.remove(resourceId & 0xFFFF0000);
    }

    private List<ResXmlAttribute> listAttributes(ResXmlElement element) {
        if (element == null) {
            return new ArrayList<ResXmlAttribute>();
        }
        ArrayList<ResXmlAttribute> results = new ArrayList<ResXmlAttribute>(element.listAttributes());
        for (ResXmlElement child : element.listElements()) {
            results.addAll(this.listAttributes(child));
        }
        return results;
    }

    private void logMessage(String msg) {
        APKLogger logger = this.apkLogger;
        if (logger != null) {
            logger.logMessage(msg);
        }
    }

    private void logVerbose(String msg) {
        APKLogger logger = this.apkLogger;
        if (logger != null) {
            logger.logVerbose(msg);
        }
    }
}

