/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.refactor;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.ApkModule;
import com.reandroid.apkeditor.BaseCommand;
import com.reandroid.apkeditor.Util;
import com.reandroid.apkeditor.refactor.AutoRefactor;
import com.reandroid.apkeditor.refactor.PublicXmlRefactor;
import com.reandroid.apkeditor.refactor.RefactorOptions;
import com.reandroid.apkeditor.refactor.StringValueNameGenerator;
import com.reandroid.apkeditor.refactor.TypeNameRefactor;
import com.reandroid.archive.WriteProgress;
import com.reandroid.commons.command.ARGException;
import com.reandroid.commons.utils.log.Logger;
import java.io.File;
import java.io.IOException;

public class Refactor
extends BaseCommand
implements WriteProgress {
    private final RefactorOptions options;
    private APKLogger mApkLogger;
    public static final String ARG_SHORT = "x";
    public static final String ARG_LONG = "refactor";
    public static final String DESCRIPTION = "Refactors obfuscated resource names";

    public Refactor(RefactorOptions options) {
        this.options = options;
    }

    @Override
    public void run() throws IOException {
        Refactor.log("Loading apk: " + this.options.inputFile);
        ApkModule module = ApkModule.loadApkFile(this.options.inputFile);
        module.setAPKLogger(this.getAPKLogger());
        if (!module.hasTableBlock()) {
            throw new IOException("Don't have resources.arsc");
        }
        String protect = Util.isProtected(module);
        if (protect != null) {
            Refactor.log(this.options.inputFile.getAbsolutePath());
            Refactor.log(protect);
            return;
        }
        if (this.options.fixTypeNames) {
            TypeNameRefactor typeNameRefactor = new TypeNameRefactor(module);
            typeNameRefactor.setApkLogger(this.getAPKLogger());
            typeNameRefactor.refactor();
        }
        if (this.options.publicXml != null) {
            Refactor.log("Renaming from: " + this.options.publicXml);
            PublicXmlRefactor publicXmlRefactor = new PublicXmlRefactor(module, this.options.publicXml);
            publicXmlRefactor.refactor();
        } else {
            Refactor.log("Auto refactoring ...");
            AutoRefactor autoRefactor = new AutoRefactor(module);
            autoRefactor.refactor();
            Refactor.log("Auto renamed entries");
            StringValueNameGenerator generator = new StringValueNameGenerator(module.getTableBlock());
            generator.refactor();
        }
        if (this.options.cleanMeta) {
            Refactor.log("Clearing META-INF ...");
            Refactor.clearMeta(module);
        }
        Util.addApkEditorInfo(module, this.getClass().getSimpleName());
        String message = module.refreshTable();
        if (message != null) {
            Refactor.log(message);
        }
        Refactor.log("Writing apk ...");
        module.writeApk(this.options.outputFile, this);
        Refactor.log("Saved to: " + this.options.outputFile);
        Refactor.log("Done");
    }

    @Override
    public void onCompressFile(String path, int method, long length) {
        StringBuilder builder = new StringBuilder();
        builder.append("Writing: ");
        if (path.length() > 30) {
            path = path.substring(path.length() - 30);
        }
        builder.append(path);
        Refactor.logSameLine(builder.toString());
    }

    private APKLogger getAPKLogger() {
        if (this.mApkLogger != null) {
            return this.mApkLogger;
        }
        this.mApkLogger = new APKLogger(){

            @Override
            public void logMessage(String msg) {
                Logger.i(Refactor.getLogTag() + msg);
            }

            @Override
            public void logError(String msg, Throwable tr) {
                Logger.e(Refactor.getLogTag() + msg, tr);
            }

            @Override
            public void logVerbose(String msg) {
                if (msg.length() > 30) {
                    msg = msg.substring(msg.length() - 30);
                }
                Logger.sameLine(Refactor.getLogTag() + msg);
            }
        };
        return this.mApkLogger;
    }

    public static void execute(String[] args) throws ARGException, IOException {
        if (Util.isHelp(args)) {
            throw new ARGException(RefactorOptions.getHelp());
        }
        RefactorOptions option = new RefactorOptions();
        option.parse(args);
        File outFile = option.outputFile;
        Util.deleteEmptyDirectories(outFile);
        if (outFile.exists()) {
            if (!option.force) {
                throw new ARGException("Path already exists: " + outFile);
            }
            Refactor.log("Deleting: " + outFile);
            Util.deleteDir(outFile);
        }
        Refactor.log("Refactoring ...\n" + option);
        Refactor refactor = new Refactor(option);
        refactor.run();
    }

    private static void logSameLine(String msg) {
        Logger.sameLine(Refactor.getLogTag() + msg);
    }

    private static void log(String msg) {
        Logger.i(Refactor.getLogTag() + msg);
    }

    private static String getLogTag() {
        return "[REFACTOR] ";
    }

    public static boolean isCommand(String command) {
        if (Util.isEmpty(command)) {
            return false;
        }
        return (command = command.toLowerCase().trim()).equals(ARG_SHORT) || command.equals(ARG_LONG);
    }
}

