/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.protect;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ApkUtil;
import com.reandroid.apk.ResFile;
import com.reandroid.apk.UncompressedFiles;
import com.reandroid.apkeditor.APKEditor;
import com.reandroid.apkeditor.BaseCommand;
import com.reandroid.apkeditor.Util;
import com.reandroid.apkeditor.protect.ProtectorOptions;
import com.reandroid.archive.WriteProgress;
import com.reandroid.arsc.BuildInfo;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.UnknownChunk;
import com.reandroid.arsc.chunk.xml.AndroidManifestBlock;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.item.ByteArray;
import com.reandroid.arsc.item.FixedLengthString;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.commons.command.ARGException;
import com.reandroid.commons.utils.log.Logger;
import java.io.File;
import java.io.IOException;

public class Protector
extends BaseCommand
implements WriteProgress {
    private final ProtectorOptions options;
    private APKLogger mApkLogger;
    public static final String ARG_SHORT = "p";
    public static final String ARG_LONG = "protect";
    public static final String DESCRIPTION = "Protects/Obfuscates apk resource";

    public Protector(ProtectorOptions options) {
        this.options = options;
    }

    @Override
    public void run() throws IOException {
        Protector.log("Loading apk file ...");
        ApkModule module = ApkModule.loadApkFile(this.options.inputFile);
        String protect = Util.isProtected(module);
        if (protect != null) {
            Protector.log(this.options.inputFile.getAbsolutePath());
            Protector.log(protect);
            return;
        }
        module.setAPKLogger(this.getAPKLogger());
        this.confuseAndroidManifest(module);
        Protector.log("Protecting files ..");
        this.confuseResDir(module);
        Protector.log("Protecting resource table ..");
        this.confuseByteOffset(module);
        this.confuseResourceTable(module);
        Util.addApkEditorInfo(module, "PROTECTED");
        module.getTableBlock().refresh();
        Protector.log("Writing apk ...");
        module.writeApk(this.options.outputFile, this);
        Protector.log("Saved to: " + this.options.outputFile);
        Protector.log("Done");
    }

    private void confuseAndroidManifest(ApkModule apkModule) throws IOException {
        if (this.options.skipManifest) {
            Protector.log("Skip AndroidManifest");
            return;
        }
        Protector.log("Confusing AndroidManifest ...");
        AndroidManifestBlock manifestBlock = apkModule.getAndroidManifestBlock();
        manifestBlock.setAttributesUnitSize(24, true);
        manifestBlock.refresh();
    }

    private void confuseByteOffset(ApkModule apkModule) throws IOException {
        Protector.log("METHOD-1 Protecting resource table ..");
        TableBlock tableBlock = apkModule.getTableBlock();
        for (PackageBlock packageBlock : tableBlock.listPackages()) {
            for (SpecTypePair specTypePair : packageBlock.listAllSpecTypePair()) {
                for (ResConfig resConfig : specTypePair.listResConfig()) {
                    resConfig.trimToSize(16);
                }
            }
        }
        tableBlock.refresh();
    }

    private void confuseResourceTable(ApkModule apkModule) throws IOException {
        Protector.log("METHOD-2 Protecting resource table ..");
        TableBlock tableBlock = apkModule.getTableBlock();
        UnknownChunk unknownChunk = new UnknownChunk();
        FixedLengthString fixedLengthString = new FixedLengthString(256);
        fixedLengthString.set(APKEditor.getRepo());
        ByteArray extra = ((HeaderBlock)unknownChunk.getHeaderBlock()).getExtraBytes();
        byte[] bts = fixedLengthString.getBytes();
        extra.setSize(bts.length);
        extra.putByteArray(0, bts);
        fixedLengthString.set(BuildInfo.getRepo());
        extra = unknownChunk.getBody();
        bts = fixedLengthString.getBytes();
        extra.setSize(bts.length);
        extra.putByteArray(0, bts);
        fixedLengthString.set(BuildInfo.getRepo());
        unknownChunk.refresh();
        tableBlock.getFirstPlaceHolder().setItem(unknownChunk);
        tableBlock.refresh();
    }

    private void confuseResDir(ApkModule apkModule) throws IOException {
        Protector.log("Protecting files ..");
        String[] dirNames = new String[]{"AndroidManifest.xml", "resources.arsc", "classes.dex"};
        UncompressedFiles uf = apkModule.getUncompressedFiles();
        int i = 0;
        for (ResFile resFile : apkModule.listResFiles()) {
            if (i >= dirNames.length) {
                i = 0;
            }
            int method = resFile.getInputSource().getMethod();
            String path = resFile.getFilePath();
            Entry entryBlock = resFile.pickOne();
            if (entryBlock != null && "font".equals(entryBlock.getTypeName())) {
                Protector.log("  Ignored: " + path);
                continue;
            }
            String pathNew = ApkUtil.replaceRootDir(path, dirNames[i]);
            if (method == 0) {
                uf.replacePath(path, pathNew);
            }
            resFile.setFilePath(pathNew);
            ++i;
        }
    }

    @Override
    public void onCompressFile(String path, int method, long length) {
        StringBuilder builder = new StringBuilder();
        builder.append("Writing:");
        if (method == 0) {
            builder.append(" method=STORED");
        }
        builder.append(" total=");
        builder.append(length);
        builder.append(" bytes : ");
        if (path.length() > 30) {
            path = path.substring(path.length() - 30);
        }
        builder.append(path);
        Protector.logSameLine(builder.toString());
    }

    private APKLogger getAPKLogger() {
        if (this.mApkLogger != null) {
            return this.mApkLogger;
        }
        this.mApkLogger = new APKLogger(){

            @Override
            public void logMessage(String msg) {
                Logger.i(Protector.getLogTag() + msg);
            }

            @Override
            public void logError(String msg, Throwable tr) {
                Logger.e(Protector.getLogTag() + msg, tr);
            }

            @Override
            public void logVerbose(String msg) {
                if (msg.length() > 30) {
                    msg = msg.substring(msg.length() - 30);
                }
                Logger.sameLine(Protector.getLogTag() + msg);
            }
        };
        return this.mApkLogger;
    }

    public static void execute(String[] args) throws ARGException, IOException {
        if (Util.isHelp(args)) {
            throw new ARGException(ProtectorOptions.getHelp());
        }
        ProtectorOptions option = new ProtectorOptions();
        option.parse(args);
        File outFile = option.outputFile;
        Util.deleteEmptyDirectories(outFile);
        if (outFile.exists()) {
            if (!option.force) {
                throw new ARGException("Path already exists: " + outFile);
            }
            Protector.log("Deleting: " + outFile);
            Util.deleteDir(outFile);
        }
        Protector.log("Protecting ...\n" + option);
        Protector protector = new Protector(option);
        protector.run();
    }

    private static void logSameLine(String msg) {
        Logger.sameLine(Protector.getLogTag() + msg);
    }

    private static void log(String msg) {
        Logger.i(Protector.getLogTag() + msg);
    }

    private static String getLogTag() {
        return "[PROTECT] ";
    }

    public static boolean isCommand(String command) {
        if (Util.isEmpty(command)) {
            return false;
        }
        return (command = command.toLowerCase().trim()).equals(ARG_SHORT) || command.equals(ARG_LONG);
    }
}

