/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.merge;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.ApkBundle;
import com.reandroid.apk.ApkModule;
import com.reandroid.apkeditor.BaseCommand;
import com.reandroid.apkeditor.Util;
import com.reandroid.apkeditor.common.AndroidManifestHelper;
import com.reandroid.apkeditor.merge.MergerOptions;
import com.reandroid.archive.APKArchive;
import com.reandroid.archive.WriteProgress;
import com.reandroid.archive2.Archive;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.xml.AndroidManifestBlock;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.group.EntryGroup;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResValue;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.commons.command.ARGException;
import com.reandroid.commons.utils.log.Logger;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class Merger
extends BaseCommand
implements WriteProgress {
    private final MergerOptions options;
    private APKLogger mApkLogger;
    public static final String ARG_SHORT = "m";
    public static final String ARG_LONG = "merge";
    public static final String DESCRIPTION = "Merges split apk files from directory or compressed apk files like XAPK, APKM, APKS ...";

    public Merger(MergerOptions options) {
        this.options = options;
    }

    @Override
    public void run() throws IOException {
        File dir = this.options.inputFile;
        boolean extracted = false;
        if (dir.isFile()) {
            dir = this.extractFile(dir);
            extracted = true;
        }
        Merger.log("Searching apk files ...");
        ApkBundle bundle = new ApkBundle();
        bundle.setAPKLogger(this.getAPKLogger());
        bundle.loadApkDirectory(dir, extracted);
        Merger.log("Found modules: " + bundle.getApkModuleList().size());
        for (ApkModule apkModule : bundle.getApkModuleList()) {
            String protect = Util.isProtected(apkModule);
            if (protect == null) continue;
            Merger.log(this.options.inputFile.getAbsolutePath());
            Merger.log(protect);
            return;
        }
        ApkModule mergedModule = bundle.mergeModules();
        if (this.options.resDirName != null) {
            Merger.log("Renaming resources root dir: " + this.options.resDirName);
            mergedModule.setResourcesRootDir(this.options.resDirName);
        }
        if (this.options.validateResDir) {
            Merger.log("Validating resources dir ...");
            mergedModule.validateResourcesDir();
        }
        if (this.options.cleanMeta) {
            Merger.log("Clearing META-INF ...");
            Merger.clearMeta(mergedModule);
        }
        this.sanitizeManifest(mergedModule);
        Util.addApkEditorInfo(mergedModule, this.getClass().getSimpleName());
        String message = mergedModule.refreshTable();
        if (message != null) {
            Merger.log(message);
        }
        if ((message = mergedModule.refreshManifest()) != null) {
            Merger.log(message);
        }
        Merger.log("Writing apk ...");
        mergedModule.writeApk(this.options.outputFile, this);
        if (extracted) {
            Util.deleteDir(dir);
        }
        Merger.log("Saved to: " + this.options.outputFile);
        Merger.log("Done");
    }

    private File extractFile(File file) throws IOException {
        File tmp = this.toTmpDir(file);
        Merger.log("Extracting to: " + tmp);
        if (tmp.exists()) {
            Merger.log("Delete: " + tmp);
            Util.deleteDir(tmp);
        }
        tmp.deleteOnExit();
        Archive archive = new Archive(file);
        archive.extractAll(tmp);
        return tmp;
    }

    private File toTmpDir(File file) {
        String name = file.getName();
        int i = name.lastIndexOf(46);
        if (i > 0) {
            name = name.substring(0, i);
        }
        name = name + "_tmp";
        File dir = file.getParentFile();
        if (dir == null) {
            return new File(name);
        }
        return new File(dir, name);
    }

    private void sanitizeManifest(ApkModule apkModule) {
        if (!apkModule.hasAndroidManifestBlock()) {
            return;
        }
        AndroidManifestBlock manifest = apkModule.getAndroidManifestBlock();
        Merger.log("Sanitizing manifest ...");
        boolean removed = AndroidManifestHelper.removeApplicationAttribute(manifest, 16844010);
        if (removed) {
            Merger.log("Removed: extractNativeLibs");
        }
        if (removed = AndroidManifestHelper.removeApplicationAttribute(manifest, 16844177)) {
            Merger.log("Removed: isSplitRequired");
        }
        ResXmlElement application = manifest.getApplicationElement();
        List<ResXmlElement> splitMetaDataElements = AndroidManifestHelper.listSplitRequired(application);
        boolean splits_removed = false;
        for (ResXmlElement meta : splitMetaDataElements) {
            if (!splits_removed) {
                splits_removed = this.removeSplitsTableEntry(meta, apkModule);
            }
            Merger.log("Removed: " + meta.toString());
            application.removeElement(meta);
        }
        manifest.refresh();
    }

    private boolean removeSplitsTableEntry(ResXmlElement metaElement, ApkModule apkModule) {
        ResXmlAttribute nameAttribute = metaElement.searchAttributeByResourceId(0x1010003);
        if (nameAttribute == null) {
            return false;
        }
        if (!"com.android.vending.splits".equals(nameAttribute.getValueAsString())) {
            return false;
        }
        ResXmlAttribute valueAttribute = metaElement.searchAttributeByResourceId(16842788);
        if (valueAttribute == null) {
            valueAttribute = metaElement.searchAttributeByResourceId(16842789);
        }
        if (valueAttribute == null || valueAttribute.getValueType() != ValueType.REFERENCE) {
            return false;
        }
        if (!apkModule.hasTableBlock()) {
            return false;
        }
        TableBlock tableBlock = apkModule.getTableBlock();
        EntryGroup entryGroup = tableBlock.search(valueAttribute.getData());
        if (entryGroup == null) {
            return false;
        }
        APKArchive apkArchive = apkModule.getApkArchive();
        List entryList = entryGroup.listItems();
        for (Entry entry : entryList) {
            ResValue resValue;
            if (entry == null || (resValue = entry.getResValue()) == null) continue;
            String path = resValue.getValueAsString();
            Merger.log("Removed from table: " + path);
            apkArchive.remove(path);
            entry.setNull(true);
            SpecTypePair specTypePair = entry.getTypeBlock().getParentSpecTypePair();
            specTypePair.removeNullEntries(entry.getId());
        }
        return true;
    }

    @Override
    public void onCompressFile(String path, int method, long length) {
        StringBuilder builder = new StringBuilder();
        builder.append("Writing:");
        if (method == 0) {
            builder.append(" method=STORED");
        }
        builder.append(" total=");
        builder.append(length);
        builder.append(" bytes : ");
        if (path.length() > 30) {
            path = path.substring(path.length() - 30);
        }
        builder.append(path);
        Merger.logSameLine(builder.toString());
    }

    private APKLogger getAPKLogger() {
        if (this.mApkLogger != null) {
            return this.mApkLogger;
        }
        this.mApkLogger = new APKLogger(){

            @Override
            public void logMessage(String msg) {
                Logger.i(Merger.getLogTag() + msg);
            }

            @Override
            public void logError(String msg, Throwable tr) {
                Logger.e(Merger.getLogTag() + msg, tr);
            }

            @Override
            public void logVerbose(String msg) {
                if (msg.length() > 30) {
                    msg = msg.substring(msg.length() - 30);
                }
                Logger.sameLine(Merger.getLogTag() + msg);
            }
        };
        return this.mApkLogger;
    }

    public static void execute(String[] args) throws ARGException, IOException {
        if (Util.isHelp(args)) {
            throw new ARGException(MergerOptions.getHelp());
        }
        MergerOptions option = new MergerOptions();
        option.parse(args);
        File outFile = option.outputFile;
        if (Objects.equals(outFile.getParentFile(), option.inputFile)) {
            throw new IOException("Output file can not be inside input directory!");
        }
        Util.deleteEmptyDirectories(outFile);
        if (outFile.exists()) {
            if (!option.force) {
                throw new ARGException("Path already exists: " + outFile);
            }
            Merger.log("Deleting: " + outFile);
            Util.deleteDir(outFile);
        }
        Merger.log("Merging ...\n" + option);
        Merger merger = new Merger(option);
        merger.run();
    }

    private static void logSameLine(String msg) {
        Logger.sameLine(Merger.getLogTag() + msg);
    }

    private static void log(String msg) {
        Logger.i(Merger.getLogTag() + msg);
    }

    private static String getLogTag() {
        return "[MERGE] ";
    }

    public static boolean isCommand(String command) {
        if (Util.isEmpty(command)) {
            return false;
        }
        return (command = command.toLowerCase().trim()).equals(ARG_SHORT) || command.equals(ARG_LONG);
    }
}

