/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.info;

import com.android.org.kxml2.io.KXmlSerializer;
import com.reandroid.apkeditor.info.InfoWriter;
import com.reandroid.arsc.array.ResValueMapArray;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.group.EntryGroup;
import com.reandroid.arsc.util.HexUtil;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResTableMapEntry;
import com.reandroid.arsc.value.ResValue;
import com.reandroid.arsc.value.ResValueMap;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;

public class InfoWriterXml
extends InfoWriter {
    private KXmlSerializer mSerializer;
    private String mRootTag = "info";
    private int mIndent;
    private static final int INDENT = 3;
    private static final String TAG_INFO = "info";

    public InfoWriterXml(Writer writer) {
        super(writer);
    }

    @Override
    public void writeResources(PackageBlock packageBlock, List<String> typeFilters, boolean writeEntries) throws IOException {
        int indent;
        KXmlSerializer serializer = this.getSerializer();
        this.mIndent = indent = this.mIndent + 2;
        this.writeIndent(serializer, indent);
        serializer.startTag(null, "package");
        serializer.attribute(null, "id", HexUtil.toHex2((byte)packageBlock.getId()));
        serializer.attribute(null, "name", packageBlock.getName());
        packageBlock.sortTypes();
        for (SpecTypePair specTypePair : packageBlock.listSpecTypePairs()) {
            if (!this.contains(specTypePair, typeFilters)) continue;
            this.writeResources(specTypePair, writeEntries);
        }
        this.writeIndent(serializer, indent);
        this.mIndent = indent -= 2;
        serializer.endTag(null, "package");
    }

    public void writeResources(SpecTypePair specTypePair, boolean writeEntries) throws IOException {
        int indent;
        KXmlSerializer serializer = this.getSerializer();
        this.mIndent = indent = this.mIndent + 2;
        this.writeIndent(serializer, indent);
        serializer.startTag(null, "type");
        serializer.attribute(null, "name", specTypePair.getTypeName());
        serializer.attribute(null, "id", Integer.toString(specTypePair.getId()));
        serializer.attribute(null, "entryCount", Integer.toString(specTypePair.getHighestEntryCount()));
        List<EntryGroup> entryGroupList = InfoWriterXml.toSortedEntryGroups(specTypePair.createEntryGroups(true).values());
        for (EntryGroup entryGroup : entryGroupList) {
            this.writeResources(entryGroup, writeEntries);
        }
        this.writeIndent(serializer, indent);
        this.mIndent = indent -= 2;
        serializer.endTag(null, "type");
        serializer.flush();
    }

    @Override
    public void writeResources(EntryGroup entryGroup, boolean writeEntries) throws IOException {
        int indent;
        KXmlSerializer serializer = this.getSerializer();
        this.mIndent = indent = this.mIndent + 2;
        this.writeIndent(serializer, indent);
        serializer.startTag(null, "resource");
        serializer.attribute(null, "id", HexUtil.toHex8(entryGroup.getResourceId()));
        serializer.attribute(null, "type", entryGroup.getTypeName());
        serializer.attribute(null, "name", entryGroup.getSpecName());
        if (writeEntries) {
            this.writeEntries(InfoWriterXml.sortEntries(entryGroup.listItems()));
            this.writeIndent(serializer, indent);
        }
        this.mIndent = indent -= 2;
        serializer.endTag(null, "resource");
        serializer.flush();
    }

    public void writeEntries(List<Entry> entryList) throws IOException {
        for (Entry entry : entryList) {
            this.writeEntry(entry);
        }
    }

    public void writeEntry(Entry entry) throws IOException {
        int indent;
        KXmlSerializer serializer = this.getSerializer();
        this.mIndent = indent = this.mIndent + 2;
        this.writeIndent(serializer, indent);
        serializer.startTag(null, "config");
        serializer.attribute(null, "qualifiers", entry.getResConfig().getQualifiers());
        if (entry.isComplex()) {
            this.writeBagEntry(entry);
        } else {
            this.writeResEntry(entry);
        }
        this.writeIndent(serializer, indent);
        serializer.endTag(null, "config");
        this.mIndent = indent -= 2;
    }

    private void writeResEntry(Entry entry) throws IOException {
        int indent;
        ResValue resValue = entry.getResValue();
        if (resValue == null) {
            return;
        }
        KXmlSerializer serializer = this.getSerializer();
        this.mIndent = indent = this.mIndent + 2;
        this.writeIndent(serializer, indent);
        serializer.startTag(null, "value");
        serializer.attribute(null, "type", resValue.getValueType().name());
        serializer.text(InfoWriterXml.getValueAsString(resValue));
        serializer.endTag(null, "value");
        this.mIndent = indent -= 2;
    }

    private void writeBagEntry(Entry entry) throws IOException {
        int indent;
        KXmlSerializer serializer = this.getSerializer();
        this.mIndent = indent = this.mIndent + 2;
        this.writeIndent(serializer, indent);
        serializer.startTag(null, "bag");
        serializer.attribute(null, "parent", HexUtil.toHex8(((ResTableMapEntry)entry.getTableEntry()).getParentId()));
        ResValueMapArray mapArray = entry.getResValueMapArray();
        for (ResValueMap resValueMap : (ResValueMap[])mapArray.getChildes()) {
            this.writeValueMap(resValueMap);
        }
        this.writeIndent(serializer, indent);
        serializer.endTag(null, "bag");
        this.mIndent = indent -= 2;
    }

    private void writeValueMap(ResValueMap resValueMap) throws IOException {
        int indent;
        KXmlSerializer serializer = this.getSerializer();
        this.mIndent = indent = this.mIndent + 2;
        this.writeIndent(serializer, indent);
        serializer.startTag(null, "value");
        serializer.attribute(null, "name", HexUtil.toHex8(resValueMap.getNameResourceID()));
        serializer.attribute(null, "type", resValueMap.getValueType().name());
        serializer.text(InfoWriterXml.getValueAsString(resValueMap));
        serializer.endTag(null, "value");
        this.mIndent = indent -= 2;
    }

    @Override
    public void writePackageNames(Collection<PackageBlock> packageBlocks) throws IOException {
        if (packageBlocks == null || packageBlocks.size() == 0) {
            return;
        }
        int level = 3;
        KXmlSerializer serializer = this.getSerializer();
        this.writeIndent(serializer, level);
        serializer.startTag(null, "resource-packages");
        serializer.attribute(null, "count", Integer.toString(packageBlocks.size()));
        level += 2;
        for (PackageBlock packageBlock : packageBlocks) {
            this.writeIndent(serializer, level);
            serializer.startTag(null, "package");
            serializer.attribute(null, "id", HexUtil.toHex2((byte)packageBlock.getId()));
            serializer.attribute(null, "name", packageBlock.getName());
            serializer.endTag(null, "package");
        }
        this.writeIndent(serializer, level -= 2);
        serializer.endTag(null, "resource-packages");
        serializer.flush();
    }

    @Override
    public void writeEntries(String name, List<Entry> entryList) throws IOException {
        if (entryList == null || entryList.size() == 0) {
            return;
        }
        Entry first = entryList.get(0);
        int level = 3;
        KXmlSerializer serializer = this.getSerializer();
        this.writeIndent(serializer, level);
        serializer.startTag(null, name);
        serializer.attribute(null, "count", Integer.toString(entryList.size()));
        serializer.attribute(null, "id", HexUtil.toHex8(first.getResourceId()));
        serializer.attribute(null, "type", first.getTypeName());
        serializer.attribute(null, "name", first.getName());
        level += 2;
        for (Entry entry : entryList) {
            String config = entry.getResConfig().getQualifiers();
            if (config.length() == 0) {
                config = "default";
            }
            String text = InfoWriterXml.getValueAsString(entry);
            this.writeIndent(serializer, level);
            serializer.startTag(null, "item");
            serializer.attribute(null, "config", config);
            serializer.text(text);
            serializer.endTag(null, "item");
        }
        this.writeIndent(serializer, level -= 2);
        serializer.endTag(null, name);
        serializer.flush();
    }

    @Override
    public void writeArray(String name, Object[] values) throws IOException {
        if (values == null) {
            return;
        }
        int level = 3;
        KXmlSerializer serializer = this.getSerializer();
        this.writeIndent(serializer, level);
        serializer.startTag(null, name);
        serializer.attribute(null, "count", Integer.toString(values.length));
        level += 2;
        for (Object value : values) {
            String text = InfoWriterXml.toString(value);
            if (text == null) {
                text = "";
            }
            this.writeIndent(serializer, level);
            serializer.startTag(null, "item");
            serializer.text(text);
            serializer.endTag(null, "item");
        }
        this.writeIndent(serializer, level -= 2);
        serializer.endTag(null, name);
        serializer.flush();
    }

    @Override
    public void writeNameValue(String name, Object value) throws IOException {
        String text = InfoWriterXml.toString(value);
        if (text == null) {
            return;
        }
        KXmlSerializer serializer = this.getSerializer();
        this.writeIndent(serializer, 3);
        serializer.startTag(null, name);
        serializer.text(text);
        serializer.endTag(null, name);
        serializer.flush();
    }

    @Override
    public void flush() throws IOException {
        KXmlSerializer serializer = this.mSerializer;
        if (serializer != null) {
            this.writeIndent(serializer, 0);
            serializer.endTag(null, this.mRootTag);
            serializer.endDocument();
            this.writeIndent(serializer, 0);
            serializer.flush();
        }
    }

    private void writeIndent(KXmlSerializer serializer, int level) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append('\n');
        for (int i = 0; i < level; ++i) {
            builder.append(' ');
        }
        serializer.text(builder.toString());
    }

    private void setRootTag(String tag) {
        KXmlSerializer serializer = this.mSerializer;
        if (serializer != null) {
            return;
        }
        this.mRootTag = tag;
    }

    private KXmlSerializer getSerializer() throws IOException {
        KXmlSerializer serializer = this.mSerializer;
        if (serializer != null) {
            return serializer;
        }
        serializer = new KXmlSerializer();
        serializer.setOutput(this.getWriter());
        serializer.startDocument("utf-8", null);
        this.writeIndent(serializer, 0);
        serializer.startTag(null, this.mRootTag);
        this.mSerializer = serializer;
        return serializer;
    }
}

