/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.info;

import com.reandroid.apkeditor.info.InfoWriter;
import com.reandroid.arsc.array.ResValueMapArray;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.group.EntryGroup;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResTableMapEntry;
import com.reandroid.arsc.value.ResValue;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.json.JSONWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;

public class InfoWriterJson
extends InfoWriter {
    private final JSONWriter mJsonWriter;

    public InfoWriterJson(Writer writer) {
        super(writer);
        JSONWriter jsonWriter = new JSONWriter(writer);
        this.mJsonWriter = jsonWriter = jsonWriter.array();
    }

    @Override
    public void writeResources(PackageBlock packageBlock, List<String> typeFilters, boolean writeEntries) throws IOException {
        packageBlock.sortTypes();
        JSONWriter jsonWriter = this.mJsonWriter.object().key("id").value(packageBlock.getId()).key("package").value(packageBlock.getName()).key("types").array();
        for (SpecTypePair specTypePair : packageBlock.listSpecTypePairs()) {
            if (!this.contains(specTypePair, typeFilters)) continue;
            this.writeResources(specTypePair, writeEntries);
        }
        jsonWriter.endArray().endObject();
    }

    public void writeResources(SpecTypePair specTypePair, boolean writeEntries) throws IOException {
        JSONWriter jsonWriter = this.mJsonWriter.object().key("id").value(specTypePair.getId()).key("type").value(specTypePair.getTypeName()).key("entries").array();
        List<EntryGroup> entryGroupList = InfoWriterJson.toSortedEntryGroups(specTypePair.createEntryGroups(true).values());
        for (EntryGroup entryGroup : entryGroupList) {
            this.writeResources(entryGroup, writeEntries);
        }
        jsonWriter.endArray().endObject();
    }

    @Override
    public void writeResources(EntryGroup entryGroup, boolean writeEntries) throws IOException {
        JSONWriter jsonWriter = this.mJsonWriter.object().key("id").value(entryGroup.getResourceId()).key("type").value(entryGroup.getTypeName()).key("name").value(entryGroup.getSpecName());
        if (writeEntries) {
            jsonWriter.key("configs");
            this.writeEntries(InfoWriterJson.sortEntries(entryGroup.listItems()));
        }
        jsonWriter.endObject();
    }

    public void writeEntries(List<Entry> entryList) throws IOException {
        JSONWriter jsonWriter = this.mJsonWriter.array();
        for (Entry entry : entryList) {
            this.writeEntry(entry);
        }
        jsonWriter.endArray();
    }

    public void writeEntry(Entry entry) throws IOException {
        if (entry.isComplex()) {
            this.writeBagEntry(entry);
        } else {
            this.writeResEntry(entry);
        }
    }

    private void writeResEntry(Entry entry) throws IOException {
        ResValue resValue = entry.getResValue();
        if (resValue == null) {
            return;
        }
        this.mJsonWriter.object().key("qualifiers").value(entry.getResConfig().getQualifiers()).key("value").value(InfoWriterJson.getValueAsString(resValue)).endObject();
    }

    private void writeBagEntry(Entry entry) {
        ResValueMapArray mapArray = entry.getResValueMapArray();
        JSONWriter jsonWriter = this.mJsonWriter.object().key("qualifiers").value(entry.getResConfig().getQualifiers()).key("size").value(mapArray.childesCount()).key("parent").value(((ResTableMapEntry)entry.getTableEntry()).getParentId()).key("bag").array();
        for (ResValueMap resValueMap : (ResValueMap[])mapArray.getChildes()) {
            this.writeValueMap(resValueMap);
        }
        jsonWriter.endArray().endObject();
    }

    private void writeValueMap(ResValueMap resValueMap) {
        this.mJsonWriter.object().key("name").value(resValueMap.decodeName()).key("id").value(resValueMap.getNameResourceID()).key("value").value(InfoWriterJson.getValueAsString(resValueMap)).endObject();
    }

    @Override
    public void writePackageNames(Collection<PackageBlock> packageBlocks) throws IOException {
        if (packageBlocks == null || packageBlocks.size() == 0) {
            return;
        }
        JSONWriter jsonWriter = this.mJsonWriter.object().key("resource-packages").array();
        for (PackageBlock packageBlock : packageBlocks) {
            jsonWriter.object().key("id").value(packageBlock.getId()).key("name").value(packageBlock.getName()).endObject();
        }
        jsonWriter.endArray().endObject();
    }

    @Override
    public void writeEntries(String name, List<Entry> entryList) throws IOException {
        if (entryList == null || entryList.size() == 0) {
            return;
        }
        Entry first = entryList.get(0);
        JSONWriter jsonWriter = this.mJsonWriter.object().key("id").value(first.getResourceId()).key("type").value(first.getTypeName()).key("name").value(first.getName()).key("entries").array();
        for (Entry entry : entryList) {
            jsonWriter.object().key("config").value(entry.getResConfig().getQualifiers()).key("value").value(InfoWriterJson.getValueAsString(entry)).endObject();
        }
        jsonWriter.endArray().endObject();
    }

    @Override
    public void writeArray(String name, Object[] values) throws IOException {
        JSONWriter jsonWriter = this.mJsonWriter.object().key(name).array();
        for (Object value : values) {
            jsonWriter.value(value);
        }
        jsonWriter.endArray().endObject();
    }

    @Override
    public void writeNameValue(String name, Object value) throws IOException {
        this.mJsonWriter.object().key(name).value(value).endObject();
        this.getWriter().flush();
    }

    @Override
    public void flush() throws IOException {
        Writer writer = this.getWriter();
        this.mJsonWriter.endArray();
        writer.write("\n");
        writer.flush();
    }
}

