/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.info;

import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.coder.ValueCoder;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.group.EntryGroup;
import com.reandroid.arsc.util.HexUtil;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResValue;
import com.reandroid.arsc.value.Value;
import com.reandroid.arsc.value.ValueType;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public abstract class InfoWriter
implements Closeable {
    private final Writer writer;
    static final String TAG_RES_PACKAGES = "resource-packages";
    static final String TAG_PUBLIC = "public";
    static final String TAG_RESOURCES = "resources";
    static final String NAME_RESOURCE = "resource";
    static final String TAG_CONFIG = "config";
    static final String TAG_VALUE = "value";
    static final String TAG_BAG = "bag";
    static final String TAG_ITEM = "item";
    static final String NAME_QUALIFIERS = "qualifiers";

    public InfoWriter(Writer writer) {
        this.writer = writer;
    }

    public void writeResources(PackageBlock packageBlock, List<String> typeFilters, boolean writeEntries) throws IOException {
        List<EntryGroup> entryGroupList = InfoWriter.toSortedEntryGroups(packageBlock.listEntryGroup());
        for (EntryGroup entryGroup : entryGroupList) {
            this.writeResources(entryGroup, writeEntries);
        }
    }

    public abstract void writeResources(EntryGroup var1, boolean var2) throws IOException;

    public abstract void writePackageNames(Collection<PackageBlock> var1) throws IOException;

    public abstract void writeEntries(String var1, List<Entry> var2) throws IOException;

    public abstract void writeArray(String var1, Object[] var2) throws IOException;

    public abstract void writeNameValue(String var1, Object var2) throws IOException;

    public abstract void flush() throws IOException;

    boolean contains(SpecTypePair specTypePair, List<String> filterList) {
        if (filterList.size() == 0) {
            return true;
        }
        return filterList.contains(specTypePair.getTypeName());
    }

    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    static String toString(Object obj) {
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    static String getValueAsString(Entry entry) {
        ResValue resValue = entry.getResValue();
        if (resValue == null) {
            return "";
        }
        return InfoWriter.getValueAsString(resValue);
    }

    static String getValueAsString(Value value) {
        ValueType valueType = value.getValueType();
        if (valueType == ValueType.STRING) {
            return value.getValueAsString();
        }
        String decoded = ValueCoder.decode(valueType, value.getData());
        if (decoded != null) {
            return decoded;
        }
        if (valueType == ValueType.ATTRIBUTE) {
            return HexUtil.toHex8("?0x", value.getData());
        }
        if (valueType == ValueType.REFERENCE) {
            return HexUtil.toHex8("@0x", value.getData());
        }
        return HexUtil.toHex8("0x", value.getData());
    }

    static List<EntryGroup> toSortedEntryGroups(Collection<EntryGroup> entryGroups) {
        ArrayList<EntryGroup> results = new ArrayList<EntryGroup>(entryGroups);
        InfoWriter.sortEntryGroups(results);
        return results;
    }

    static void sortEntryGroups(List<EntryGroup> entryGroups) {
        Comparator<EntryGroup> cmp = new Comparator<EntryGroup>(){

            @Override
            public int compare(EntryGroup entryGroup1, EntryGroup entryGroup2) {
                long l1 = 0xFFFFFFFFL & (long)entryGroup1.getResourceId();
                long l2 = 0xFFFFFFFFL & (long)entryGroup2.getResourceId();
                return Long.compare(l1, l2);
            }
        };
        entryGroups.sort(cmp);
    }

    static List<Entry> sortEntries(Collection<Entry> entryCollection) {
        ArrayList<Entry> results = entryCollection instanceof ArrayList ? (ArrayList<Entry>)entryCollection : new ArrayList<Entry>(entryCollection);
        Comparator<Entry> cmp = new Comparator<Entry>(){

            @Override
            public int compare(Entry entry1, Entry entry2) {
                return entry1.getResConfig().compareTo(entry2.getResConfig());
            }
        };
        results.sort(cmp);
        return results;
    }
}

