/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.info;

import com.reandroid.apk.ApkModule;
import com.reandroid.apkeditor.BaseCommand;
import com.reandroid.apkeditor.Util;
import com.reandroid.apkeditor.info.InfoOptions;
import com.reandroid.apkeditor.info.InfoWriter;
import com.reandroid.apkeditor.info.InfoWriterJson;
import com.reandroid.apkeditor.info.InfoWriterText;
import com.reandroid.apkeditor.info.InfoWriterXml;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.xml.AndroidManifestBlock;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.coder.ReferenceString;
import com.reandroid.arsc.coder.ValueCoder;
import com.reandroid.arsc.group.EntryGroup;
import com.reandroid.arsc.util.HexUtil;
import com.reandroid.arsc.value.AttributeDataFormat;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResValue;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.commons.command.ARGException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class Info
extends BaseCommand {
    private final InfoOptions options;
    private InfoWriter mInfoWriter;
    public static final String ARG_SHORT = "info";
    public static final String DESCRIPTION = "Prints information of apk";
    private static final String LOG_TAG_INFO = "[INFO] ";

    public Info(InfoOptions options) {
        this.options = options;
        super.setLogTag(LOG_TAG_INFO);
        super.setEnableLog(options.outputFile != null);
    }

    @Override
    public void run() throws IOException {
        this.setEnableLog(this.options.outputFile != null);
        this.logMessage("Loading: " + this.options.inputFile);
        ApkModule apkModule = ApkModule.loadApkFile(this.options.inputFile);
        String msg = Util.isProtected(apkModule);
        if (msg != null) {
            this.logMessage(msg);
            return;
        }
        apkModule.setAPKLogger(this);
        apkModule.setLoadDefaultFramework(this.options.verbose);
        File out = this.options.outputFile;
        if (out != null) {
            this.logMessage("Writing ...");
        }
        this.print(apkModule);
        this.flush();
        this.close();
        if (out != null) {
            this.logMessage("Saved to: " + out);
        }
    }

    private void print(ApkModule apkModule) throws IOException {
        this.printSourceFile();
        this.printPackage(apkModule);
        AndroidManifestBlock manifest = apkModule.getAndroidManifestBlock();
        this.printVersionCode(manifest);
        this.printVersionName(manifest);
        this.printAppName(apkModule);
        this.printAppIcon(apkModule);
        this.printAppRoundIcon(apkModule);
        this.printAppClass(apkModule);
        this.printActivities(apkModule);
        this.printUsesPermissions(apkModule);
        this.printResList(apkModule);
        this.printResources(apkModule);
    }

    private void printSourceFile() throws IOException {
        if (this.options.outputFile == null) {
            return;
        }
        if (this.options.verbose || !this.options.resources) {
            this.getInfoWriter().writeNameValue("source-file", this.options.inputFile.getAbsolutePath());
        }
    }

    private void printResources(ApkModule apkModule) throws IOException {
        if (!this.options.resources) {
            return;
        }
        if (!apkModule.hasTableBlock()) {
            return;
        }
        TableBlock tableBlock = apkModule.getTableBlock();
        InfoWriter infoWriter = this.getInfoWriter();
        boolean writeEntries = this.options.verbose;
        for (PackageBlock packageBlock : tableBlock.listPackages()) {
            infoWriter.writeResources(packageBlock, this.options.typeFilterList, writeEntries);
        }
    }

    private void printResList(ApkModule apkModule) throws IOException {
        if (this.options.resList.size() == 0) {
            return;
        }
        if (!apkModule.hasTableBlock()) {
            return;
        }
        for (String res : this.options.resList) {
            this.printRes(apkModule, res);
        }
    }

    private void printRes(ApkModule apkModule, String res) throws IOException {
        EncodeResult encodeResult;
        if (res == null || res.length() < 3) {
            return;
        }
        if (res.startsWith("@0x")) {
            res = res.substring(1);
        }
        if ((encodeResult = ValueCoder.encode(res, AttributeDataFormat.INTEGER.valueTypes())) != null) {
            this.printEntries(apkModule, "resource", encodeResult.value);
            return;
        }
        ReferenceString referenceString = ReferenceString.parseReference(res);
        if (referenceString == null) {
            this.logWarn("WARN: Invalid resource: " + res);
            return;
        }
        TableBlock tableBlock = apkModule.getTableBlock();
        for (PackageBlock packageBlock : tableBlock.listPackages()) {
            EntryGroup entryGroup = packageBlock.getEntryGroup(referenceString.type, referenceString.name);
            if (entryGroup == null) continue;
            this.printEntries(apkModule, "resource", entryGroup.getResourceId());
            return;
        }
        this.logMessage("WARN: resource not found: " + res);
    }

    private void printPackage(ApkModule apkModule) throws IOException {
        if (!this.options.packageName) {
            return;
        }
        AndroidManifestBlock manifest = apkModule.getAndroidManifestBlock();
        if (manifest != null) {
            this.getInfoWriter().writeNameValue("package", manifest.getPackageName());
        }
        if (!this.options.verbose || !apkModule.hasTableBlock()) {
            return;
        }
        TableBlock tableBlock = apkModule.getTableBlock();
        InfoWriter infoWriter = this.getInfoWriter();
        infoWriter.writePackageNames(tableBlock.listPackages());
    }

    private void printVersionCode(AndroidManifestBlock manifest) throws IOException {
        if (!this.options.versionCode || manifest == null) {
            return;
        }
        this.getInfoWriter().writeNameValue("VersionCode", manifest.getVersionCode());
    }

    private void printVersionName(AndroidManifestBlock manifest) throws IOException {
        if (!this.options.versionName || manifest == null) {
            return;
        }
        this.getInfoWriter().writeNameValue("VersionName", manifest.getVersionName());
    }

    private void printAppName(ApkModule apkModule) throws IOException {
        if (!this.options.appName) {
            return;
        }
        AndroidManifestBlock manifest = apkModule.getAndroidManifestBlock();
        ResXmlElement application = manifest.getApplicationElement();
        ResXmlAttribute attributeLabel = application.searchAttributeByResourceId(0x1010001);
        if (attributeLabel == null) {
            return;
        }
        if (attributeLabel.getValueType() == ValueType.STRING) {
            this.getInfoWriter().writeNameValue("AppName", attributeLabel.getValueAsString());
            return;
        }
        int resourceId = attributeLabel.getData();
        this.printEntries(apkModule, "AppName", resourceId);
    }

    private void printAppIcon(ApkModule apkModule) throws IOException {
        if (!this.options.appIcon) {
            return;
        }
        AndroidManifestBlock manifest = apkModule.getAndroidManifestBlock();
        ResXmlElement application = manifest.getApplicationElement();
        ResXmlAttribute attribute = application.searchAttributeByResourceId(0x1010002);
        if (attribute == null) {
            return;
        }
        if (attribute.getValueType() == ValueType.STRING) {
            this.getInfoWriter().writeNameValue("AppIcon", attribute.getValueAsString());
            return;
        }
        int resourceId = attribute.getData();
        this.printEntries(apkModule, "AppIcon", resourceId);
    }

    private void printAppRoundIcon(ApkModule apkModule) throws IOException {
        int id_roundIcon;
        if (!this.options.appRoundIcon) {
            return;
        }
        AndroidManifestBlock manifest = apkModule.getAndroidManifestBlock();
        ResXmlElement application = manifest.getApplicationElement();
        ResXmlAttribute attribute = application.searchAttributeByResourceId(id_roundIcon = 16844076);
        if (attribute == null) {
            return;
        }
        if (attribute.getValueType() == ValueType.STRING) {
            this.getInfoWriter().writeNameValue("AppRoundIcon", attribute.getValueAsString());
            return;
        }
        int resourceId = attribute.getData();
        this.printEntries(apkModule, "AppRoundIcon", resourceId);
    }

    private void printUsesPermissions(ApkModule apkModule) throws IOException {
        if (!this.options.permissions || !this.options.verbose) {
            return;
        }
        AndroidManifestBlock manifest = apkModule.getAndroidManifestBlock();
        if (manifest == null) {
            return;
        }
        List<String> usesPermissions = manifest.getUsesPermissions();
        if (usesPermissions.size() == 0) {
            return;
        }
        String tag = "uses-permission";
        InfoWriter infoWriter = this.getInfoWriter();
        infoWriter.writeArray(tag, usesPermissions.toArray(new String[0]));
    }

    private void printActivities(ApkModule apkModule) throws IOException {
        if (!this.options.activities) {
            return;
        }
        AndroidManifestBlock manifest = apkModule.getAndroidManifestBlock();
        if (manifest == null) {
            return;
        }
        List<ResXmlElement> activityList = manifest.listActivities(true);
        if (activityList.size() == 0) {
            return;
        }
        ResXmlElement main = manifest.getMainActivity();
        if (main != null) {
            String value = this.getValueOfName(main);
            this.getInfoWriter().writeNameValue("activity-main", value);
        }
        if (!this.options.verbose) {
            return;
        }
        Object[] activityNames = new String[activityList.size()];
        for (int i = 0; i < activityList.size(); ++i) {
            ResXmlElement activity = activityList.get(i);
            activityNames[i] = this.getValueOfName(activity);
        }
        InfoWriter infoWriter = this.getInfoWriter();
        infoWriter.writeArray("activities", activityNames);
    }

    private void printAppClass(ApkModule apkModule) throws IOException {
        if (!this.options.appClass) {
            return;
        }
        AndroidManifestBlock manifest = apkModule.getAndroidManifestBlock();
        if (manifest == null) {
            return;
        }
        ResXmlElement applicationElement = manifest.getApplicationElement();
        if (applicationElement == null) {
            return;
        }
        String value = this.getValueOfName(applicationElement);
        if (value != null) {
            this.getInfoWriter().writeNameValue("application-class", value);
        }
    }

    private String getValueOfName(ResXmlElement element) {
        ResXmlAttribute attribute = element.searchAttributeByResourceId(0x1010003);
        if (attribute == null) {
            return null;
        }
        return attribute.getValueAsString();
    }

    private void printEntries(ApkModule apkModule, String varName, int resourceId) throws IOException {
        TableBlock tableBlock = apkModule.getTableBlock();
        InfoWriter infoWriter = this.getInfoWriter();
        if (tableBlock == null) {
            infoWriter.writeNameValue(varName, HexUtil.toHex8("@0x", resourceId));
            return;
        }
        List<Entry> entryList = tableBlock.resolveReference(resourceId);
        if (entryList.size() == 0) {
            this.logWarn("WARN: Can't find resource: " + HexUtil.toHex8("@0x", resourceId));
            return;
        }
        entryList = Info.sortEntries(entryList);
        if (!this.options.verbose) {
            infoWriter.writeNameValue(varName, this.getValueAsString(entryList.get(0)));
            return;
        }
        infoWriter.writeEntries(varName, entryList);
    }

    private String getValueAsString(Entry entry) {
        ResValue resValue = entry.getResValue();
        if (resValue == null) {
            return "";
        }
        ValueType valueType = resValue.getValueType();
        if (valueType == ValueType.STRING) {
            return resValue.getValueAsString();
        }
        String decoded = ValueCoder.decode(valueType, resValue.getData());
        if (decoded != null) {
            return decoded;
        }
        return HexUtil.toHex8("@0x", resValue.getData());
    }

    private InfoWriter getInfoWriter() throws IOException {
        if (this.mInfoWriter != null) {
            return this.mInfoWriter;
        }
        Writer writer = this.createWriter();
        InfoWriter infoWriter = "json".equals(this.options.type) ? new InfoWriterJson(writer) : ("xml".equals(this.options.type) ? new InfoWriterXml(writer) : new InfoWriterText(writer));
        this.mInfoWriter = infoWriter;
        return this.mInfoWriter;
    }

    private Writer createWriter() throws IOException {
        File file = this.options.outputFile;
        if (file == null) {
            return new PrintWriter(System.out);
        }
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        return new OutputStreamWriter(new FileOutputStream(file));
    }

    private void flush() throws IOException {
        InfoWriter writer = this.mInfoWriter;
        if (writer != null) {
            writer.flush();
        }
    }

    private void close() throws IOException {
        InfoWriter writer = this.mInfoWriter;
        if (writer != null) {
            writer.close();
            this.mInfoWriter = null;
        }
    }

    public static void execute(String[] args) throws ARGException, IOException {
        if (Util.isHelp(args)) {
            throw new ARGException(InfoOptions.getHelp());
        }
        InfoOptions option = new InfoOptions();
        option.parse(args);
        Info info = new Info(option);
        info.run();
    }

    private static List<Entry> sortEntries(Collection<Entry> entryCollection) {
        ArrayList<Entry> results = entryCollection instanceof ArrayList ? (ArrayList<Entry>)entryCollection : new ArrayList<Entry>(entryCollection);
        Comparator<Entry> cmp = new Comparator<Entry>(){

            @Override
            public int compare(Entry entry1, Entry entry2) {
                return entry1.getResConfig().compareTo(entry2.getResConfig());
            }
        };
        results.sort(cmp);
        return results;
    }

    public static boolean isCommand(String command) {
        if (Util.isEmpty(command)) {
            return false;
        }
        command = command.toLowerCase().trim();
        return command.equals(ARG_SHORT);
    }
}

