/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.decompile;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ApkModuleJsonDecoder;
import com.reandroid.apk.ApkModuleXmlDecoder;
import com.reandroid.apkeditor.Util;
import com.reandroid.apkeditor.decompile.DecompileOptions;
import com.reandroid.archive2.Archive;
import com.reandroid.archive2.block.ApkSignatureBlock;
import com.reandroid.commons.command.ARGException;
import com.reandroid.commons.utils.log.Logger;
import java.io.File;
import java.io.IOException;

public class Decompiler {
    private final DecompileOptions options;
    private APKLogger mApkLogger;
    public static final String ARG_SHORT = "d";
    public static final String ARG_LONG = "decode";
    public static final String DESCRIPTION = "Decodes android resources binary to readable json/xml";

    private Decompiler(DecompileOptions options) {
        this.options = options;
    }

    public void run() throws IOException {
        Decompiler.log("Loading ...");
        ApkModule apkModule = ApkModule.loadApkFile(this.options.inputFile);
        apkModule.setPreferredFramework(this.options.frameworkVersion);
        apkModule.setAPKLogger(this.getAPKLogger());
        if (this.options.signaturesDirectory != null) {
            this.dumpSignatureBlock();
            return;
        }
        String protect = Util.isProtected(apkModule);
        if (protect != null) {
            Decompiler.log(this.options.inputFile.getAbsolutePath());
            Decompiler.log(protect);
            return;
        }
        if (this.options.resDirName != null) {
            Decompiler.log("Renaming resources root dir: " + this.options.resDirName);
            apkModule.setResourcesRootDir(this.options.resDirName);
        }
        if (this.options.validateResDir) {
            Decompiler.log("Validating resources dir ...");
            apkModule.validateResourcesDir();
        }
        if ("json".equals(this.options.type)) {
            Decompiler.log("Decompiling to JSON ...");
            ApkModuleJsonDecoder decoder = new ApkModuleJsonDecoder(apkModule, this.options.splitJson);
            decoder.sanitizeFilePaths();
            decoder.decode(this.options.outputFile);
        } else {
            Decompiler.log("Decompiling to XML ...");
            ApkModuleXmlDecoder xmlDecoder = new ApkModuleXmlDecoder(apkModule);
            xmlDecoder.setKeepResPath(this.options.keepResPath);
            xmlDecoder.sanitizeFilePaths();
            try {
                xmlDecoder.decode(this.options.outputFile);
            }
            catch (Exception ex) {
                throw new IOException(ex.getMessage(), ex);
            }
        }
        Decompiler.log("Saved to: " + this.options.outputFile);
        Decompiler.log("Done");
    }

    private void dumpSignatureBlock() throws IOException {
        Decompiler.log("Dumping signature blocks ...");
        Archive archive = new Archive(this.options.inputFile);
        ApkSignatureBlock apkSignatureBlock = archive.getApkSignatureBlock();
        if (apkSignatureBlock == null) {
            Decompiler.log("Don't have signature block");
            return;
        }
        apkSignatureBlock.writeSplitRawToDirectory(this.options.signaturesDirectory);
        Decompiler.log("Signatures dumped to: " + this.options.signaturesDirectory);
    }

    private APKLogger getAPKLogger() {
        if (this.mApkLogger != null) {
            return this.mApkLogger;
        }
        this.mApkLogger = new APKLogger(){

            @Override
            public void logMessage(String msg) {
                Logger.i(Decompiler.getLogTag() + msg);
            }

            @Override
            public void logError(String msg, Throwable tr) {
                Logger.e(Decompiler.getLogTag() + msg, tr);
            }

            @Override
            public void logVerbose(String msg) {
                Logger.sameLine(Decompiler.getLogTag() + msg);
            }
        };
        return this.mApkLogger;
    }

    public static void execute(String[] args) throws ARGException, IOException {
        if (Util.isHelp(args)) {
            throw new ARGException(DecompileOptions.getHelp());
        }
        DecompileOptions option = new DecompileOptions();
        option.parse(args);
        Decompiler.log("Decompiling ...\n" + option);
        File outDir = option.signaturesDirectory != null ? option.signaturesDirectory : option.outputFile;
        Util.deleteEmptyDirectories(outDir);
        if (outDir.exists()) {
            if (!option.force) {
                throw new ARGException("Path already exists: " + outDir);
            }
            Decompiler.log("Deleting: " + outDir);
            Util.deleteDir(outDir);
        }
        Decompiler decompiler = new Decompiler(option);
        decompiler.run();
    }

    private static void log(String msg) {
        Logger.i(Decompiler.getLogTag() + msg);
    }

    private static String getLogTag() {
        return "[DECOMPILE] ";
    }

    public static boolean isCommand(String command) {
        if (Util.isEmpty(command)) {
            return false;
        }
        return (command = command.toLowerCase().trim()).equals(ARG_SHORT) || command.equals(ARG_LONG);
    }
}

