/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.decompile;

import com.reandroid.apkeditor.APKEditor;
import com.reandroid.apkeditor.Options;
import com.reandroid.apkeditor.utils.StringHelper;
import com.reandroid.commons.command.ARGException;
import java.io.File;

public class DecompileOptions
extends Options {
    public boolean splitJson;
    public boolean validateResDir;
    public String resDirName;
    public boolean keepResPath;
    private static final String ARG_split_resources = "-split-json";
    private static final String ARG_DESC_split_resources = "splits resources.arsc into multiple parts as per type entries (use this for large files)";
    private static final String ARG_DESC_type = "Decode types: \n  1) json \n  2) xml \n  3) sig \n default=xml";
    private static final String ARG_keep_res_path = "-keep-res-path";
    private static final String ARG_DESC_keep_res_path = "Keeps original res/* file paths:\n  *Applies only when decoding to xml\n  *All res/* files will be placed on dir <res-files>\n  *The relative paths will be linked to values/*xml";

    public DecompileOptions() {
        this.type = "xml";
    }

    @Override
    public void parse(String[] args) throws ARGException {
        this.parseInput(args);
        this.parseType(args, this.type);
        this.parseOutput(args);
        this.parseSplitResources(args);
        this.parseKeepResPath(args);
        this.parseResDirName(args);
        this.parseValidateResDir(args);
        this.parseSignaturesDir(args);
        if (this.signaturesDirectory == null && this.type == null) {
            this.type = "xml";
        }
        super.parse(args);
    }

    private void parseKeepResPath(String[] args) throws ARGException {
        this.keepResPath = this.containsArg(ARG_keep_res_path, true, args);
    }

    private void parseValidateResDir(String[] args) throws ARGException {
        this.validateResDir = this.containsArg("-vrd", true, args);
    }

    private void parseResDirName(String[] args) throws ARGException {
        this.resDirName = this.parseArgValue("-res-dir", true, args);
    }

    private void parseSplitResources(String[] args) throws ARGException {
        this.splitJson = this.containsArg(ARG_split_resources, true, args);
    }

    private void parseOutput(String[] args) throws ARGException {
        this.outputFile = null;
        File file = this.parseFile("-o", args);
        if (file == null) {
            file = this.getOutputFromInput(this.inputFile);
        }
        this.outputFile = file;
    }

    private File getOutputFromInput(File file) {
        String name = file.getName();
        int i = name.lastIndexOf(46);
        if (i > 0) {
            name = name.substring(0, i);
        }
        name = name + "_decompile_" + this.type;
        File dir = file.getParentFile();
        if (dir == null) {
            return new File(name);
        }
        return new File(dir, name);
    }

    private void parseInput(String[] args) throws ARGException {
        this.inputFile = null;
        File file = this.parseFile("-i", args);
        if (file == null) {
            throw new ARGException("Missing input file");
        }
        if (!file.isFile()) {
            throw new ARGException("No such file: " + file);
        }
        this.inputFile = file;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("   Input: ").append(this.inputFile);
        File out = this.signaturesDirectory != null ? this.signaturesDirectory : this.outputFile;
        builder.append("\n Output: ").append(out);
        if (this.resDirName != null) {
            builder.append("\nres dir: ").append(this.resDirName);
        }
        if (this.validateResDir) {
            builder.append("\n Validate res dir name: true");
        }
        if (this.force) {
            builder.append("\n Force: true");
        }
        if (this.keepResPath) {
            builder.append("\n Keep res path: true");
        }
        if (this.frameworkVersion != null) {
            builder.append("\nframework: ").append(this.frameworkVersion);
        }
        builder.append("\n Type: ").append(this.type);
        if (!"xml".equals(this.type) && this.signaturesDirectory == null) {
            builder.append("\n Split: ").append(this.splitJson);
        }
        builder.append("\n ---------------------------- ");
        return builder.toString();
    }

    public static String getHelp() {
        StringBuilder builder = new StringBuilder();
        builder.append("Decodes android resources binary to readable json/xml");
        builder.append("\nOptions:\n");
        String[][] table = new String[][]{{"-i", "input path"}, {"-o", "output path"}, {"-framework-version", "preferred framework version number"}, {"-sig", "signatures directory path"}, {"-t", ARG_DESC_type}, {"-res-dir", "sets resource files root dir name\n(eg. for obfuscation to move files from 'res/*' to 'r/*' or vice versa)"}};
        StringHelper.printTwoColumns(builder, "   ", 75, table);
        builder.append("\nFlags:\n");
        table = new String[][]{{"-f", "force delete output path"}, {ARG_keep_res_path, ARG_DESC_keep_res_path}, {ARG_split_resources, ARG_DESC_split_resources}, {"-vrd", "validate resources dir name\n(eg. if a drawable resource file path is 'res/abc.png' then\nit will be moved to 'res/drawable/abc.png')"}};
        StringHelper.printTwoColumns(builder, "   ", 75, table);
        String jar = APKEditor.getJarName();
        builder.append("\n\nExample-1:");
        builder.append("\n   java -jar ").append(jar).append(" ").append("b").append(" ").append("-i").append(" path/to/input.apk");
        builder.append(" ").append("-o").append(" path/to/out_dir");
        builder.append("\nExample-2:");
        builder.append("\n   java -jar ").append(jar).append(" ").append("b").append(" ").append("-i").append(" path/to/input.apk");
        builder.append("\nExample-3:");
        builder.append("\n   java -jar ").append(jar).append(" ").append("b").append(" ").append("-i").append(" path/to/input.apk").append(" ").append(ARG_split_resources);
        builder.append("\nExample-4: (XML)");
        builder.append("\n   java -jar ").append(jar).append(" ").append("b").append(" ").append("-t").append(" ").append("xml").append(" ").append("-i").append(" path/to/input.apk");
        builder.append("\nExample-5: (signatures)");
        builder.append("\n   java -jar ").append(jar).append(" ").append("b").append(" ").append("-t").append(" ").append("sig").append(" ").append("-i").append(" path/to/input.apk").append(" ").append("-sig").append(" path/to/signatures_dir");
        return builder.toString();
    }
}

