/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.compile;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ApkModuleJsonEncoder;
import com.reandroid.apk.ApkModuleXmlEncoder;
import com.reandroid.apkeditor.Util;
import com.reandroid.apkeditor.compile.BuildOptions;
import com.reandroid.archive.WriteProgress;
import com.reandroid.archive2.Archive;
import com.reandroid.archive2.block.ApkSignatureBlock;
import com.reandroid.archive2.writer.ApkWriter;
import com.reandroid.commons.command.ARGException;
import com.reandroid.commons.utils.log.Logger;
import java.io.File;
import java.io.IOException;

public class Builder
implements WriteProgress {
    private final BuildOptions options;
    private APKLogger mApkLogger;
    public static final String ARG_SHORT = "b";
    public static final String ARG_LONG = "build";
    public static final String DESCRIPTION = "Builds android binary from json/xml";

    public Builder(BuildOptions options) {
        this.options = options;
    }

    public void run() throws IOException {
        if (this.options.signaturesDirectory != null && this.options.inputFile.isFile()) {
            this.restoreSignatures();
            return;
        }
        if (this.options.isXml) {
            this.buildXml();
        } else {
            this.buildJson();
        }
    }

    private void restoreSignatures() throws IOException {
        Builder.log("Restoring signatures ...");
        Archive archive = new Archive(this.options.inputFile);
        ApkWriter apkWriter = new ApkWriter(this.options.outputFile, archive.mapEntrySource().values());
        apkWriter.setAPKLogger(this.getAPKLogger());
        ApkSignatureBlock apkSignatureBlock = new ApkSignatureBlock();
        apkSignatureBlock.scanSplitFiles(this.options.signaturesDirectory);
        apkWriter.setApkSignatureBlock(apkSignatureBlock);
        Builder.log("Writing apk...");
        apkWriter.write();
        Builder.log("Built to: " + this.options.outputFile);
        Builder.log("Done");
    }

    public void buildJson() throws IOException {
        Builder.log("Scanning JSON directory ...");
        ApkModuleJsonEncoder encoder = new ApkModuleJsonEncoder();
        encoder.setApkLogger(this.getAPKLogger());
        encoder.scanDirectory(this.options.inputFile);
        ApkModule loadedModule = encoder.getApkModule();
        loadedModule.setAPKLogger(this.getAPKLogger());
        if (this.options.resDirName != null) {
            Builder.log("Renaming resources root dir: " + this.options.resDirName);
            loadedModule.setResourcesRootDir(this.options.resDirName);
        }
        if (this.options.validateResDir) {
            Builder.log("Validating resources dir ...");
            loadedModule.validateResourcesDir();
        }
        Builder.log("Writing apk...");
        loadedModule.getApkArchive().autoSortApkFiles();
        loadedModule.writeApk(this.options.outputFile, this);
        Builder.log("Built to: " + this.options.outputFile);
        Builder.log("Done");
    }

    public void buildXml() throws IOException {
        Builder.log("Scanning XML directory ...");
        ApkModuleXmlEncoder encoder = new ApkModuleXmlEncoder();
        encoder.setApkLogger(this.getAPKLogger());
        ApkModule loadedModule = encoder.getApkModule();
        loadedModule.setPreferredFramework(this.options.frameworkVersion);
        encoder.scanDirectory(this.options.inputFile);
        loadedModule = encoder.getApkModule();
        Builder.log("Writing apk...");
        loadedModule.writeApk(this.options.outputFile, null);
        Builder.log("Built to: " + this.options.outputFile);
        Builder.log("Done");
    }

    private APKLogger getAPKLogger() {
        if (this.mApkLogger != null) {
            return this.mApkLogger;
        }
        this.mApkLogger = new APKLogger(){

            @Override
            public void logMessage(String msg) {
                Logger.i(Builder.getLogTag() + msg);
            }

            @Override
            public void logError(String msg, Throwable tr) {
                Logger.e(Builder.getLogTag() + msg, tr);
            }

            @Override
            public void logVerbose(String msg) {
                if (msg.length() > 50) {
                    msg = msg.substring(msg.length() - 50);
                }
                Logger.sameLine(Builder.getLogTag() + msg);
            }
        };
        return this.mApkLogger;
    }

    @Override
    public void onCompressFile(String path, int method, long length) {
        StringBuilder builder = new StringBuilder();
        builder.append("Writing:");
        if (path.length() > 30) {
            path = path.substring(path.length() - 30);
        }
        builder.append(path);
        Builder.logSameLine(builder.toString());
    }

    public static void execute(String[] args) throws ARGException, IOException {
        if (Util.isHelp(args)) {
            throw new ARGException(BuildOptions.getHelp());
        }
        BuildOptions option = new BuildOptions();
        option.parse(args);
        if (Builder.isJsonInDir(option.inputFile)) {
            option.inputFile = Builder.getJsonInDir(option.inputFile);
        } else if (Builder.isXmlInDir(option.inputFile)) {
            option.isXml = true;
        } else if (option.signaturesDirectory == null) {
            throw new ARGException("Not xml/json directory: " + option.inputFile);
        }
        File outDir = option.outputFile;
        Util.deleteEmptyDirectories(outDir);
        if (outDir.exists()) {
            if (!option.force) {
                throw new ARGException("Path already exists: " + outDir);
            }
            Builder.log("Deleting: " + outDir);
            Util.deleteDir(outDir);
        }
        Builder.log("Building ...\n" + option);
        Builder builder = new Builder(option);
        builder.run();
    }

    private static boolean isXmlInDir(File dir) {
        File manifest = new File(dir, "AndroidManifest.xml");
        if (!manifest.isFile()) {
            manifest = new File(dir, "AndroidManifest.xml.bin");
        }
        return manifest.isFile();
    }

    private static boolean isJsonInDir(File dir) {
        if (Builder.isModuleDir(dir)) {
            return true;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return false;
        }
        for (File file : files) {
            if (!Builder.isModuleDir(file)) continue;
            return true;
        }
        return false;
    }

    private static File getJsonInDir(File dir) throws ARGException {
        if (Builder.isModuleDir(dir)) {
            return dir;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            throw new ARGException("Empty directory: " + dir);
        }
        for (File file : files) {
            if (!Builder.isModuleDir(file)) continue;
            return file;
        }
        throw new ARGException("Invalid directory: " + dir + ", missing file \"uncompressed-files.json\"");
    }

    private static boolean isModuleDir(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        File manifest = new File(dir, "AndroidManifest.xml.json");
        if (manifest.isFile()) {
            return true;
        }
        File file = new File(dir, "AndroidManifest.xml.json");
        return file.isFile();
    }

    private static void logSameLine(String msg) {
        Logger.sameLine(Builder.getLogTag() + msg);
    }

    private static void log(String msg) {
        Logger.i(Builder.getLogTag() + msg);
    }

    private static String getLogTag() {
        return "[BUILD] ";
    }

    public static boolean isCommand(String command) {
        if (Util.isEmpty(command)) {
            return false;
        }
        return (command = command.toLowerCase().trim()).equals(ARG_SHORT) || command.equals(ARG_LONG);
    }
}

