/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.compile;

import com.reandroid.apkeditor.APKEditor;
import com.reandroid.apkeditor.Options;
import com.reandroid.apkeditor.utils.StringHelper;
import com.reandroid.commons.command.ARGException;
import java.io.File;

public class BuildOptions
extends Options {
    public boolean validateResDir;
    public String resDirName;
    public boolean isXml;

    @Override
    public void parse(String[] args) throws ARGException {
        this.parseInput(args);
        this.parseOutput(args);
        this.parseResDirName(args);
        this.parseValidateResDir(args);
        this.parseSignaturesDir(args);
        this.parseType(args);
        if ("sig".equals(this.type)) {
            if (this.signaturesDirectory == null) {
                throw new ARGException("Signatures directory missing! -sig path/to/signatures_dir");
            }
            if (!this.signaturesDirectory.isDirectory()) {
                throw new ARGException("No such directory: " + this.signaturesDirectory);
            }
            if (!this.inputFile.isFile()) {
                throw new ARGException("Missing apk file: " + this.inputFile);
            }
        } else if (this.signaturesDirectory != null) {
            throw new ARGException("Invalid parameter combination! \nSignatures directory provided but missing: -t sig");
        }
        super.parse(args);
    }

    private void parseValidateResDir(String[] args) throws ARGException {
        this.validateResDir = this.containsArg("-vrd", true, args);
    }

    private void parseResDirName(String[] args) throws ARGException {
        this.resDirName = this.parseArgValue("-res-dir", true, args);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("   Input: ").append(this.inputFile);
        builder.append("\n Output: ").append(this.outputFile);
        if (this.resDirName != null) {
            builder.append("\nres dir: ").append(this.resDirName);
        }
        if (this.validateResDir) {
            builder.append("\n Validate res dir name: true");
        }
        if (this.force) {
            builder.append("\n Force: true");
        }
        if (this.frameworkVersion != null) {
            builder.append("\nframework: ").append(this.frameworkVersion);
        }
        builder.append("\n ---------------------------- ");
        return builder.toString();
    }

    private void parseOutput(String[] args) throws ARGException {
        this.outputFile = null;
        File file = this.parseFile("-o", args);
        if (file == null) {
            file = this.getOutputApkFromInput(this.inputFile);
        }
        this.outputFile = file;
    }

    private File getOutputApkFromInput(File file) {
        String name = file.getName();
        name = name + "_out.apk";
        File dir = file.getParentFile();
        if (dir == null) {
            return new File(name);
        }
        return new File(dir, name);
    }

    private void parseInput(String[] args) throws ARGException {
        this.inputFile = null;
        File file = this.parseFile("-i", args);
        if (file == null) {
            throw new ARGException("Missing input directory");
        }
        if (!file.exists()) {
            throw new ARGException("No such file/directory: " + file);
        }
        this.inputFile = file;
    }

    public static String getHelp() {
        StringBuilder builder = new StringBuilder();
        builder.append("Builds android binary from json/xml");
        builder.append("\nOptions:\n");
        String[][] table = new String[][]{{"-i", "input path"}, {"-o", "output path"}, {"-framework-version", "preferred framework version number"}, {"-sig", "signatures directory path"}, {"-res-dir", "sets resource files root dir name\n(eg. for obfuscation to move files from 'res/*' to 'r/*' or vice versa)"}};
        StringHelper.printTwoColumns(builder, "   ", 75, table);
        builder.append("\nFlags:\n");
        table = new String[][]{{"-f", "force delete output path"}, {"-vrd", "validate resources dir name\n(eg. if a drawable resource file path is 'res/abc.png' then\nit will be moved to 'res/drawable/abc.png')"}};
        StringHelper.printTwoColumns(builder, "   ", 75, table);
        String jar = APKEditor.getJarName();
        builder.append("\n\nExample-1:");
        builder.append("\n   java -jar ").append(jar).append(" ").append("b").append(" ").append("-i").append(" path/to/input_dir");
        builder.append(" ").append("-o").append(" path/to/out.apk");
        builder.append("\nExample-2:");
        builder.append("\n   java -jar ").append(jar).append(" ").append("b").append(" ").append("-i").append(" path/to/input_dir");
        builder.append("\nExample-3 (restore signatures):");
        builder.append("\n   java -jar ").append(jar).append(" ").append("b").append(" ").append("-t").append(" ").append("sig").append(" ").append("-i").append(" path/to/input.apk").append(" ").append("-sig").append(" path/to/signatures_dir");
        return builder.toString();
    }
}

