/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.common;

import com.reandroid.arsc.chunk.xml.AndroidManifestBlock;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.value.ValueType;
import java.util.ArrayList;
import java.util.List;

public class AndroidManifestHelper {
    public static List<ResXmlElement> listSplitRequired(ResXmlElement parentElement) {
        ArrayList<ResXmlElement> results = new ArrayList<ResXmlElement>();
        if (parentElement == null) {
            return results;
        }
        List<ResXmlElement> metaDataList = parentElement.listElements("meta-data");
        for (ResXmlElement metaData : metaDataList) {
            String value;
            ResXmlAttribute nameAttribute = metaData.searchAttributeByResourceId(0x1010003);
            if (nameAttribute == null || nameAttribute.getValueType() != ValueType.STRING || !(value = nameAttribute.getValueAsString()).startsWith("com.android.vending.") && !value.startsWith("com.android.stamp.")) continue;
            results.add(metaData);
        }
        return results;
    }

    public static boolean removeApplicationAttribute(AndroidManifestBlock manifest, int resId) {
        ResXmlElement applicationElement = manifest.getApplicationElement();
        if (applicationElement == null) {
            return true;
        }
        ResXmlAttribute attribute = applicationElement.searchAttributeByResourceId(resId);
        if (attribute == null) {
            return false;
        }
        applicationElement.removeAttribute(attribute);
        return true;
    }
}

