/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.cloner;

import com.reandroid.apkeditor.APKEditor;
import com.reandroid.apkeditor.Options;
import com.reandroid.apkeditor.Util;
import com.reandroid.apkeditor.utils.StringHelper;
import com.reandroid.commons.command.ARGException;
import java.io.File;

public class ClonerOptions
extends Options {
    public String packageName;
    public String appName;
    public String appIcon;
    public boolean keepAuth;
    private static final String ARG_package = "-package";
    private static final String ARG_DESC_package = "Package name.";
    private static final String ARG_app_name = "-app-name";
    private static final String ARG_DESC_app_name = "Application name.";
    private static final String ARG_app_icon = "-app-icon";
    private static final String ARG_DESC_app_icon = "Application icon. File path of app icon(s).";
    private static final String ARG_keep_auth = "-keep-auth";
    private static final String ARG_DESC_keep_auth = "Do not rename authorities as per package. \n  *Applies only when option -package used.";

    @Override
    public void parse(String[] args) throws ARGException {
        this.parseInput(args);
        this.packageName = this.parseArgValue(ARG_package, args);
        this.appName = this.parseArgValue(ARG_app_name, args);
        this.appIcon = this.parseArgValue(ARG_app_icon, args);
        this.keepAuth = this.containsArg(ARG_app_icon, args);
        this.parseHelp(args);
        this.checkUnknownOptions(args);
    }

    private void parseInput(String[] args) throws ARGException {
        this.inputFile = null;
        File file = this.parseFile("-i", args);
        if (file == null) {
            throw new ARGException("Missing input apk! Specify with  -i");
        }
        if (!file.isFile()) {
            throw new ARGException("No such file: " + file);
        }
        this.inputFile = file;
    }

    private void parseHelp(String[] args) throws ARGException {
        if (!Util.containsHelp(args)) {
            return;
        }
        throw new ARGException(ClonerOptions.getHelp());
    }

    public static String getHelp() {
        StringBuilder builder = new StringBuilder();
        builder.append("Clones apk");
        builder.append("\nOptions:\n");
        String[][] table = new String[][]{{"-i", "input path"}, {"-o", "output path"}, {ARG_package, ARG_DESC_package}, {ARG_app_name, ARG_DESC_app_name}, {ARG_app_icon, ARG_DESC_app_icon}};
        StringHelper.printTwoColumns(builder, "   ", 75, table);
        builder.append("\n\nFlags:\n");
        table = new String[][]{{ARG_keep_auth, ARG_DESC_keep_auth}, {"  ", "  "}, {"-h|-help", "Prints this help"}};
        StringHelper.printTwoColumns(builder, "   ", 75, table);
        builder.append("\n").append("    ------------------------------------------------------------------------");
        String jar = APKEditor.getJarName();
        builder.append("\n\nExample-1:");
        builder.append("\n   java -jar ").append(jar).append(" ").append("c").append(" ").append("-i").append(" file.apk");
        return builder.toString();
    }
}

