/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.advanced;

import com.reandroid.apkeditor.Options;
import com.reandroid.apkeditor.utils.StringHelper;
import com.reandroid.commons.command.ARGException;
import java.io.File;

public class AdvancedOptions
extends Options {
    public String packageName;
    public String packageNameManifest;
    public String packageNameTable;
    protected static final String ARG_DESC_input = "input path to apk|xml|arsc";
    private static final String ARG_package_name = "-package-name";
    private static final String ARG_DESC_package_name = "Sets package name on both manifest and table";
    private static final String ARG_package_name_manifest = "-package-name-manifest";
    private static final String ARG_DESC_package_name_manifest = "Sets package name on manifest";
    private static final String ARG_package_name_table = "-package-name-table";
    private static final String ARG_DESC_package_name_table = "Sets package name on table";

    @Override
    public void parse(String[] args) throws ARGException {
        this.parseInput(args);
        this.parseOutput(args);
        this.parsePackage(args);
        super.parse(args);
    }

    private void parseOutput(String[] args) throws ARGException {
        this.outputFile = this.parseFile("-o", args);
    }

    private void parseInput(String[] args) throws ARGException {
        this.inputFile = null;
        File file = this.parseFile("-i", args);
        if (file == null) {
            throw new ARGException("Missing input file");
        }
        if (!file.exists()) {
            throw new ARGException("No such file or directory: " + file);
        }
        this.inputFile = file;
    }

    private void parsePackage(String[] args) throws ARGException {
        this.packageName = this.parseArgValue(ARG_package_name, args);
        this.packageNameManifest = this.parseArgValue(ARG_package_name_manifest, args);
        if (this.packageNameManifest == null) {
            this.packageNameManifest = this.packageName;
        }
        this.packageNameTable = this.parseArgValue(ARG_package_name_table, args);
        if (this.packageNameTable == null) {
            this.packageNameTable = this.packageName;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Object[][] table = new Object[][]{{"*************OPTIONS", "*******************"}, {"--------------------", "----------------------------------"}, {"Input: ", this.inputFile}, {"Output: ", this.outputFile}, {"Package name: ", this.packageName}, {"Package name manifest: ", this.packageNameManifest}, {"Package name table: ", this.packageNameTable}, {"-------------", "------------------"}};
        StringHelper.printNameAndValues(builder, "", 75, table);
        return builder.toString();
    }

    public static String getHelp() {
        StringBuilder builder = new StringBuilder();
        builder.append("Advanced");
        builder.append("\nOptions:\n");
        String[][] table = new String[][]{{"-i", ARG_DESC_input}, {"-o", "output path"}, {ARG_package_name_manifest, ARG_DESC_package_name_manifest}, {ARG_package_name_table, ARG_DESC_package_name_table}, {ARG_package_name, ARG_DESC_package_name}};
        StringHelper.printTwoColumns(builder, "   ", 75, table);
        builder.append("\nFlags:\n");
        table = new String[][]{{"-f", "force delete output path"}, {"-vrd", "validate resources dir name\n(eg. if a drawable resource file path is 'res/abc.png' then\nit will be moved to 'res/drawable/abc.png')"}};
        StringHelper.printTwoColumns(builder, "   ", 75, table);
        return builder.toString();
    }

    static File getOutputFromInput(File file) {
        String name = file.getName();
        int i = name.lastIndexOf(46);
        if (i > 0) {
            name = name.substring(0, i);
        }
        name = name + "_edited.apk";
        File dir = file.getParentFile();
        if (dir == null) {
            return new File(name);
        }
        return new File(dir, name);
    }
}

