/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.advanced;

import com.reandroid.apk.APKLogger;
import com.reandroid.apkeditor.Util;
import com.reandroid.apkeditor.advanced.AdvancedOptions;
import com.reandroid.apkeditor.decompile.DecompileOptions;
import com.reandroid.commons.command.ARGException;
import com.reandroid.commons.utils.log.Logger;
import java.io.File;
import java.io.IOException;

public class Advanced {
    private final AdvancedOptions options;
    private APKLogger mApkLogger;
    public static final String ARG_SHORT = "a";
    public static final String ARG_LONG = "advanced";
    public static final String DESCRIPTION = "Advanced";

    private Advanced(AdvancedOptions options) {
        this.options = options;
    }

    public void run() throws IOException {
    }

    private APKLogger getAPKLogger() {
        if (this.mApkLogger != null) {
            return this.mApkLogger;
        }
        this.mApkLogger = new APKLogger(){

            @Override
            public void logMessage(String msg) {
                Logger.i(Advanced.getLogTag() + msg);
            }

            @Override
            public void logError(String msg, Throwable tr) {
                Logger.e(Advanced.getLogTag() + msg, tr);
            }

            @Override
            public void logVerbose(String msg) {
                Logger.sameLine(Advanced.getLogTag() + msg);
            }
        };
        return this.mApkLogger;
    }

    public static void execute(String[] args) throws ARGException, IOException {
        if (Util.isHelp(args)) {
            throw new ARGException(DecompileOptions.getHelp());
        }
        AdvancedOptions option = new AdvancedOptions();
        option.parse(args);
        Advanced.log("Decompiling ...\n" + option);
        File outDir = option.outputFile;
        Util.deleteEmptyDirectories(outDir);
        if (outDir.exists()) {
            if (!option.force) {
                throw new ARGException("Path already exists: " + outDir);
            }
            Advanced.log("Deleting: " + outDir);
            Util.deleteDir(outDir);
        }
        Advanced advanced = new Advanced(option);
        advanced.run();
    }

    private static void log(String msg) {
        Logger.i(Advanced.getLogTag() + msg);
    }

    private static String getLogTag() {
        return "[ADVANCED] ";
    }

    public static boolean isCommand(String command) {
        if (Util.isEmpty(command)) {
            return false;
        }
        return (command = command.toLowerCase().trim()).equals(ARG_SHORT) || command.equals(ARG_LONG);
    }
}

