/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor;

import com.reandroid.apk.ApkModule;
import com.reandroid.apkeditor.APKEditor;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.TableString;
import com.reandroid.arsc.pool.TableStringPool;
import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Properties;

public class Util {
    public static final String EDIT_TYPE_PROTECTED = "PROTECTED";

    public static boolean isHelp(String[] args) {
        if (Util.isEmpty(args)) {
            return true;
        }
        return Util.isHelp(args[0]);
    }

    public static boolean containsHelp(String[] args) {
        if (Util.isEmpty(args)) {
            return false;
        }
        for (String command : args) {
            if (!Util.isHelp(command)) continue;
            return true;
        }
        return false;
    }

    public static boolean isHelp(String command) {
        if (Util.isEmpty(command)) {
            return false;
        }
        return (command = command.toLowerCase().trim()).equals("-h") || command.equals("-help") || command.equals("--h") || command.equals("--help");
    }

    public static String[] trimNull(String[] args) {
        if (Util.isEmpty(args)) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        for (String str : args) {
            if (Util.isEmpty(str)) continue;
            results.add(str);
        }
        return results.toArray(new String[0]);
    }

    public static boolean isEmpty(String[] args) {
        if (args == null || args.length == 0) {
            return true;
        }
        for (String s : args) {
            if (Util.isEmpty(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        return (str = str.trim()).length() == 0;
    }

    public static void deleteDir(File dir) {
        if (!dir.exists()) {
            return;
        }
        if (dir.isFile()) {
            dir.delete();
            return;
        }
        if (!dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            Util.deleteEmptyDirectories(dir);
            return;
        }
        for (File file : files) {
            Util.deleteDir(file);
        }
        Util.deleteEmptyDirectories(dir);
    }

    public static void deleteEmptyDirectories(File dir) {
        if (dir == null || !dir.isDirectory()) {
            return;
        }
        File[] allFiles = dir.listFiles();
        if (allFiles == null || allFiles.length == 0) {
            dir.delete();
            return;
        }
        for (File file : allFiles) {
            if (!file.isDirectory()) continue;
            Util.deleteEmptyDirectories(file);
        }
        allFiles = dir.listFiles();
        if (allFiles == null || allFiles.length == 0) {
            dir.delete();
        }
    }

    public static String isProtected(ApkModule apkModule) {
        Properties properties = null;
        try {
            TableBlock tableBlock = apkModule.getTableBlock();
            String str = Util.loadApkEditorProperties(tableBlock);
            properties = Util.loadApkEditorProperties(str);
        }
        catch (Exception tableBlock) {
            // empty catch block
        }
        if (properties == null) {
            return null;
        }
        String protect = properties.getProperty("EDIT_TYPE", null);
        if (protect == null || !protect.contains(EDIT_TYPE_PROTECTED)) {
            return null;
        }
        return protect;
    }

    private static String loadApkEditorProperties(TableBlock tableBlock) {
        if (tableBlock == null) {
            return null;
        }
        TableStringPool stringPool = tableBlock.getTableStringPool();
        int count = stringPool.countStrings();
        TableString tableString = (TableString)stringPool.get(count - 1);
        return Util.loadApkEditorProperties(tableString);
    }

    private static String loadApkEditorProperties(TableString tableString) {
        if (tableString == null) {
            return null;
        }
        String str = tableString.get();
        if (str == null || !str.contains("REPO=") || !str.contains(APKEditor.getRepo())) {
            return null;
        }
        return str;
    }

    private static Properties loadApkEditorProperties(String str) {
        if (str == null || !str.contains("REPO=") || !str.contains(APKEditor.getRepo())) {
            return null;
        }
        try {
            Properties properties = new Properties();
            properties.load(new StringReader(str));
            return properties;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void addApkEditorInfo(ApkModule apkModule, String type) {
        try {
            Util.addApkEditorInfo(apkModule.getTableBlock(), type);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addApkEditorInfo(TableBlock tableBlock, String type) {
        if (tableBlock == null) {
            return;
        }
        TableStringPool stringPool = tableBlock.getTableStringPool();
        int count = stringPool.countStrings();
        if (count == 0) {
            return;
        }
        TableString tableString = (TableString)stringPool.get(count - 1);
        if (!Util.isApkEditorInfo(tableString)) {
            stringPool.getStringsArray().ensureSize(count + 1);
            tableString = (TableString)stringPool.get(count);
        }
        tableString.set(Util.buildApkEditorInfo(type));
        IntegerItem dummyReference = new IntegerItem();
        dummyReference.set(tableString.getIndex());
        tableString.addReference(dummyReference);
    }

    private static String buildApkEditorInfo(String type) {
        StringBuilder builder = new StringBuilder();
        builder.append("NAME=").append(APKEditor.getName());
        builder.append("\nVERSION=").append(APKEditor.getVersion());
        builder.append("\nREPO=").append(APKEditor.getRepo());
        builder.append("\nEDIT_TYPE=").append(type);
        builder.append("\nTIME=").append(System.currentTimeMillis());
        return builder.toString();
    }

    private static boolean isApkEditorInfo(TableString tableString) {
        if (tableString == null) {
            return false;
        }
        String str = tableString.getHtml();
        if (str == null) {
            return false;
        }
        return str.contains("REPO=") && str.contains(APKEditor.getRepo());
    }
}

