/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor;

import com.reandroid.apk.xmlencoder.EncodeException;
import com.reandroid.apkeditor.APKEditor;
import com.reandroid.apkeditor.Util;
import com.reandroid.apkeditor.cloner.Cloner;
import com.reandroid.apkeditor.compile.Builder;
import com.reandroid.apkeditor.decompile.Decompiler;
import com.reandroid.apkeditor.info.Info;
import com.reandroid.apkeditor.merge.Merger;
import com.reandroid.apkeditor.protect.Protector;
import com.reandroid.apkeditor.refactor.Refactor;
import com.reandroid.apkeditor.utils.StringHelper;
import com.reandroid.commons.command.ARGException;
import java.io.IOException;

public class Main {
    public static void main(String[] args) {
        if (Util.isHelp(args = Util.trimNull(args))) {
            System.err.println(Main.getHelp());
            return;
        }
        String command = Main.getCommand(args);
        args = Util.trimNull(args);
        try {
            Main.execute(command, args);
        }
        catch (ARGException ex1) {
            System.err.flush();
            System.err.println(ex1.getMessage());
            System.exit(1);
        }
        catch (EncodeException ex) {
            System.err.flush();
            System.err.println("\nERROR:\n" + ex.getMessage());
            System.exit(1);
        }
        catch (IOException ex2) {
            System.err.flush();
            System.err.println("\nERROR:\n" + ex2.getMessage());
            ex2.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception ex3) {
            System.err.flush();
            System.err.println("\nUnexpected error:\n" + ex3.getMessage());
            ex3.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private static void execute(String command, String[] args) throws ARGException, IOException {
        if (Decompiler.isCommand(command)) {
            Decompiler.execute(args);
            return;
        }
        if (Builder.isCommand(command)) {
            Builder.execute(args);
            return;
        }
        if (Merger.isCommand(command)) {
            Merger.execute(args);
            return;
        }
        if (Refactor.isCommand(command)) {
            Refactor.execute(args);
            return;
        }
        if (Protector.isCommand(command)) {
            Protector.execute(args);
            return;
        }
        if (Cloner.isCommand(command)) {
            Cloner.execute(args);
            return;
        }
        if (Info.isCommand(command)) {
            Info.execute(args);
            return;
        }
        throw new ARGException("Unknown command: " + command);
    }

    private static String getHelp() {
        StringBuilder builder = new StringBuilder();
        builder.append(Main.getWelcome());
        builder.append("\nUsage: \n");
        builder.append(" java -jar ").append(APKEditor.getJarName());
        builder.append(" <command> <args>");
        builder.append("\n commands: \n");
        String[][] table = new String[][]{{"  1)  d | decode", "Decodes android resources binary to readable json/xml"}, {"  2)  b | build", "Builds android binary from json/xml"}, {"  3)  m | merge", "Merges split apk files from directory or compressed apk files like XAPK, APKM, APKS ..."}, {"  4)  x | refactor", "Refactors obfuscated resource names"}, {"  5)  p | protect", "Protects/Obfuscates apk resource"}, {"  6)  info", "Prints information of apk"}};
        StringHelper.printTwoColumns(builder, "  ", "  -  ", 75, table);
        builder.append("\n\n run with <command> -h to get detailed help about each command\n");
        return builder.toString();
    }

    private static String getWelcome() {
        StringBuilder builder = new StringBuilder();
        builder.append(APKEditor.getName());
        builder.append(" - ").append(APKEditor.getVersion());
        builder.append("\nUsing: ").append(APKEditor.getARSCLibInfo());
        builder.append("\n").append(APKEditor.getRepo());
        builder.append("\n").append(APKEditor.getDescription());
        return builder.toString();
    }

    private static String getCommand(String[] args) {
        String cmd = args[0];
        args[0] = null;
        return cmd;
    }
}

