/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmlencoder;

import com.reandroid.apk.xmlencoder.EncodeException;
import com.reandroid.apk.xmlencoder.EncodeMaterials;
import com.reandroid.apk.xmlencoder.XMLValuesEncoderBag;
import com.reandroid.arsc.array.ResValueMapArray;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.coder.ValueCoder;
import com.reandroid.arsc.coder.ValueDecoder;
import com.reandroid.arsc.value.AttributeDataFormat;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResTableMapEntry;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.arsc.value.attribute.AttributeBag;
import com.reandroid.xml.XMLElement;

public class XMLValuesEncoderStyle
extends XMLValuesEncoderBag {
    public XMLValuesEncoderStyle(EncodeMaterials materials) {
        super(materials);
    }

    @Override
    protected void encodeChildes(XMLElement parentElement, ResTableMapEntry resValueBag) {
        int count = parentElement.getChildesCount();
        ResValueMapArray itemArray = (ResValueMapArray)resValueBag.getValue();
        for (int i = 0; i < count; ++i) {
            XMLElement child = parentElement.getChildAt(i);
            ResValueMap item = (ResValueMap)itemArray.get(i);
            String name = child.getAttributeValue("name");
            EncodeResult id = ValueCoder.encodeUnknownResourceId(name);
            if (id != null) {
                item.setName(id.value);
                this.encodeAny(item, child.getTextContent());
                continue;
            }
            Entry attributeEntry = this.getMaterials().getAttributeBlock(name);
            if (attributeEntry == null) {
                throw new EncodeException("Unknown attribute name: '" + child.toText() + "', for style: " + parentElement.getAttributeValue("name"));
            }
            this.encodeChild(child, attributeEntry, item);
        }
    }

    private void encodeChild(XMLElement child, Entry attributeEntry, ResValueMap bagItem) {
        bagItem.setName(attributeEntry.getResourceId());
        ResTableMapEntry tableEntry = (ResTableMapEntry)attributeEntry.getTableEntry();
        AttributeBag attributeBag = AttributeBag.create((ResValueMapArray)tableEntry.getValue());
        String valueText = child.getTextContent();
        EncodeResult encodeEnumFlag = attributeBag.encodeEnumOrFlagValue(valueText);
        if (encodeEnumFlag != null) {
            bagItem.setTypeAndData(encodeEnumFlag.valueType, encodeEnumFlag.value);
            return;
        }
        EncodeResult encodeResult = this.getMaterials().encodeReference(valueText);
        if (encodeResult != null) {
            bagItem.setTypeAndData(encodeResult.valueType, encodeResult.value);
            return;
        }
        if (attributeBag.isEqualType(AttributeDataFormat.STRING)) {
            bagItem.setValueAsString(ValueDecoder.unEscapeUnQuote(valueText));
        } else {
            encodeResult = ValueCoder.encode(valueText);
            if (encodeResult != null) {
                bagItem.setTypeAndData(encodeResult.valueType, encodeResult.value);
            } else {
                bagItem.setValueAsString(ValueDecoder.unEscapeUnQuote(valueText));
            }
        }
    }
}

