/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmlencoder;

import com.reandroid.apk.xmlencoder.EncodeException;
import com.reandroid.apk.xmlencoder.EncodeMaterials;
import com.reandroid.apk.xmlencoder.XMLValuesEncoderBag;
import com.reandroid.arsc.array.ResValueMapArray;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.coder.ValueDecoder;
import com.reandroid.arsc.value.AttributeType;
import com.reandroid.arsc.value.ResTableMapEntry;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.xml.XMLElement;

class XMLValuesEncoderPlurals
extends XMLValuesEncoderBag {
    XMLValuesEncoderPlurals(EncodeMaterials materials) {
        super(materials);
    }

    @Override
    protected void encodeChildes(XMLElement parentElement, ResTableMapEntry resValueBag) {
        int count = parentElement.getChildesCount();
        ResValueMapArray itemArray = (ResValueMapArray)resValueBag.getValue();
        EncodeMaterials materials = this.getMaterials();
        for (int i = 0; i < count; ++i) {
            XMLElement child = parentElement.getChildAt(i);
            ResValueMap bagItem = (ResValueMap)itemArray.get(i);
            AttributeType quantity = AttributeType.fromName(child.getAttributeValue("quantity"));
            if (quantity == null) {
                throw new EncodeException("Unknown plurals quantity: " + child.toText());
            }
            bagItem.setName(quantity.getId());
            String valueText = child.getTextContent();
            EncodeResult encodeResult = materials.encodeReference(valueText);
            if (encodeResult != null) {
                bagItem.setTypeAndData(encodeResult.valueType, encodeResult.value);
                continue;
            }
            bagItem.setValueAsString(ValueDecoder.unEscapeUnQuote(valueText));
        }
    }
}

