/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmlencoder;

import com.reandroid.apk.xmlencoder.EncodeMaterials;
import com.reandroid.apk.xmlencoder.EncodeUtil;
import com.reandroid.apk.xmlencoder.XMLValuesEncoder;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResTableMapEntry;
import com.reandroid.xml.XMLElement;

public abstract class XMLValuesEncoderBag
extends XMLValuesEncoder {
    public XMLValuesEncoderBag(EncodeMaterials materials) {
        super(materials);
    }

    @Override
    public final void encodeValue(Entry entry, XMLElement element) {
        if (this.encodeIfReference(entry, element)) {
            return;
        }
        entry.ensureComplex(true);
        ResTableMapEntry tableMapEntry = (ResTableMapEntry)entry.getTableEntry();
        String parent = element.getAttributeValue("parent");
        if (!EncodeUtil.isEmpty(parent)) {
            int parentId = this.getMaterials().resolveReference(parent);
            tableMapEntry.setParentId(parentId);
        }
        tableMapEntry.setValuesCount(this.getChildesCount(element));
        this.encodeChildes(element, tableMapEntry);
    }

    private boolean encodeIfReference(Entry entry, XMLElement element) {
        if (element.hasChildElements() || !element.hasTextContent() || element.getAttributeCount() > 1) {
            return false;
        }
        String text = element.getTextContent();
        EncodeResult encodeResult = this.getMaterials().encodeReference(text);
        if (encodeResult != null) {
            entry.setValueAsRaw(encodeResult.valueType, encodeResult.value);
            return true;
        }
        return false;
    }

    protected abstract void encodeChildes(XMLElement var1, ResTableMapEntry var2);

    int getChildesCount(XMLElement element) {
        return element.getChildesCount();
    }
}

