/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmlencoder;

import com.reandroid.apk.xmlencoder.EncodeException;
import com.reandroid.apk.xmlencoder.EncodeMaterials;
import com.reandroid.apk.xmlencoder.XMLValuesEncoderBag;
import com.reandroid.arsc.array.ResValueMapArray;
import com.reandroid.arsc.coder.CommonType;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.coder.ValueCoder;
import com.reandroid.arsc.value.AttributeDataFormat;
import com.reandroid.arsc.value.AttributeType;
import com.reandroid.arsc.value.EntryHeaderMap;
import com.reandroid.arsc.value.ResTableMapEntry;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.xml.XMLAttribute;
import com.reandroid.xml.XMLElement;

public class XMLValuesEncoderAttr
extends XMLValuesEncoderBag {
    public XMLValuesEncoderAttr(EncodeMaterials materials) {
        super(materials);
    }

    @Override
    int getChildesCount(XMLElement element) {
        int count = element.getChildesCount() + element.getAttributeCount();
        if (element.getAttribute("formats") != null) {
            --count;
        }
        return count;
    }

    @Override
    protected void encodeChildes(XMLElement parentElement, ResTableMapEntry mapEntry) {
        this.encodeAttributes(parentElement, mapEntry);
        this.encodeEnumOrFlag(parentElement, mapEntry);
        EntryHeaderMap header = (EntryHeaderMap)mapEntry.getHeader();
        boolean is_public = !mapEntry.getParentEntry().getTypeName().contains("private");
        header.setPublic(is_public);
    }

    private void encodeAttributes(XMLElement parentElement, ResTableMapEntry mapEntry) {
        ResValueMapArray mapArray = (ResValueMapArray)mapEntry.getValue();
        int bagIndex = 0;
        ResValueMap formatItem = (ResValueMap)mapArray.get(bagIndex);
        formatItem.setValueType(ValueType.DEC);
        AttributeType typeFormats = AttributeType.FORMATS;
        formatItem.setAttributeType(typeFormats);
        formatItem.addAttributeTypeFormat(this.getFlagEnum(parentElement));
        AttributeDataFormat[] formats = AttributeDataFormat.parseValueTypes(parentElement.getAttributeValue(typeFormats.getName()));
        formatItem.addAttributeTypeFormats(formats);
        ++bagIndex;
        for (XMLAttribute attribute : parentElement.listAttributes()) {
            String name = attribute.getName();
            if ("name".equals(name) || "formats".equals(name)) continue;
            AttributeType attributeType = AttributeType.fromName(name);
            if (attributeType == null) {
                throw new EncodeException("Unknown attribute: '" + name + "', on attribute: " + attribute.toString() + ", element = " + parentElement.getAttributeValue("name"));
            }
            ResValueMap bagItem = (ResValueMap)mapArray.get(bagIndex);
            bagItem.setAttributeType(attributeType);
            String valueString = attribute.getValue();
            EncodeResult encodeResult = ValueCoder.encode(valueString, CommonType.INTEGER.valueTypes());
            if (encodeResult == null) {
                throw new EncodeException("Expecting hex or integer value: '" + valueString + "', on attribute: " + name + ", element: " + parentElement.getAttributeValue("name"));
            }
            bagItem.setTypeAndData(encodeResult.valueType, encodeResult.value);
            ++bagIndex;
        }
    }

    private void encodeEnumOrFlag(XMLElement element, ResTableMapEntry mapEntry) {
        int count = element.getChildesCount();
        if (count == 0) {
            return;
        }
        ResValueMapArray mapArray = (ResValueMapArray)mapEntry.getValue();
        int offset = element.getAttributeCount();
        if (element.getAttribute(AttributeType.FORMATS.getName()) != null) {
            --offset;
        }
        ResValueMap formatItem = (ResValueMap)mapArray.get(0);
        AttributeDataFormat lastBagFormat = AttributeDataFormat.typeOfBag(formatItem.getData());
        for (int i = 0; i < count; ++i) {
            XMLElement child = element.getChildAt(i);
            AttributeDataFormat bagFormat = AttributeDataFormat.fromBagTypeName(child.getTagName());
            if (bagFormat != lastBagFormat) {
                formatItem.addAttributeTypeFormat(bagFormat);
                lastBagFormat = bagFormat;
            }
            String name = child.getAttributeValue("name");
            int resourceId = this.decodeNameResourceId(name);
            ResValueMap valueMap = (ResValueMap)mapArray.get(i + offset);
            valueMap.setName(resourceId);
            String valueString = child.getTextContent();
            EncodeResult encodeResult = ValueCoder.encode(valueString, bagFormat.valueTypes());
            if (encodeResult == null) {
                throw new EncodeException("Expecting hex or integer value: '" + valueString + "', on element: " + child.toText());
            }
            valueMap.setTypeAndData(encodeResult.valueType, encodeResult.value);
        }
    }

    private int decodeNameResourceId(String name) {
        EncodeResult unknown = ValueCoder.encodeUnknownResourceId(name);
        int resourceId = unknown == null ? this.getMaterials().resolveLocalResourceId("id", name) : unknown.value;
        return resourceId;
    }

    private AttributeDataFormat getFlagEnum(XMLElement parent) {
        if (parent.getChildesCount() == 0) {
            return null;
        }
        return AttributeDataFormat.fromBagTypeName(parent.getChildAt(0).getTagName());
    }
}

