/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmlencoder;

import com.reandroid.apk.xmlencoder.EncodeException;
import com.reandroid.apk.xmlencoder.EncodeMaterials;
import com.reandroid.apk.xmlencoder.EncodeUtil;
import com.reandroid.apk.xmlencoder.XMLValuesEncoderBag;
import com.reandroid.arsc.array.ResValueMapArray;
import com.reandroid.arsc.coder.CoderInteger;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.coder.ValueCoder;
import com.reandroid.arsc.coder.ValueDecoder;
import com.reandroid.arsc.value.ResTableMapEntry;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.xml.XMLElement;

public class XMLValuesEncoderArray
extends XMLValuesEncoderBag {
    public XMLValuesEncoderArray(EncodeMaterials materials) {
        super(materials);
    }

    @Override
    protected void encodeChildes(XMLElement parentElement, ResTableMapEntry mapEntry) {
        int count = parentElement.getChildesCount();
        String tagName = parentElement.getTagName();
        boolean force_string = false;
        boolean force_integer = false;
        if ("string-array".equals(tagName)) {
            force_string = true;
        } else if ("integer-array".equals(tagName)) {
            force_integer = true;
        }
        EncodeMaterials materials = this.getMaterials();
        ResValueMapArray itemArray = (ResValueMapArray)mapEntry.getValue();
        for (int i = 0; i < count; ++i) {
            XMLElement child = parentElement.getChildAt(i);
            ResValueMap bagItem = (ResValueMap)itemArray.get(i);
            String name = child.getAttributeValue("name");
            if (name == null) {
                bagItem.setName(0x1000001 + i);
            } else {
                EncodeResult unknown = ValueCoder.encodeUnknownResourceId(name);
                int resourceId = unknown == null ? materials.resolveLocalResourceId("id", name) : unknown.value;
                bagItem.setName(resourceId);
            }
            String valueText = child.getTextContent();
            EncodeResult encodeResult = this.getMaterials().encodeReference(valueText);
            if (encodeResult != null) {
                bagItem.setTypeAndData(encodeResult.valueType, encodeResult.value);
                continue;
            }
            if (force_string) {
                bagItem.setValueAsString(ValueDecoder.unEscapeUnQuote(valueText));
                continue;
            }
            if (force_integer) {
                encodeResult = CoderInteger.INS.encode(valueText = XMLValuesEncoderArray.trimText(valueText));
                if (encodeResult == null) {
                    throw new EncodeException("Invalid integer value for array name=" + parentElement.getAttributeValue("name") + ", entry no" + (i + 1) + ", near line: " + child.getLineNumber());
                }
                bagItem.setTypeAndData(encodeResult.valueType, encodeResult.value);
                continue;
            }
            if (EncodeUtil.isEmpty(valueText)) {
                bagItem.setValueAsString("");
                continue;
            }
            encodeResult = ValueCoder.encode(valueText);
            if (encodeResult != null) {
                bagItem.setTypeAndData(encodeResult.valueType, encodeResult.value);
                continue;
            }
            bagItem.setValueAsString(ValueDecoder.unEscapeUnQuote(valueText));
        }
    }

    private static String trimText(String text) {
        if (text == null) {
            return null;
        }
        return text.trim();
    }
}

