/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmlencoder;

import com.reandroid.apk.xmlencoder.EncodeMaterials;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TypeBlock;
import com.reandroid.arsc.coder.CommonType;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.coder.ValueCoder;
import com.reandroid.arsc.coder.ValueDecoder;
import com.reandroid.arsc.value.AttributeDataFormat;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ValueItem;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.xml.XMLDocument;
import com.reandroid.xml.XMLElement;

public class XMLValuesEncoder {
    private final EncodeMaterials materials;

    XMLValuesEncoder(EncodeMaterials materials) {
        this.materials = materials;
    }

    public void encode(String type, String qualifiers, XMLDocument xmlDocument) {
        XMLElement documentElement = xmlDocument.getDocumentElement();
        TypeBlock typeBlock = this.getTypeBlock(type, qualifiers);
        int count = documentElement.getChildesCount();
        typeBlock.getEntryArray().ensureSize(count);
        for (int i = 0; i < count; ++i) {
            XMLElement element = documentElement.getChildAt(i);
            this.encode(typeBlock, element);
        }
    }

    public Entry encode(TypeBlock typeBlock, XMLElement element) {
        String name = element.getAttributeValue("name");
        int resourceId = this.getMaterials().resolveLocalResourceId(typeBlock.getTypeName(), name);
        Entry entry = typeBlock.getOrCreateEntry((short)(0xFFFF & resourceId));
        this.encodeValue(entry, element);
        this.getMaterials().setEntryName(entry, name);
        return entry;
    }

    public void encodeValue(Entry entry, XMLElement element) {
        String value = XMLValuesEncoder.getValue(element);
        EncodeResult encodeResult = this.getMaterials().encodeReference(value);
        if (encodeResult != null) {
            entry.setValueAsRaw(encodeResult.valueType, encodeResult.value);
            return;
        }
        ValueType[] expectedTypes = AttributeDataFormat.getExpectedValueTypes(element.getAttributeValue("type"));
        if (expectedTypes == null) {
            expectedTypes = CommonType.getExpectedTypes(entry.getTypeName());
        }
        this.encodeValue(entry, expectedTypes, value);
    }

    public void encodeValue(Entry entry, String text) {
        ValueType[] expectedTypes = CommonType.getExpectedTypes(entry.getTypeName());
        this.encodeValue(entry, expectedTypes, text);
    }

    public void encodeValue(Entry entry, ValueType[] expectedTypes, String text) {
        EncodeResult encodeResult = this.getMaterials().encodeReference(text);
        if (encodeResult == null) {
            encodeResult = ValueCoder.encode(text, expectedTypes);
        }
        if (encodeResult != null) {
            entry.setValueAsRaw(encodeResult.valueType, encodeResult.value);
        } else {
            text = ValueDecoder.unEscapeUnQuote(text);
            entry.setValueAsString(text);
        }
    }

    private TypeBlock getTypeBlock(String type, String qualifiers) {
        PackageBlock packageBlock = this.getMaterials().getCurrentPackage();
        return packageBlock.getOrCreateTypeBlock(qualifiers, type);
    }

    void encodeAny(ValueItem value, String text) {
        EncodeResult encodeResult = this.getMaterials().encodeReference(text);
        if (encodeResult == null) {
            encodeResult = ValueCoder.encode(text);
        }
        if (encodeResult != null) {
            value.setTypeAndData(encodeResult.valueType, encodeResult.value);
            return;
        }
        value.setValueAsString(text);
    }

    EncodeMaterials getMaterials() {
        return this.materials;
    }

    static String getValue(XMLElement element) {
        String value = element.getTextContent();
        if (value != null) {
            return value;
        }
        return element.getAttributeValue("value");
    }
}

