/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmlencoder;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ApkUtil;
import com.reandroid.apk.BlockInputSource;
import com.reandroid.apk.FrameworkApk;
import com.reandroid.apk.XmlHelper;
import com.reandroid.apk.xmlencoder.EncodeMaterials;
import com.reandroid.apk.xmlencoder.EncodeUtil;
import com.reandroid.apk.xmlencoder.FilePathEncoder;
import com.reandroid.apk.xmlencoder.ResourceValuesEncoder;
import com.reandroid.apk.xmlencoder.ValuesStringPoolBuilder;
import com.reandroid.archive.APKArchive;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.coder.ReferenceString;
import com.reandroid.arsc.util.FrameworkTable;
import com.reandroid.arsc.util.HexUtil;
import com.reandroid.identifiers.PackageIdentifier;
import com.reandroid.identifiers.ResourceIdentifier;
import com.reandroid.identifiers.TableIdentifier;
import com.reandroid.xml.XMLException;
import com.reandroid.xml.XMLParserFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XMLTableBlockEncoder {
    private APKLogger apkLogger;
    private final TableBlock tableBlock;
    private final Set<File> parsedFiles = new HashSet<File>();
    private final ApkModule apkModule;
    private EncodeMaterials mEncodeMaterials;

    public XMLTableBlockEncoder(ApkModule apkModule, TableBlock tableBlock) {
        this.apkModule = apkModule;
        this.tableBlock = tableBlock;
        if (!apkModule.hasTableBlock()) {
            BlockInputSource<TableBlock> inputSource = new BlockInputSource<TableBlock>("resources.arsc", tableBlock);
            inputSource.setMethod(0);
            this.apkModule.setTableBlock(this.tableBlock);
            apkModule.setLoadDefaultFramework(true);
        }
        this.apkLogger = apkModule.getApkLogger();
    }

    public XMLTableBlockEncoder() {
        this(new ApkModule("encoded", new APKArchive()), new TableBlock());
    }

    public EncodeMaterials getEncodeMaterials() {
        EncodeMaterials materials = this.mEncodeMaterials;
        if (materials == null) {
            materials = new EncodeMaterials();
            materials.setAPKLogger(this.getApkLogger());
            this.mEncodeMaterials = materials;
        }
        return materials;
    }

    public void setEncodeMaterials(EncodeMaterials encodeMaterials) {
        this.mEncodeMaterials = encodeMaterials;
    }

    public TableBlock getTableBlock() {
        return this.tableBlock;
    }

    public ApkModule getApkModule() {
        return this.apkModule;
    }

    public void scanMainDirectory(File mainDirectory) throws IOException {
        File resourcesDirectory = new File(mainDirectory, "resources");
        this.scanResourcesDirectory(resourcesDirectory);
    }

    public void scanResourcesDirectory(File resourcesDirectory) throws IOException {
        try {
            this.scanResourceFiles(resourcesDirectory);
        }
        catch (XMLException ex) {
            throw new IOException(ex);
        }
    }

    private void scanResourceFiles(File resourcesDirectory) throws IOException, XMLException {
        List<File> pubXmlFileList = ApkUtil.listPublicXmlFiles(resourcesDirectory);
        if (pubXmlFileList.size() == 0) {
            throw new IOException("No .*/values/public.xml  file found in '" + resourcesDirectory + "'");
        }
        this.preloadStringPool(pubXmlFileList);
        EncodeMaterials encodeMaterials = this.getEncodeMaterials();
        TableIdentifier tableIdentifier = encodeMaterials.getTableIdentifier();
        tableIdentifier.loadPublicXml(pubXmlFileList);
        tableIdentifier.initialize(this.tableBlock);
        this.excludeIds(pubXmlFileList);
        this.initializeFrameworkFromManifest(pubXmlFileList);
        this.encodeAttrs(pubXmlFileList);
        this.encodeValues(pubXmlFileList);
        this.tableBlock.refresh();
    }

    private void initializeFrameworkFromManifest(List<File> pubXmlFileList) throws IOException {
        for (File pubXmlFile : pubXmlFileList) {
            File manifestFile = this.toAndroidManifest(pubXmlFile);
            if (!manifestFile.isFile()) continue;
            this.initializeFrameworkFromManifest(manifestFile);
            return;
        }
    }

    private void encodeValues(List<File> pubXmlFileList) throws XMLException, IOException {
        this.logMessage("Encoding values ...");
        EncodeMaterials encodeMaterials = this.getEncodeMaterials();
        TableIdentifier tableIdentifier = encodeMaterials.getTableIdentifier();
        for (File pubXmlFile : pubXmlFileList) {
            this.addParsedFiles(pubXmlFile);
            PackageIdentifier packageIdentifier = tableIdentifier.getByTag(pubXmlFile);
            PackageBlock packageBlock = packageIdentifier.getPackageBlock();
            encodeMaterials.setCurrentPackage(packageBlock);
            File resDir = this.toResDirectory(pubXmlFile);
            this.encodeResDir(resDir);
            FilePathEncoder filePathEncoder = new FilePathEncoder(encodeMaterials);
            filePathEncoder.setApkArchive(this.getApkModule().getApkArchive());
            filePathEncoder.setUncompressedFiles(this.getApkModule().getUncompressedFiles());
            filePathEncoder.encodePackageResDir(resDir);
            packageBlock.sortTypes();
            packageBlock.refresh();
        }
    }

    private void encodeAttrs(List<File> pubXmlFileList) throws XMLException {
        this.logMessage("Encoding attrs ...");
        EncodeMaterials encodeMaterials = this.getEncodeMaterials();
        TableIdentifier tableIdentifier = encodeMaterials.getTableIdentifier();
        for (File pubXmlFile : pubXmlFileList) {
            this.addParsedFiles(pubXmlFile);
            PackageIdentifier packageIdentifier = tableIdentifier.getByTag(pubXmlFile);
            PackageBlock packageBlock = packageIdentifier.getPackageBlock();
            encodeMaterials.setCurrentPackage(packageBlock);
            ResourceValuesEncoder valuesEncoder = new ResourceValuesEncoder(encodeMaterials);
            List<File> attrFiles = this.listAttrs(pubXmlFile);
            if (attrFiles.size() == 0) continue;
            for (File file : attrFiles) {
                valuesEncoder.encodeValuesXml(file);
                this.addParsedFiles(file);
            }
            packageBlock.sortTypes();
        }
    }

    private void excludeIds(List<File> pubXmlFileList) {
        for (File pubXmlFile : pubXmlFileList) {
            this.addParsedFiles(pubXmlFile);
            File valuesDir = pubXmlFile.getParentFile();
            File file = new File(valuesDir, "ids.xml");
            if (!file.isFile()) continue;
            this.addParsedFiles(file);
        }
    }

    private void initializeFrameworkFromManifest(File manifestFile) throws IOException {
        XmlPullParser parser;
        if ("AndroidManifest.xml.bin".equals(manifestFile.getName())) {
            this.initializeFrameworkFromBinaryManifest();
            return;
        }
        try {
            parser = XMLParserFactory.newPullParser(manifestFile);
        }
        catch (XmlPullParserException ex) {
            throw new IOException(ex);
        }
        EncodeMaterials encodeMaterials = this.getEncodeMaterials();
        FrameworkApk frameworkApk = this.getApkModule().initializeAndroidFramework(parser);
        if (frameworkApk == null) {
            for (TableBlock frame : this.getApkModule().getLoadedFrameworks()) {
                if (!(frame instanceof FrameworkTable)) continue;
                encodeMaterials.addFramework((FrameworkTable)frame);
            }
        } else {
            encodeMaterials.addFramework(frameworkApk);
        }
        this.initializeMainPackageId(encodeMaterials, parser);
        XmlHelper.closeSilent(parser);
    }

    private void initializeFrameworkFromBinaryManifest() throws IOException {
        ApkModule apkModule = this.getApkModule();
        if (!apkModule.hasTableBlock() || !apkModule.hasAndroidManifestBlock()) {
            return;
        }
        this.logMessage("Initialize framework from binary manifest ...");
        FrameworkApk frameworkApk = apkModule.initializeAndroidFramework(apkModule.getAndroidFrameworkVersion());
        this.getEncodeMaterials().addFramework(frameworkApk);
    }

    private void initializeMainPackageId(EncodeMaterials encodeMaterials, XmlPullParser parser) throws IOException {
        Map<String, String> applicationAttributes;
        try {
            applicationAttributes = XmlHelper.readAttributes(parser, "application");
        }
        catch (XmlPullParserException ex) {
            throw new IOException(ex);
        }
        if (applicationAttributes == null) {
            return;
        }
        String iconReference = applicationAttributes.get("icon");
        if (iconReference == null) {
            return;
        }
        this.logMessage("Set main package id from manifest: " + iconReference);
        ReferenceString ref = ReferenceString.parseReference(iconReference);
        if (ref == null) {
            this.logMessage("Something wrong on : icon");
            return;
        }
        TableIdentifier tableIdentifier = encodeMaterials.getTableIdentifier();
        ResourceIdentifier resourceIdentifier = ref.packageName != null ? tableIdentifier.get(ref.packageName, ref.type, ref.name) : tableIdentifier.get(ref.type, ref.name);
        if (resourceIdentifier == null) {
            this.logMessage("WARN: failed to resolve: " + ref);
            return;
        }
        int packageId = resourceIdentifier.getPackageId();
        encodeMaterials.setMainPackageId(packageId);
        this.logMessage("Main package id initialized: id = " + HexUtil.toHex2((byte)packageId) + ", from: " + ref);
    }

    private void preloadStringPool(List<File> pubXmlFileList) {
        this.logMessage("Loading string pool ...");
        ValuesStringPoolBuilder poolBuilder = new ValuesStringPoolBuilder();
        for (File pubXml : pubXmlFileList) {
            File resDir = this.toResDirectory(pubXml);
            List<File> valuesDirList = ApkUtil.listValuesDirectory(resDir);
            for (File dir : valuesDirList) {
                this.logVerbose(poolBuilder.size() + " building pool: " + dir.getName());
                poolBuilder.scanValuesDirectory(dir);
            }
        }
        poolBuilder.addTo(this.tableBlock.getTableStringPool());
    }

    private void encodeResDir(File resDir) throws XMLException {
        List<File> valuesDirList = ApkUtil.listValuesDirectory(resDir);
        for (File valuesDir : valuesDirList) {
            this.encodeValuesDir(valuesDir);
        }
    }

    private void encodeValuesDir(File valuesDir) throws XMLException {
        EncodeMaterials materials = this.getEncodeMaterials();
        ResourceValuesEncoder valuesEncoder = new ResourceValuesEncoder(materials);
        List<File> xmlFiles = ApkUtil.listFiles(valuesDir, ".xml");
        EncodeUtil.sortValuesXml(xmlFiles);
        for (File file : xmlFiles) {
            if (this.isAlreadyParsed(file)) continue;
            this.addParsedFiles(file);
            valuesEncoder.encodeValuesXml(file);
        }
    }

    private File toAndroidManifest(File pubXmlFile) {
        File resDirectory = this.toResDirectory(pubXmlFile);
        File packageDirectory = resDirectory.getParentFile();
        File resourcesDir = packageDirectory.getParentFile();
        File root = resourcesDir.getParentFile();
        File file = new File(root, "AndroidManifest.xml.bin");
        if (!file.isFile()) {
            file = new File(root, "AndroidManifest.xml");
        }
        return file;
    }

    private File toResDirectory(File pubXmlFile) {
        return pubXmlFile.getParentFile().getParentFile();
    }

    private List<File> listAttrs(File pubXmlFile) {
        return this.listValuesXml(pubXmlFile, "attr");
    }

    private List<File> listValuesXml(File pubXmlFile, String type) {
        ArrayList<File> results = new ArrayList<File>();
        File resDir = this.toResDirectory(pubXmlFile);
        List<File> valuesDirList = ApkUtil.listValuesDirectory(resDir);
        for (File valuesDir : valuesDirList) {
            results.addAll(this.findValuesXml(valuesDir, type));
        }
        return results;
    }

    private List<File> findValuesXml(File valuesDir, String type) {
        ArrayList<File> results = new ArrayList<File>();
        File[] xmlFiles = valuesDir.listFiles();
        if (xmlFiles == null) {
            return results;
        }
        for (File file : xmlFiles) {
            String name;
            if (!file.isFile() || !(name = file.getName()).endsWith(".xml") || !(name = EncodeUtil.sanitizeType(name)).equals(type)) continue;
            results.add(file);
        }
        return results;
    }

    private boolean isAlreadyParsed(File file) {
        return this.parsedFiles.contains(file);
    }

    private void addParsedFiles(File file) {
        this.parsedFiles.add(file);
    }

    public APKLogger getApkLogger() {
        return this.apkLogger;
    }

    public void setApkLogger(APKLogger logger) {
        this.apkLogger = logger;
        if (logger != null && this.apkModule.getApkLogger() == null) {
            this.apkModule.setAPKLogger(logger);
        }
    }

    private void logMessage(String msg) {
        APKLogger apkLogger = this.getApkLogger();
        if (apkLogger != null) {
            apkLogger.logMessage(msg);
        }
    }

    private void logError(String msg, Throwable tr) {
        APKLogger apkLogger = this.getApkLogger();
        if (apkLogger != null) {
            apkLogger.logError(msg, tr);
        }
    }

    private void logVerbose(String msg) {
        APKLogger apkLogger = this.getApkLogger();
        if (apkLogger != null) {
            apkLogger.logVerbose(msg);
        }
    }
}

