/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmlencoder;

import com.reandroid.apk.xmlencoder.EncodeException;
import com.reandroid.apk.xmlencoder.EncodeMaterials;
import com.reandroid.arsc.array.ResValueMapArray;
import com.reandroid.arsc.chunk.xml.ResIdBuilder;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlStartNamespace;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.coder.ValueCoder;
import com.reandroid.arsc.coder.ValueDecoder;
import com.reandroid.arsc.value.AttributeDataFormat;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.attribute.AttributeBag;
import com.reandroid.xml.SchemaAttr;
import com.reandroid.xml.XMLAttribute;
import com.reandroid.xml.XMLComment;
import com.reandroid.xml.XMLDocument;
import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLException;
import com.reandroid.xml.XMLNode;
import com.reandroid.xml.XMLText;
import java.io.File;
import java.io.InputStream;

public class XMLFileEncoder {
    private final EncodeMaterials materials;
    private ResXmlDocument resXmlDocument;
    private String mCurrentPath;

    public XMLFileEncoder(EncodeMaterials materials) {
        this.materials = materials;
    }

    public void setCurrentPath(String path) {
        this.mCurrentPath = path;
    }

    public ResXmlDocument encode(String xmlString) {
        try {
            return this.encode(XMLDocument.load(xmlString));
        }
        catch (XMLException ex) {
            this.materials.logMessage(ex.getMessage());
            return null;
        }
    }

    public ResXmlDocument encode(InputStream inputStream) {
        try {
            return this.encode(XMLDocument.load(inputStream));
        }
        catch (XMLException ex) {
            this.materials.logMessage(ex.getMessage());
            return null;
        }
    }

    public ResXmlDocument encode(File xmlFile) {
        this.setCurrentPath(xmlFile.getAbsolutePath());
        try {
            return this.encode(XMLDocument.load(xmlFile));
        }
        catch (XMLException ex) {
            this.materials.logMessage(ex.getMessage());
            return null;
        }
    }

    public ResXmlDocument encode(XMLDocument xmlDocument) {
        this.resXmlDocument = new ResXmlDocument();
        this.resXmlDocument.setPackageBlock(this.materials.getCurrentPackage());
        this.buildIdMap(xmlDocument);
        this.buildElement(xmlDocument);
        this.resXmlDocument.refresh();
        return this.resXmlDocument;
    }

    public ResXmlDocument getResXmlBlock() {
        return this.resXmlDocument;
    }

    private void buildElement(XMLDocument xmlDocument) {
        XMLElement element = xmlDocument.getDocumentElement();
        ResXmlElement resXmlElement = this.resXmlDocument.createRootElement(element.getTagName());
        this.buildElement(element, resXmlElement);
    }

    private void buildElement(XMLElement element, ResXmlElement resXmlElement) {
        this.ensureNamespaces(element, resXmlElement);
        resXmlElement.setTag(element.getTagName());
        this.buildAttributes(element, resXmlElement);
        for (XMLNode node : element.getChildNodes()) {
            if (node instanceof XMLText) {
                resXmlElement.addResXmlText(((XMLText)node).getText(true));
                continue;
            }
            if (node instanceof XMLComment) {
                resXmlElement.setComment(((XMLComment)node).getCommentText());
                continue;
            }
            if (!(node instanceof XMLElement)) continue;
            XMLElement child = (XMLElement)node;
            ResXmlElement childXml = resXmlElement.createChildElement();
            this.buildElement(child, childXml);
        }
    }

    private void buildAttributes(XMLElement element, ResXmlElement resXmlElement) {
        for (XMLAttribute attribute : element.listAttributes()) {
            String valueText;
            EncodeResult encodeResult;
            int resourceId;
            if (attribute instanceof SchemaAttr || SchemaAttr.looksSchema(attribute.getName(), attribute.getValue())) continue;
            String name = attribute.getNameWoPrefix();
            String prefix = attribute.getNamePrefix();
            EncodeResult unknownId = ValueCoder.encodeUnknownResourceId(name);
            Entry entry = null;
            if (unknownId == null && prefix != null) {
                entry = this.getAttributeBlock(attribute);
                if (entry == null) {
                    throw new EncodeException("No resource found for attribute: " + attribute.getName() + ", at file " + this.mCurrentPath);
                }
                resourceId = entry.getResourceId();
            } else {
                resourceId = unknownId != null ? unknownId.value : 0;
            }
            ResXmlAttribute xmlAttribute = resXmlElement.createAttribute(name, resourceId);
            if (prefix != null) {
                ResXmlStartNamespace ns = resXmlElement.getStartNamespaceByPrefix(prefix);
                if (ns == null) {
                    ns = this.forceCreateNamespace(resXmlElement, resourceId, prefix);
                }
                if (ns == null) {
                    throw new EncodeException("Namespace not found: " + attribute.toString() + ", path=" + this.mCurrentPath);
                }
                xmlAttribute.setNamespaceReference(ns.getUriReference());
            }
            if ((encodeResult = this.materials.encodeReference(valueText = attribute.getValue())) != null) {
                xmlAttribute.setTypeAndData(encodeResult.valueType, encodeResult.value);
                continue;
            }
            if (entry != null) {
                AttributeBag attributeBag = AttributeBag.create((ResValueMapArray)entry.getTableEntry().getValue());
                encodeResult = attributeBag.encodeEnumOrFlagValue(valueText);
                if (encodeResult == null) {
                    AttributeDataFormat[] formats = attributeBag.getFormats();
                    encodeResult = ValueCoder.encode(valueText, formats);
                }
                if (encodeResult != null) {
                    xmlAttribute.setTypeAndData(encodeResult.valueType, encodeResult.value);
                    continue;
                }
                if (attributeBag.isEqualType(AttributeDataFormat.STRING)) {
                    xmlAttribute.setValueAsString(ValueDecoder.unEscapeUnQuote(valueText));
                    continue;
                }
            }
            if ((encodeResult = ValueCoder.encode(valueText)) != null) {
                xmlAttribute.setTypeAndData(encodeResult.valueType, encodeResult.value);
                continue;
            }
            xmlAttribute.setValueAsString(ValueDecoder.unEscapeUnQuote(valueText));
        }
        resXmlElement.calculatePositions();
    }

    private void ensureNamespaces(XMLElement element, ResXmlElement resXmlElement) {
        for (XMLAttribute attribute : element.listAttributes()) {
            String prefix = SchemaAttr.getPrefix(attribute.getName());
            if (prefix == null) continue;
            String uri = attribute.getValue();
            resXmlElement.getOrCreateNamespace(uri, prefix);
        }
    }

    private void buildIdMap(XMLDocument xmlDocument) {
        ResIdBuilder idBuilder = new ResIdBuilder();
        XMLElement element = xmlDocument.getDocumentElement();
        this.searchResIds(idBuilder, element);
        idBuilder.buildTo(this.resXmlDocument.getResXmlIDMap());
    }

    private void searchResIds(ResIdBuilder idBuilder, XMLElement element) {
        for (XMLAttribute attribute : element.listAttributes()) {
            this.addResourceId(idBuilder, attribute);
        }
        int count = element.getChildesCount();
        for (int i = 0; i < count; ++i) {
            this.searchResIds(idBuilder, element.getChildAt(i));
        }
    }

    private void addResourceId(ResIdBuilder idBuilder, XMLAttribute attribute) {
        String name = attribute.getNameWoPrefix();
        EncodeResult encodeResult = ValueCoder.encodeUnknownResourceId(name);
        if (encodeResult != null) {
            idBuilder.add(encodeResult.value, name);
            return;
        }
        Entry entry = this.getAttributeBlock(attribute);
        if (entry != null) {
            idBuilder.add(entry.getResourceId(), entry.getName());
        }
    }

    private Entry getAttributeBlock(XMLAttribute attribute) {
        if (attribute instanceof SchemaAttr) {
            return null;
        }
        String name = attribute.getName();
        if (name.indexOf(58) < 0) {
            return null;
        }
        return this.materials.getAttributeBlock(name);
    }

    private ResXmlStartNamespace forceCreateNamespace(ResXmlElement resXmlElement, int resourceId, String prefix) {
        if (!this.materials.isForceCreateNamespaces()) {
            return null;
        }
        int pkgId = resourceId >> 24 & 0xFF;
        String uri = pkgId == 1 ? "http://schemas.android.com/apk/res/android" : "http://schemas.android.com/apk/res-auto";
        ResXmlElement root = resXmlElement.getRootResXmlElement();
        ResXmlStartNamespace ns = root.getOrCreateNamespace(uri, prefix);
        this.materials.logVerbose("Force created ns: " + prefix + ":" + uri);
        return ns;
    }
}

