/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmlencoder;

import com.reandroid.apk.CrcOutputStream;
import com.reandroid.apk.xmlencoder.EncodeException;
import com.reandroid.apk.xmlencoder.EncodeMaterials;
import com.reandroid.apk.xmlencoder.XMLFileEncoder;
import com.reandroid.archive.ByteInputSource;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.value.Entry;
import com.reandroid.xml.XMLException;
import com.reandroid.xml.source.XMLSource;
import java.io.IOException;
import java.io.OutputStream;

public class XMLEncodeSource
extends ByteInputSource {
    private final EncodeMaterials encodeMaterials;
    private final XMLSource xmlSource;
    private ResXmlDocument resXmlDocument;
    private Entry mEntry;

    public XMLEncodeSource(EncodeMaterials encodeMaterials, XMLSource xmlSource, Entry entry) {
        super(new byte[0], xmlSource.getPath());
        this.encodeMaterials = encodeMaterials;
        this.xmlSource = xmlSource;
        this.mEntry = entry;
    }

    public XMLEncodeSource(EncodeMaterials encodeMaterials, XMLSource xmlSource) {
        this(encodeMaterials, xmlSource, null);
    }

    public XMLSource getXmlSource() {
        return this.xmlSource;
    }

    public Entry getEntry() {
        return this.mEntry;
    }

    public void setEntry(Entry entry) {
        this.mEntry = entry;
    }

    @Override
    public long getLength() throws IOException {
        return this.getResXmlBlock().countBytes();
    }

    @Override
    public long getCrc() throws IOException {
        ResXmlDocument resXmlDocument = this.getResXmlBlock();
        CrcOutputStream outputStream = new CrcOutputStream();
        resXmlDocument.writeBytes(outputStream);
        return outputStream.getCrcValue();
    }

    @Override
    public long write(OutputStream outputStream) throws IOException {
        return this.getResXmlBlock().writeBytes(outputStream);
    }

    @Override
    public byte[] getBytes() {
        try {
            return this.getResXmlBlock().getBytes();
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }

    public ResXmlDocument getResXmlBlock() throws IOException {
        if (this.resXmlDocument != null) {
            return this.resXmlDocument;
        }
        try {
            XMLFileEncoder xmlFileEncoder = new XMLFileEncoder(this.encodeMaterials);
            xmlFileEncoder.setCurrentPath(this.xmlSource.getPath());
            EncodeMaterials encodeMaterials = this.encodeMaterials;
            encodeMaterials.logVerbose("Encoding xml: " + this.xmlSource.getPath());
            PackageBlock currentPackage = encodeMaterials.getCurrentPackage();
            PackageBlock packageBlock = this.getEntryPackageBlock();
            if (packageBlock != null && packageBlock != currentPackage) {
                encodeMaterials.setCurrentPackage(packageBlock);
            }
            this.resXmlDocument = xmlFileEncoder.encode(this.xmlSource.getXMLDocument());
        }
        catch (XMLException ex) {
            throw new EncodeException("XMLException on: '" + this.xmlSource.getPath() + "'\n         '" + ex.getMessage() + "'");
        }
        return this.resXmlDocument;
    }

    private PackageBlock getEntryPackageBlock() {
        Entry entry = this.getEntry();
        if (entry != null) {
            return entry.getPackageBlock();
        }
        return null;
    }

    @Override
    public void disposeInputSource() {
        this.xmlSource.disposeXml();
        if (this.resXmlDocument != null) {
            this.resXmlDocument = null;
        }
    }
}

