/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmlencoder;

import com.reandroid.apk.xmlencoder.EncodeUtil;
import com.reandroid.arsc.array.StringArray;
import com.reandroid.arsc.array.StyleArray;
import com.reandroid.arsc.coder.ValueDecoder;
import com.reandroid.arsc.item.StyleItem;
import com.reandroid.arsc.item.TableString;
import com.reandroid.arsc.pool.TableStringPool;
import com.reandroid.xml.XMLDocument;
import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLSpanInfo;
import com.reandroid.xml.XMLSpannable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ValuesStringPoolBuilder {
    private final Set<String> stringList = new HashSet<String>();
    private final Set<String> styleList = new HashSet<String>();

    public void addTo(TableStringPool stringPool) {
        if (stringPool.getStringsArray().childesCount() == 0) {
            this.buildWithStyles(stringPool);
        }
        stringPool.addStrings(this.stringList);
        this.stringList.clear();
        this.styleList.clear();
        stringPool.refresh();
    }

    private void buildWithStyles(TableStringPool stringPool) {
        List<XMLSpannable> spannableList = this.buildSpannable();
        if (spannableList.size() == 0) {
            return;
        }
        StringArray stringsArray = stringPool.getStringsArray();
        StyleArray styleArray = stringPool.getStyleArray();
        int stylesCount = spannableList.size();
        stringsArray.setChildesCount(stylesCount);
        styleArray.setChildesCount(stylesCount);
        ArrayList<String> tagList = new ArrayList<String>(XMLSpannable.tagList(spannableList));
        EncodeUtil.sortStrings(tagList);
        Map tagsMap = stringPool.insertStrings(tagList);
        List<String> textList = XMLSpannable.toTextList(spannableList);
        for (int i = 0; i < stylesCount; ++i) {
            XMLSpannable spannable = spannableList.get(i);
            TableString tableString = (TableString)stringsArray.get(i);
            StyleItem styleItem = (StyleItem)styleArray.get(i);
            tableString.set(textList.get(i));
            for (XMLSpanInfo spanInfo : spannable.getSpanInfoList()) {
                TableString tag = (TableString)tagsMap.get(spanInfo.tag);
                int tagRef = tag.getIndex();
                styleItem.addStylePiece(tagRef, spanInfo.start, spanInfo.end);
            }
        }
        stringPool.refreshUniqueIdMap();
    }

    private List<XMLSpannable> buildSpannable() {
        ArrayList<XMLSpannable> results = new ArrayList<XMLSpannable>();
        HashSet<String> removeList = new HashSet<String>();
        for (String text : this.styleList) {
            XMLSpannable spannable = XMLSpannable.parse(text);
            if (spannable != null) {
                results.add(spannable);
                removeList.add(text);
                continue;
            }
            this.stringList.add(text);
        }
        this.stringList.removeAll(removeList);
        XMLSpannable.sort(results);
        return results;
    }

    public void scanValuesDirectory(File dir) {
        this.addStringsFile(new File(dir, "strings.xml"));
        this.addBagsFile(new File(dir, "plurals.xml"));
    }

    public int size() {
        return this.stringList.size();
    }

    private void addStringsFile(File file) {
        if (file == null || !file.isFile()) {
            return;
        }
        try {
            XMLDocument xmlDocument = XMLDocument.load(file);
            this.addStrings(xmlDocument);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addBagsFile(File file) {
        if (file == null || !file.isFile()) {
            return;
        }
        try {
            XMLDocument xmlDocument = XMLDocument.load(file);
            this.addBagStrings(xmlDocument);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addBagStrings(XMLDocument xmlDocument) {
        if (xmlDocument == null) {
            return;
        }
        XMLElement documentElement = xmlDocument.getDocumentElement();
        if (documentElement == null) {
            return;
        }
        int count = documentElement.getChildesCount();
        for (int i = 0; i < count; ++i) {
            XMLElement child = documentElement.getChildAt(i);
            int childCount = child.getChildesCount();
            for (int j = 0; j < childCount; ++j) {
                this.addStrings(child.getChildAt(i));
            }
        }
    }

    private void addStrings(XMLDocument xmlDocument) {
        if (xmlDocument == null) {
            return;
        }
        XMLElement documentElement = xmlDocument.getDocumentElement();
        if (documentElement == null) {
            return;
        }
        int count = documentElement.getChildesCount();
        for (int i = 0; i < count; ++i) {
            this.addStrings(documentElement.getChildAt(i));
        }
    }

    private void addStrings(XMLElement element) {
        if (element.hasChildElements()) {
            this.addStyleElement(element);
        } else {
            String text = ValueDecoder.unEscapeUnQuote(element.getTextContent());
            this.addString(text);
        }
    }

    private void addString(String text) {
        if (text != null && text.length() > 0 && text.charAt(0) != '@') {
            this.stringList.add(text);
        }
    }

    private void addStyleElement(XMLElement element) {
        this.styleList.add(element.buildTextContent(false));
    }
}

