/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmlencoder;

import com.reandroid.apk.xmlencoder.EncodeException;
import com.reandroid.apk.xmlencoder.EncodeMaterials;
import com.reandroid.apk.xmlencoder.EncodeUtil;
import com.reandroid.apk.xmlencoder.XMLValuesEncoder;
import com.reandroid.apk.xmlencoder.XMLValuesEncoderArray;
import com.reandroid.apk.xmlencoder.XMLValuesEncoderAttr;
import com.reandroid.apk.xmlencoder.XMLValuesEncoderBag;
import com.reandroid.apk.xmlencoder.XMLValuesEncoderId;
import com.reandroid.apk.xmlencoder.XMLValuesEncoderPlurals;
import com.reandroid.apk.xmlencoder.XMLValuesEncoderString;
import com.reandroid.apk.xmlencoder.XMLValuesEncoderStyle;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.value.Entry;
import com.reandroid.xml.XMLDocument;
import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class ResourceValuesEncoder {
    private final EncodeMaterials materials;
    private final Map<String, XMLValuesEncoder> xmlEncodersMap;
    private final Map<String, XMLValuesEncoderBag> xmlBagEncodersMap;
    private final XMLValuesEncoder commonEncoder;
    private final XMLValuesEncoderBag bagCommonEncoder;

    public ResourceValuesEncoder(EncodeMaterials materials) {
        this.materials = materials;
        this.commonEncoder = new XMLValuesEncoder(materials);
        HashMap<String, XMLValuesEncoder> map = new HashMap<String, XMLValuesEncoder>();
        map.put("id", new XMLValuesEncoderId(materials));
        map.put("string", new XMLValuesEncoderString(materials));
        this.xmlEncodersMap = map;
        HashMap<String, XMLValuesEncoderBag> mapBag = new HashMap<String, XMLValuesEncoderBag>();
        XMLValuesEncoderAttr encoderAttr = new XMLValuesEncoderAttr(materials);
        mapBag.put("attr", encoderAttr);
        mapBag.put("^attr-private", encoderAttr);
        mapBag.put("plurals", new XMLValuesEncoderPlurals(materials));
        mapBag.put("array", new XMLValuesEncoderArray(materials));
        mapBag.put("style", new XMLValuesEncoderStyle(materials));
        this.xmlBagEncodersMap = mapBag;
        this.bagCommonEncoder = new XMLValuesEncoderStyle(materials);
    }

    public void encodeValuesXml(File valuesXmlFile) throws XMLException {
        if (valuesXmlFile.getName().equals("public.xml")) {
            return;
        }
        String simpleName = valuesXmlFile.getParentFile().getName() + File.separator + valuesXmlFile.getName();
        this.materials.logVerbose("Encoding: " + simpleName);
        String type = EncodeUtil.getTypeNameFromValuesXml(valuesXmlFile);
        String qualifiers = EncodeUtil.getQualifiersFromValuesXml(valuesXmlFile);
        XMLDocument xmlDocument = XMLDocument.load(valuesXmlFile);
        this.encodeValuesXml(type, qualifiers, xmlDocument);
    }

    public void encodeValue(String qualifiers, XMLElement element) {
        String type = this.getType(element, null);
        if (type == null) {
            throw new EncodeException("Can not determine type: " + element);
        }
        this.encodeValue(type, qualifiers, element);
    }

    public void encodeValue(String type, String qualifiers, XMLElement element) {
        boolean is_bag = this.isBag(element);
        this.encodeValue(is_bag, type, qualifiers, element);
    }

    public void encodeValue(boolean is_bag, String type, String qualifiers, XMLElement element) {
        PackageBlock packageBlock = this.getEncodeMaterials().getCurrentPackage();
        Entry entry = packageBlock.getOrCreate(qualifiers, type, element.getAttributeValue("name"));
        this.encodeValue(is_bag, entry, element);
    }

    public void encodeValue(Entry entry, XMLElement element) {
        boolean is_bag = this.isBag(element);
        this.encodeValue(is_bag, entry, element);
    }

    public void encodeValue(boolean is_bag, Entry entry, XMLElement element) {
        String type = entry.getTypeName();
        XMLValuesEncoder encoder = is_bag ? this.getBagEncoder(type) : this.getEncoder(type);
        encoder.encodeValue(entry, element);
    }

    public void encodeValues(String type, String qualifiers, XMLDocument xmlDocument) {
        type = this.getType(xmlDocument, type);
        boolean is_bag = this.isBag(xmlDocument, type);
        this.encodeValues(is_bag, type, qualifiers, xmlDocument);
    }

    public void encodeValues(boolean is_bag, String type, String qualifiers, XMLDocument xmlDocument) {
        XMLValuesEncoder encoder = is_bag ? this.getBagEncoder(type) : this.getEncoder(type);
        encoder.encode(type, qualifiers, xmlDocument);
    }

    public EncodeMaterials getEncodeMaterials() {
        return this.materials;
    }

    private void encodeValuesXml(String type, String qualifiers, XMLDocument xmlDocument) {
        XMLValuesEncoder encoder = this.isBag(xmlDocument, type = this.getType(xmlDocument, type)) ? this.getBagEncoder(type) : this.getEncoder(type);
        encoder.encode(type, qualifiers, xmlDocument);
    }

    private boolean isBag(XMLElement element) {
        if (element.hasChildElements()) {
            return true;
        }
        String type = this.getType(element, element.getTagName());
        return this.isBagTypeName(type);
    }

    private boolean isBag(XMLDocument xmlDocument, String type) {
        if (this.isBagTypeName(type)) {
            return true;
        }
        if (type.startsWith("string")) {
            return false;
        }
        XMLElement documentElement = xmlDocument.getDocumentElement();
        int count = documentElement.getChildesCount();
        for (int i = 0; i < count; ++i) {
            XMLElement element = documentElement.getChildAt(i);
            if (element.getChildesCount() <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean isBagTypeName(String type) {
        if (type.startsWith("attr")) {
            return true;
        }
        if (type.startsWith("^attr")) {
            return true;
        }
        if (type.startsWith("style")) {
            return true;
        }
        if (type.startsWith("plurals")) {
            return true;
        }
        return type.startsWith("array");
    }

    private String getType(XMLDocument xmlDocument, String def) {
        XMLElement documentElement = xmlDocument.getDocumentElement();
        if (documentElement.getChildesCount() == 0) {
            return def;
        }
        XMLElement first = documentElement.getChildAt(0);
        String type = first.getTagName();
        if (type == null) {
            return def;
        }
        if (type.endsWith("-array")) {
            return "array";
        }
        if (type.startsWith("attr-private")) {
            return "^attr-private";
        }
        if (type.equals("item")) {
            return def;
        }
        return type;
    }

    private String getType(XMLElement element, String def) {
        String type = element.getTagName();
        if (type == null) {
            return def;
        }
        if (type.endsWith("-array")) {
            return "array";
        }
        if (type.startsWith("attr-private")) {
            return "^attr-private";
        }
        if (type.equals("item")) {
            return def;
        }
        return type;
    }

    public XMLValuesEncoder getEncoder(String type) {
        XMLValuesEncoder encoder = this.xmlEncodersMap.get(type = EncodeUtil.sanitizeType(type));
        if (encoder != null) {
            return encoder;
        }
        return this.commonEncoder;
    }

    public XMLValuesEncoderBag getBagEncoder(String type) {
        XMLValuesEncoderBag encoder = this.xmlBagEncodersMap.get(type = EncodeUtil.sanitizeType(type));
        if (encoder != null) {
            return encoder;
        }
        return this.bagCommonEncoder;
    }
}

