/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmlencoder;

import com.reandroid.apk.ApkUtil;
import com.reandroid.apk.UncompressedFiles;
import com.reandroid.apk.xmlencoder.EncodeMaterials;
import com.reandroid.apk.xmlencoder.EncodeUtil;
import com.reandroid.apk.xmlencoder.XMLEncodeSource;
import com.reandroid.archive.APKArchive;
import com.reandroid.archive.FileInputSource;
import com.reandroid.archive.InputSource;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TypeBlock;
import com.reandroid.arsc.value.Entry;
import com.reandroid.xml.source.XMLFileSource;
import java.io.File;
import java.util.List;

public class FilePathEncoder {
    private final EncodeMaterials materials;
    private APKArchive apkArchive;
    private UncompressedFiles uncompressedFiles;

    public FilePathEncoder(EncodeMaterials encodeMaterials) {
        this.materials = encodeMaterials;
    }

    public void setApkArchive(APKArchive apkArchive) {
        this.apkArchive = apkArchive;
    }

    public void setUncompressedFiles(UncompressedFiles uncompressedFiles) {
        this.uncompressedFiles = uncompressedFiles;
    }

    public void encodePackageResDir(File resDir) {
        this.materials.logMessage("Scan: " + resDir.getParentFile().getName() + File.separator + resDir.getName());
        List<File> dirList = ApkUtil.listDirectories(resDir);
        for (File dir : dirList) {
            if (ApkUtil.isValuesDirectoryName(dir.getName(), true)) continue;
            this.encodeTypeDir(dir);
        }
    }

    public void encodeTypeDir(File dir) {
        List<File> fileList = ApkUtil.listFiles(dir, null);
        for (File file : fileList) {
            this.encodeTypeFileEntry(file);
        }
    }

    public InputSource encodeTypeFileEntry(File resFile) {
        String type = EncodeUtil.getTypeNameFromResFile(resFile);
        PackageBlock packageBlock = this.materials.getCurrentPackage();
        int typeId = packageBlock.getTypeStringPool().idOf(type);
        String qualifiers = EncodeUtil.getQualifiersFromResFile(resFile);
        TypeBlock typeBlock = packageBlock.getOrCreateTypeBlock((byte)typeId, qualifiers);
        String name = EncodeUtil.getEntryNameFromResFile(resFile);
        int resourceId = this.materials.resolveLocalResourceId(type, name);
        Entry entry = typeBlock.getOrCreateEntry((short)(0xFFFF & resourceId));
        String path = EncodeUtil.getEntryPathFromResFile(resFile);
        entry.setValueAsString(path);
        this.materials.setEntryName(entry, name);
        InputSource inputSource = this.createInputSource(path, resFile);
        if (inputSource instanceof XMLEncodeSource) {
            ((XMLEncodeSource)inputSource).setEntry(entry);
        }
        this.addInputSource(inputSource);
        return inputSource;
    }

    private InputSource createInputSource(String path, File resFile) {
        if (this.isXmlFile(resFile)) {
            return this.createXMLEncodeInputSource(path, resFile);
        }
        this.addUncompressedFiles(path);
        return this.createRawFileInputSource(path, resFile);
    }

    private InputSource createRawFileInputSource(String path, File resFile) {
        return new FileInputSource(resFile, path);
    }

    private InputSource createXMLEncodeInputSource(String path, File resFile) {
        XMLFileSource xmlSource = new XMLFileSource(path, resFile);
        return new XMLEncodeSource(this.materials, xmlSource);
    }

    private boolean isXmlFile(File resFile) {
        String name = resFile.getName();
        if (!name.endsWith(".xml")) {
            return false;
        }
        String type = EncodeUtil.getTypeNameFromResFile(resFile);
        return !type.equals("raw");
    }

    private void addInputSource(InputSource inputSource) {
        if (inputSource != null && this.apkArchive != null) {
            this.apkArchive.add(inputSource);
        }
    }

    private void addUncompressedFiles(String path) {
        if (this.uncompressedFiles != null) {
            this.uncompressedFiles.addPath(path);
        }
    }
}

