/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmlencoder;

import java.io.File;
import java.util.Comparator;
import java.util.List;

public class EncodeUtil {
    public static final String URI_ANDROID = "http://schemas.android.com/apk/res/android";
    public static final String URI_APP = "http://schemas.android.com/apk/res-auto";

    public static void sortStrings(List<String> stringList) {
        Comparator<String> cmp = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareTo(s2);
            }
        };
        stringList.sort(cmp);
    }

    public static boolean isPublicXml(File file) {
        if (!"public.xml".equals(file.getName())) {
            return false;
        }
        File dir = file.getParentFile();
        return dir != null && dir.getName().equals("values");
    }

    public static void sortPublicXml(List<File> fileList) {
        Comparator<File> cmp = new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                String n1 = f1.getAbsolutePath();
                String n2 = f2.getAbsolutePath();
                return n1.compareTo(n2);
            }
        };
        fileList.sort(cmp);
    }

    public static void sortValuesXml(List<File> fileList) {
        Comparator<File> cmp = new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                String n1 = EncodeUtil.getValuesXmlCompare(f1);
                String n2 = EncodeUtil.getValuesXmlCompare(f2);
                return n1.compareTo(n2);
            }
        };
        fileList.sort(cmp);
    }

    private static String getValuesXmlCompare(File file) {
        String name = file.getName().toLowerCase();
        if (name.equals("public.xml")) {
            return "0";
        }
        if (name.equals("ids.xml")) {
            return "1";
        }
        if (name.contains("attr")) {
            return "2";
        }
        return "3 " + name;
    }

    public static boolean isEmpty(String text) {
        if (text == null) {
            return true;
        }
        return (text = text.trim()).length() == 0;
    }

    public static String getQualifiersFromValuesXml(File valuesXml) {
        String dirName = valuesXml.getParentFile().getName();
        int i = dirName.indexOf(45);
        if (i > 0) {
            return dirName.substring(i);
        }
        return "";
    }

    public static String getEntryPathFromResFile(File resFile) {
        File typeDir = resFile.getParentFile();
        File resDir = typeDir.getParentFile();
        return resDir.getName() + "/" + typeDir.getName() + "/" + resFile.getName();
    }

    public static String getEntryNameFromResFile(File resFile) {
        String ninePatch;
        String name = resFile.getName();
        if (name.endsWith(ninePatch = ".9.png")) {
            return name.substring(0, name.length() - ninePatch.length());
        }
        int i = name.lastIndexOf(46);
        if (i > 0) {
            name = name.substring(0, i);
        }
        return name;
    }

    public static String getQualifiersFromResFile(File resFile) {
        String name = resFile.getParentFile().getName();
        int i = name.indexOf(45);
        if (i > 0) {
            return name.substring(i);
        }
        return "";
    }

    public static String getTypeNameFromResFile(File resFile) {
        String name = resFile.getParentFile().getName();
        int i = name.indexOf(45);
        if (i > 0) {
            name = name.substring(0, i);
        }
        if (!name.equals("plurals") && name.endsWith("s")) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    public static String getTypeNameFromValuesXml(File valuesXml) {
        String name = valuesXml.getName();
        if (!(name = name.substring(0, name.length() - 4)).equals("plurals") && name.endsWith("s")) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    public static String sanitizeType(String type) {
        if (type.length() < 2) {
            return type;
        }
        char first = type.charAt(0);
        if (first == '^' || first == '+' || first == '*') {
            type = type.substring(1);
        }
        char[] chars = type.toCharArray();
        StringBuilder builder = new StringBuilder();
        for (char ch : chars) {
            if (ch > 'z' || ch < 'a') break;
            builder.append(ch);
        }
        type = builder.toString();
        if (!"plurals".equals(type) && type.endsWith("s")) {
            type = type.substring(0, type.length() - 1);
        }
        return type;
    }
}

