/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmlencoder;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.FrameworkApk;
import com.reandroid.apk.xmlencoder.EncodeException;
import com.reandroid.apk.xmlencoder.EncodeUtil;
import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.chunk.Chunk;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.TypeBlock;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.coder.ReferenceString;
import com.reandroid.arsc.coder.ValueCoder;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.group.EntryGroup;
import com.reandroid.arsc.item.SpecString;
import com.reandroid.arsc.util.FrameworkTable;
import com.reandroid.arsc.util.ResNameMap;
import com.reandroid.arsc.value.Entry;
import com.reandroid.identifiers.PackageIdentifier;
import com.reandroid.identifiers.ResourceIdentifier;
import com.reandroid.identifiers.TableIdentifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class EncodeMaterials {
    private PackageBlock currentPackage;
    private final Set<FrameworkTable> frameworkTables = new HashSet<FrameworkTable>();
    private APKLogger apkLogger;
    private boolean mForceCreateNamespaces = true;
    private Set<String> mFrameworkPackageNames;
    private final ResNameMap<Entry> mLocalResNameMap = new ResNameMap();
    private final TableIdentifier tableIdentifier = new TableIdentifier();
    private PackageIdentifier currentPackageIdentifier;
    private Integer mMainPackageId;

    public void setMainPackageId(Integer mainPackageId) {
        this.mMainPackageId = mainPackageId;
    }

    public PackageBlock pickMainPackageBlock(TableBlock tableBlock) {
        if (this.mMainPackageId != null) {
            return tableBlock.pickOne(this.mMainPackageId);
        }
        return tableBlock.pickOne();
    }

    public TableIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    public void setEntryName(Entry entry, String name) {
        PackageBlock packageBlock = entry.getPackageBlock();
        SpecString specString = (SpecString)packageBlock.getSpecStringPool().getOrCreate(name);
        entry.setSpecReference(specString);
    }

    public Entry getAttributeBlock(String refString) {
        String type = "attr";
        Entry entry = this.getAttributeBlock(type, refString);
        if (entry == null) {
            type = "^attr-private";
            entry = this.getAttributeBlock(type, refString);
        }
        return entry;
    }

    private Entry getAttributeBlock(String type, String refString) {
        Entry entry;
        String packageName = null;
        String name = refString;
        int i = refString.lastIndexOf(58);
        if (i >= 0) {
            packageName = refString.substring(0, i);
            name = refString.substring(i + 1);
        }
        if (!EncodeUtil.isEmpty(packageName) && !this.isFrameworkPackageName(packageName) && (entry = this.getLocalEntry(packageName, type, name)) != null) {
            return entry;
        }
        if (EncodeUtil.isEmpty(packageName) || packageName.equals(this.getCurrentPackageName()) || !this.isFrameworkPackageName(packageName)) {
            return this.getLocalEntry(type, name);
        }
        return this.getFrameworkEntry(type, name);
    }

    public EncodeResult encodeReference(String value) {
        if (value == null || value.length() < 3) {
            return null;
        }
        EncodeResult encodeResult = ValueCoder.encodeUnknownResourceId(value);
        if (encodeResult != null) {
            return encodeResult;
        }
        ReferenceString referenceString = ReferenceString.parseReference(value);
        if (referenceString != null) {
            int resourceId = this.resolveReference(referenceString);
            return new EncodeResult(referenceString.getValueType(), resourceId);
        }
        return null;
    }

    public int resolveReference(String refString) {
        ReferenceString referenceString = ReferenceString.parseReference(refString);
        if (referenceString == null) {
            EncodeResult ref = ValueCoder.encodeUnknownResourceId(refString);
            if (ref != null) {
                return ref.value;
            }
            throw new EncodeException("Not proper reference string: '" + refString + "'");
        }
        return this.resolveReference(referenceString);
    }

    public int resolveReference(ReferenceString referenceString) {
        String packageName = referenceString.packageName;
        String type = referenceString.type;
        String name = referenceString.name;
        if (this.isLocalPackageName(packageName)) {
            return this.resolveLocalResourceId(packageName, type, name);
        }
        if (packageName != null && (packageName.equals(this.getCurrentPackageName()) || !this.isFrameworkPackageName(packageName))) {
            return this.resolveLocalResourceId(packageName, type, name);
        }
        if (packageName == null) {
            return this.resolveLocalResourceId(type, name);
        }
        return this.resolveFrameworkResourceId(packageName, type, name);
    }

    private int resolveLocalResourceId(String packageName, String type, String name) {
        ResourceIdentifier ri = this.tableIdentifier.get(packageName, type, name);
        if (ri != null) {
            return ri.getResourceId();
        }
        EntryGroup entryGroup = this.getLocalEntryGroup(type, name);
        if (entryGroup != null) {
            return entryGroup.getResourceId();
        }
        throw new EncodeException("Local entry not found: @" + packageName + ":" + type + "/" + name + ", " + this.getFrameworkInfo());
    }

    public int resolveLocalResourceId(String type, String name) {
        Object ri;
        PackageIdentifier pi = this.currentPackageIdentifier;
        if (pi != null && (ri = pi.getResourceIdentifier(type, name)) != null) {
            return ((ResourceIdentifier)ri).getResourceId();
        }
        for (PackageIdentifier packageIdentifier : this.tableIdentifier.getPackages()) {
            ResourceIdentifier ri2;
            if (packageIdentifier == pi || (ri2 = packageIdentifier.getResourceIdentifier(type, name)) == null) continue;
            return ri2.getResourceId();
        }
        EntryGroup entryGroup = this.getLocalEntryGroup(type, name);
        if (entryGroup != null) {
            return entryGroup.getResourceId();
        }
        throw new EncodeException("Local entry not found: @" + type + "/" + name + ", " + this.getFrameworkInfo());
    }

    public int resolveFrameworkResourceId(String packageName, String type, String name) {
        Entry entry = this.getFrameworkEntry(packageName, type, name);
        if (entry != null) {
            return entry.getResourceId();
        }
        throw new EncodeException("Framework entry not found: @" + packageName + ":" + type + "/" + name + ", " + this.getFrameworkInfo());
    }

    public EntryGroup getLocalEntryGroup(String type, String name) {
        for (EntryGroup entryGroup : this.currentPackage.listEntryGroup()) {
            if (!type.equals(entryGroup.getTypeName()) || !name.equals(entryGroup.getSpecName())) continue;
            return entryGroup;
        }
        for (PackageBlock packageBlock : this.currentPackage.getTableBlock().listPackages()) {
            for (EntryGroup entryGroup : packageBlock.listEntryGroup()) {
                if (!type.equals(entryGroup.getTypeName()) || !name.equals(entryGroup.getSpecName())) continue;
                return entryGroup;
            }
        }
        return null;
    }

    public Entry getLocalEntry(String packageName, String type, String name) {
        if (this.currentPackage == null) {
            return null;
        }
        ResourceIdentifier ri = this.tableIdentifier.get(packageName, type, name);
        if (ri == null) {
            return null;
        }
        EntryGroup entryGroup = this.currentPackage.getTableBlock().getEntryGroup(ri.getResourceId());
        if (entryGroup == null) {
            return null;
        }
        return entryGroup.pickOne();
    }

    public Entry getLocalEntry(String type, String name) {
        Entry entry = this.mLocalResNameMap.get(type, name);
        if (entry != null) {
            return entry;
        }
        this.loadLocalEntryMap(type);
        entry = this.mLocalResNameMap.get(type, name);
        if (entry != null) {
            return entry;
        }
        entry = this.searchLocalEntry(type, name);
        if (entry != null) {
            this.mLocalResNameMap.add(type, name, entry);
        }
        return entry;
    }

    private Entry searchLocalEntry(String type, String name) {
        Iterator<Block> iterator;
        Iterator<Chunk> iterator2;
        for (EntryGroup entryGroup : this.currentPackage.listEntryGroup()) {
            if (!type.equals(entryGroup.getTypeName()) || !name.equals(entryGroup.getSpecName())) continue;
            return entryGroup.pickOne();
        }
        SpecTypePair specTypePair = this.currentPackage.getSpecTypePair(type);
        if (specTypePair != null && (iterator2 = specTypePair.listTypeBlocks().iterator()).hasNext()) {
            TypeBlock typeBlock = (TypeBlock)iterator2.next();
            iterator = typeBlock.listEntries(true).iterator();
            while (iterator.hasNext()) {
                Entry entry = iterator.next();
                if (!name.equals(entry.getName())) continue;
                return entry;
            }
        }
        for (PackageBlock packageBlock : this.currentPackage.getTableBlock().listPackages()) {
            if (packageBlock == this.currentPackage || (specTypePair = packageBlock.getSpecTypePair(type)) == null || !(iterator = specTypePair.listTypeBlocks().iterator()).hasNext()) continue;
            TypeBlock typeBlock = (TypeBlock)iterator.next();
            for (Entry entry : typeBlock.listEntries(true)) {
                if (!name.equals(entry.getName())) continue;
                return entry;
            }
        }
        return null;
    }

    private void loadLocalEntryMap(String type) {
        ResNameMap<Entry> localMap = this.mLocalResNameMap;
        for (PackageBlock packageBlock : this.currentPackage.getTableBlock().listPackages()) {
            SpecTypePair specTypePair = packageBlock.getSpecTypePair(type);
            if (specTypePair == null) continue;
            for (TypeBlock typeBlock : specTypePair.listTypeBlocks()) {
                for (Entry entry : typeBlock.listEntries(true)) {
                    localMap.add(entry.getTypeName(), entry.getName(), entry);
                }
            }
        }
    }

    public Entry getFrameworkEntry(String type, String name) {
        for (FrameworkTable table : this.frameworkTables) {
            Entry entry = table.searchEntry(type, name);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    private boolean isFrameworkPackageName(String packageName) {
        return this.getFrameworkPackageNames().contains(packageName);
    }

    private Set<String> getFrameworkPackageNames() {
        if (this.mFrameworkPackageNames != null) {
            return this.mFrameworkPackageNames;
        }
        HashSet<String> results = new HashSet<String>();
        for (FrameworkTable table : this.frameworkTables) {
            for (PackageBlock packageBlock : table.listPackages()) {
                results.add(packageBlock.getName());
            }
        }
        this.mFrameworkPackageNames = results;
        return results;
    }

    public Entry getFrameworkEntry(String packageName, String type, String name) {
        for (FrameworkTable table : this.frameworkTables) {
            for (PackageBlock packageBlock : table.listPackages()) {
                Entry entry;
                if (!packageName.equals(packageBlock.getName()) || (entry = table.searchEntry(type, name)) == null) continue;
                return entry;
            }
        }
        return null;
    }

    public Entry getFrameworkEntry(int packageId, String type, String name) {
        for (FrameworkTable table : this.frameworkTables) {
            for (PackageBlock packageBlock : table.listPackages()) {
                Entry entry;
                if (packageId != packageBlock.getId() || (entry = table.searchEntry(type, name)) == null) continue;
                return entry;
            }
        }
        return null;
    }

    public EncodeMaterials setForceCreateNamespaces(boolean force) {
        this.mForceCreateNamespaces = force;
        return this;
    }

    public EncodeMaterials setCurrentPackage(PackageBlock currentPackage) {
        this.currentPackage = currentPackage;
        this.onCurrentPackageChanged(currentPackage);
        return this;
    }

    public EncodeMaterials setCurrentPackageIdentifier(PackageIdentifier packageIdentifier) {
        this.currentPackageIdentifier = packageIdentifier;
        return this;
    }

    private void onCurrentPackageChanged(PackageBlock currentPackage) {
        if (currentPackage == null) {
            return;
        }
        PackageIdentifier pi = this.tableIdentifier.getByPackage(currentPackage);
        if (pi == null) {
            pi = this.tableIdentifier.load(currentPackage);
        }
        this.currentPackageIdentifier = pi;
    }

    private boolean isLocalPackageName(String packageName) {
        if (packageName == null) {
            return false;
        }
        for (PackageIdentifier pi : this.tableIdentifier.getPackages()) {
            if (!packageName.equals(pi.getName())) continue;
            return true;
        }
        return false;
    }

    private String getFrameworkInfo() {
        if (this.frameworkTables.size() == 0) {
            return "Frameworks = No frameworks found";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Frameworks = ").append(this.frameworkTables.size());
        builder.append(" [");
        boolean appendOnce = false;
        for (FrameworkTable frameworkTable : this.frameworkTables) {
            if (appendOnce) {
                builder.append(", ");
            }
            builder.append(frameworkTable.getVersionCode());
            builder.append('(').append(frameworkTable.getFrameworkName()).append(')');
            appendOnce = true;
        }
        builder.append(']');
        return builder.toString();
    }

    public EncodeMaterials addFramework(FrameworkApk frameworkApk) {
        if (frameworkApk != null) {
            this.addFramework(frameworkApk.getTableBlock());
        }
        return this;
    }

    public EncodeMaterials addFramework(FrameworkTable frameworkTable) {
        frameworkTable.loadResourceNameMap();
        this.frameworkTables.add(frameworkTable);
        this.mFrameworkPackageNames = null;
        return this;
    }

    public EncodeMaterials setAPKLogger(APKLogger logger) {
        this.apkLogger = logger;
        return this;
    }

    public PackageBlock getCurrentPackage() {
        return this.currentPackage;
    }

    public boolean isForceCreateNamespaces() {
        return this.mForceCreateNamespaces;
    }

    public String getCurrentPackageName() {
        return this.currentPackage.getName();
    }

    public int getCurrentPackageId() {
        return this.currentPackage.getId();
    }

    public void logMessage(String msg) {
        if (this.apkLogger != null) {
            this.apkLogger.logMessage(msg);
        }
    }

    public void logError(String msg, Throwable tr) {
        if (this.apkLogger != null) {
            this.apkLogger.logError(msg, tr);
        }
    }

    public void logVerbose(String msg) {
        if (this.apkLogger != null) {
            this.apkLogger.logVerbose(msg);
        }
    }

    public static EncodeMaterials create(TableBlock tableBlock) {
        PackageBlock packageBlock = tableBlock.pickOne();
        if (packageBlock == null) {
            throw new EncodeException("No packages found on table block");
        }
        return EncodeMaterials.create(packageBlock);
    }

    public static EncodeMaterials create(PackageBlock packageBlock) {
        EncodeMaterials encodeMaterials = new EncodeMaterials();
        TableBlock tableBlock = packageBlock.getTableBlock();
        encodeMaterials.getTableIdentifier().load(tableBlock);
        encodeMaterials.setCurrentPackage(packageBlock);
        for (TableBlock frameworkTable : tableBlock.getFrameWorks()) {
            if (!(frameworkTable instanceof FrameworkTable)) continue;
            encodeMaterials.addFramework((FrameworkTable)frameworkTable);
        }
        return encodeMaterials;
    }
}

