/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmldecoder;

import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import java.util.Collection;

public class XMLNamespaceValidator {
    private static final String URI_ANDROID = "http://schemas.android.com/apk/res/android";
    private static final String URI_APP = "http://schemas.android.com/apk/res-auto";
    private static final String PREFIX_ANDROID = "android";
    private static final String PREFIX_APP = "app";
    private final ResXmlDocument xmlBlock;

    public XMLNamespaceValidator(ResXmlDocument xmlBlock) {
        this.xmlBlock = xmlBlock;
    }

    public void validate() {
        XMLNamespaceValidator.validateNamespaces(this.xmlBlock);
    }

    public static boolean isValid(ResXmlAttribute attribute) {
        int resourceId = attribute.getNameResourceID();
        if (resourceId == 0) {
            return attribute.getUri() == null;
        }
        if (XMLNamespaceValidator.isAndroid(XMLNamespaceValidator.toPackageId(resourceId))) {
            return XMLNamespaceValidator.isValidAndroidNamespace(attribute);
        }
        return XMLNamespaceValidator.isValidAppNamespace(attribute);
    }

    public static void validateNamespaces(ResXmlDocument resXmlDocument) {
        XMLNamespaceValidator.validateNamespaces(resXmlDocument.getResXmlElement());
    }

    public static void validateNamespaces(ResXmlElement element) {
        XMLNamespaceValidator.validateNamespaces(element.listAttributes());
        for (ResXmlElement child : element.listElements()) {
            XMLNamespaceValidator.validateNamespaces(child);
        }
    }

    private static void validateNamespaces(Collection<ResXmlAttribute> attributeList) {
        for (ResXmlAttribute attribute : attributeList) {
            XMLNamespaceValidator.validateNamespace(attribute);
        }
    }

    private static void validateNamespace(ResXmlAttribute attribute) {
        int resourceId = attribute.getNameResourceID();
        if (resourceId == 0) {
            attribute.setNamespaceReference(-1);
            return;
        }
        if (XMLNamespaceValidator.isAndroid(XMLNamespaceValidator.toPackageId(resourceId))) {
            if (!XMLNamespaceValidator.isValidAndroidNamespace(attribute)) {
                attribute.setNamespace(URI_ANDROID, PREFIX_ANDROID);
            }
        } else if (!XMLNamespaceValidator.isValidAppNamespace(attribute)) {
            attribute.setNamespace(URI_APP, PREFIX_APP);
        }
    }

    private static boolean isValidAppNamespace(ResXmlAttribute attribute) {
        String uri = attribute.getUri();
        String prefix = attribute.getNamePrefix();
        if (URI_ANDROID.equals(uri) || PREFIX_ANDROID.equals(prefix)) {
            return false;
        }
        return !XMLNamespaceValidator.isEmpty(uri) && !XMLNamespaceValidator.isEmpty(prefix);
    }

    private static boolean isValidAndroidNamespace(ResXmlAttribute attribute) {
        return URI_ANDROID.equals(attribute.getUri()) && PREFIX_ANDROID.equals(attribute.getNamePrefix());
    }

    private static boolean isAndroid(int pkgId) {
        return pkgId == 1;
    }

    private static int toPackageId(int resId) {
        return resId >> 24 & 0xFF;
    }

    private static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        return (str = str.trim()).length() == 0;
    }
}

